clear all;
clc;
format long;  %initialize format
c1=1.5;  %initialize the acceleration constants
c2=1.5;   
w=0.726;  % initialize the inertia weight
MaxIT=300;  % the maximum iterations
D=21;   % the dimension of a particle
M=30;  % initialize the population
T=4;   %the number of time points
N=7;   %the number of genes
a=zeros(1,7);
b=zeros(1,7);
k=zeros(1,7);
x=zeros(M,D);
v=zeros(M,D);
tic
for i=1:M
for j=1:7
    a(j)=-0.001+0.002*rand;
    b(j)=-0.1+0.3*rand;
    k(j)=0.5+1.5*rand;
end
x(i,:)=[a,b,k];   %initilize the position
v(i,:)=-1.2+2.4*rand(1,D); %initialize the velocity
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   
for i=1:M
p(i)=fitness(x(i,:)); %calculate the fitness of each particle and initialize pi
y(i,:)=x(i,:);
end
pg=x(1,:); %initialize pg
for i=2:M
    if p(i)<fitness(pg)   %search the global optimal solution of first iteration
        pg=x(i,:);
    %finalfitness=p(i);
end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%main loop%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for t=1:MaxIT
for i=1:M
    v(i,:)=w*v(i,:)+c1*rand*(y(i,:)-x(i,:))+c2*rand*(pg-x(i,:));
    x(i,:)=x(i,:)+v(i,:);
    if fitness(x(i,:))<p(i);
        p(i)=fitness(x(i,:)); %search the individual optimal solution so far
        y(i,:)=x(i,:);
    end
    if p(i)<fitness(pg) % search the global optimal solution so far
        pg=y(i,:);
    end
end
Pbest(t)=fitness(pg);
end
t=1:MaxIT;
plot(t,Pbest(t),'-r')
h_Opt=odeset('Refine',1);
[Time,YYY]=ode45(@vdp1000,[0:1:55],[-0.37 -0.67 -1.07 -1.39 -1.64 -2.17 -2.37],h_Opt,pg);% estimate the solution of the global optimal position, the data in [ ] is the current real genes expression values
CC=YYY'; 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%output display%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
disp('*****************************')
disp('the global optimal soultion of function is:')
solution=pg
disp('the final optimal fitness is:')
Result=fitness(pg)
disp('*****************************')