/*
  +----------------------------------------------------------------------+
  | PHP Version 4                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2003 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 2.02 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available at through the world-wide-web at                           |
  | http://www.php.net/license/2_02.txt.                                 |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: riverfor <riverfor@gmail.com>                                |
  +----------------------------------------------------------------------+

  $Id: header,v 1.10.8.1 2003/07/14 15:59:18 sniper Exp $ 
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "php.h"
#include "php_ini.h"
#include "ext/standard/info.h"
#include "php_clearsilver.h"
#include "ClearSilver.h"
#define _DEBUG 1

/* If you declare any globals in php_clearsilver.h uncomment this:
ZEND_DECLARE_MODULE_GLOBALS(clearsilver)
*/

/* True global resources - no need for thread safety here */
static int le_hdf;
static int le_cs;
#define le_hdf_name "HDF Object"
#define le_cs_name  "CS Object"

/* {{{ clearsilver_functions[]
 *
 * Every user visible function must have an entry in clearsilver_functions[].
 */
function_entry clearsilver_functions[] = {
	PHP_FE(hdf_init_nsf,		NULL)		/* For testing, remove later. */
	PHP_FE(hdf_destroy_nsf,		NULL)
	PHP_FE(hdf_set_value_nsf,   NULL)
	PHP_FE(hdf_get_value_nsf,   NULL)
	PHP_FE(hdf_write_file_nsf,  NULL)
	PHP_FE(hdf_read_file_nsf,   NULL)
	PHP_FE(cs_init_nsf,			NULL)
	PHP_FE(cs_destroy_nsf,		NULL)
	PHP_FE(cs_parse_file_nsf,	NULL)
	PHP_FE(cs_render_nsf,		NULL)
	{NULL, NULL, NULL}	/* Must be the last line in clearsilver_functions[] */
};
/* }}} */

/* {{{ clearsilver_module_entry
 */
zend_module_entry clearsilver_module_entry = {
#if ZEND_MODULE_API_NO >= 20010901
	STANDARD_MODULE_HEADER,
#endif
	"clearsilver",
	clearsilver_functions,
	PHP_MINIT(clearsilver),
	PHP_MSHUTDOWN(clearsilver),
	PHP_RINIT(clearsilver),		/* Replace with NULL if there's nothing to do at request start */
	PHP_RSHUTDOWN(clearsilver),	/* Replace with NULL if there's nothing to do at request end */
	PHP_MINFO(clearsilver),
#if ZEND_MODULE_API_NO >= 20010901
	"0.1", /* Replace with version number for your extension */
#endif
	STANDARD_MODULE_PROPERTIES
};
/* }}} */

#ifdef COMPILE_DL_CLEARSILVER
ZEND_GET_MODULE(clearsilver)
#endif

/* {{{ PHP_INI
 */
/* Remove comments and fill if you need to have entries in php.ini
PHP_INI_BEGIN()
    STD_PHP_INI_ENTRY("clearsilver.global_value",      "42", PHP_INI_ALL, OnUpdateInt, global_value, zend_clearsilver_globals, clearsilver_globals)
    STD_PHP_INI_ENTRY("clearsilver.global_string", "foobar", PHP_INI_ALL, OnUpdateString, global_string, zend_clearsilver_globals, clearsilver_globals)
PHP_INI_END()
*/
/* }}} */

/* {{{ php_clearsilver_init_globals
 */
/* Uncomment this function if you have INI entries
static void php_clearsilver_init_globals(zend_clearsilver_globals *clearsilver_globals)
{
	clearsilver_globals->global_value = 0;
	clearsilver_globals->global_string = NULL;
}
*/
/* }}} */
static void _php_cs_free(zend_rsrc_list_entry *rsrc TSRMLS_DC) {
	CSPARSE *cs = (CSPARSE *)rsrc->ptr;
	//cs_destroy(&cs);
}

static void _php_hdf_free(zend_rsrc_list_entry *rsrc TSRMLS_DC) {
	HDF *hdf = (HDF *)rsrc->ptr;
	//hdf_destroy(&hdf);
}

/* {{{ PHP_MINIT_FUNCTION
 */
PHP_MINIT_FUNCTION(clearsilver)
{
	/* If you have INI entries, uncomment these lines 
	ZEND_INIT_MODULE_GLOBALS(clearsilver, php_clearsilver_init_globals, NULL);
	REGISTER_INI_ENTRIES();
	*/
	le_hdf = zend_register_list_destructors_ex(_php_hdf_free, NULL, le_hdf_name, module_number);
	le_cs  = zend_register_list_destructors_ex(_php_cs_free, NULL, le_cs_name, module_number);
	return SUCCESS;
}
/* }}} */

/* {{{ PHP_MSHUTDOWN_FUNCTION
 */
PHP_MSHUTDOWN_FUNCTION(clearsilver)
{
	/* uncomment this line if you have INI entries
	UNREGISTER_INI_ENTRIES();
	*/
	return SUCCESS;
}
/* }}} */

/* Remove if there's nothing to do at request start */
/* {{{ PHP_RINIT_FUNCTION
 */
PHP_RINIT_FUNCTION(clearsilver)
{
	return SUCCESS;
}
/* }}} */

/* Remove if there's nothing to do at request end */
/* {{{ PHP_RSHUTDOWN_FUNCTION
 */
PHP_RSHUTDOWN_FUNCTION(clearsilver)
{
	return SUCCESS;
}
/* }}} */

/* {{{ PHP_MINFO_FUNCTION
 */
PHP_MINFO_FUNCTION(clearsilver)
{
	php_info_print_table_start();
	php_info_print_table_header(2, "clearsilver support", "enabled");
	php_info_print_table_end();

	/* Remove comments if you have entries in php.ini
	DISPLAY_INI_ENTRIES();
	*/
}
/* }}} */


/* Remove the following function when you have succesfully modified config.m4
   so that your module can be compiled into PHP, it exists only for testing
   purposes. */

/* Every user-visible function in PHP should document itself in the source */
PHP_FUNCTION(hdf_init_nsf)
{
	NEOERR *ret;
	HDF *hdf;
	ret = hdf_init(&hdf);
	ZEND_REGISTER_RESOURCE(return_value, hdf, le_hdf);
}

PHP_FUNCTION(hdf_destroy_nsf)
{
	zval *zhdf_dp;
	HDF  *hdf = NULL;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "r", &zhdf_dp) == FAILURE) {
		return;
	}
	ZEND_FETCH_RESOURCE(hdf, HDF *, &zhdf_dp, -1, le_hdf_name, le_hdf);
	hdf_destroy(&hdf);
}


PHP_FUNCTION(hdf_set_value_nsf)
{
	zval **zhdf_dp, **key, **val;
	HDF  *hdf = NULL;

	if (ZEND_NUM_ARGS() != 3 || zend_get_parameters_ex(3, &zhdf_dp, &key, &val) == FAILURE) {
		WRONG_PARAM_COUNT;
	}

	ZEND_FETCH_RESOURCE(hdf, HDF *, zhdf_dp, -1, le_hdf_name, le_hdf);
	convert_to_string_ex(key);
	convert_to_string_ex(val);
	hdf_set_value((HDF *)hdf, Z_STRVAL_PP(key), Z_STRVAL_PP(val));

	RETURN_TRUE;
}

PHP_FUNCTION(hdf_get_value_nsf)
{
	zval **zhdf_dp, **key;
	HDF  *hdf = NULL;
	char *val = NULL;

	if (ZEND_NUM_ARGS() != 2 || zend_get_parameters_ex(2, &zhdf_dp, &key) == FAILURE) {
		WRONG_PARAM_COUNT;
	}

	ZEND_FETCH_RESOURCE(hdf, HDF *, zhdf_dp, -1, le_hdf_name, le_hdf);
	convert_to_string_ex(key);
	val = hdf_get_value((HDF *)hdf, Z_STRVAL_PP(key), "");
	RETURN_STRING(val, 1); 
}


PHP_FUNCTION(hdf_write_file_nsf)
{
	zval **zhdf_dp, **path;
	HDF  *hdf = NULL;

	if (ZEND_NUM_ARGS() != 2 || zend_get_parameters_ex(2, &zhdf_dp, &path) == FAILURE) {
		WRONG_PARAM_COUNT;
	}

	ZEND_FETCH_RESOURCE(hdf, HDF *, zhdf_dp, -1, le_hdf_name, le_hdf);
	convert_to_string_ex(path);

	if (hdf_write_file(hdf, Z_STRVAL_PP(path)) != (NEOERR *)0) {
		php_error(E_WARNING, "Failed to write HDF into file");
		RETURN_FALSE;
	} else {
		RETURN_TRUE;
	}
}

PHP_FUNCTION(hdf_read_file_nsf)
{	
	zval **zhdf_dp, **path;
	HDF  *hdf = NULL;

	if (ZEND_NUM_ARGS() != 2 || zend_get_parameters_ex(2, &zhdf_dp, &path) == FAILURE) {
		WRONG_PARAM_COUNT;
	}

	ZEND_FETCH_RESOURCE(hdf, HDF *, zhdf_dp, -1, le_hdf_name, le_hdf);
	convert_to_string_ex(path);

	if (hdf_read_file(hdf, Z_STRVAL_PP(path)) != (NEOERR *)0) {
		php_error(E_WARNING, "Failed to read HDF file");
		RETURN_FALSE;
	} else {
		RETURN_TRUE;
	}
}

// CS Object operations
PHP_FUNCTION(cs_init_nsf)
{
	zval *zhdf_dp;
	HDF  *hdf = NULL;
	CSPARSE *parse;

	if (ZEND_NUM_ARGS() != 1 || zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "r", &zhdf_dp) == FAILURE) {
		WRONG_PARAM_COUNT;
	}
	ZEND_FETCH_RESOURCE(hdf, HDF *, &zhdf_dp, -1, le_hdf_name, le_hdf);
	
	if (cs_init(&parse, (HDF *)hdf) != (NEOERR *)0) {
		php_error(E_WARNING, "Failed to init the CS Object.\n");
		RETURN_FALSE;
	}
	ZEND_REGISTER_RESOURCE(return_value, parse, le_cs)
}

PHP_FUNCTION(cs_destroy_nsf)
{
	zval *zcs_dp;
	CSPARSE  *cs = NULL;
	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "r", &zcs_dp) == FAILURE) {
		return;
	}
	ZEND_FETCH_RESOURCE(cs, CSPARSE *, &zcs_dp, -1, le_cs_name, le_cs);
	cs_destroy(&cs);

}

PHP_FUNCTION(cs_parse_file_nsf)
{
	zval **zcs_dp, **path;
	CSPARSE  *cs = NULL;

	if (ZEND_NUM_ARGS() != 2 || zend_get_parameters_ex(2, &zcs_dp, &path) == FAILURE) {
		WRONG_PARAM_COUNT;
	}

	ZEND_FETCH_RESOURCE(cs, CSPARSE *, zcs_dp, -1, le_cs_name, le_cs);
	convert_to_string_ex(path);

	if (cs_parse_file((CSPARSE *)cs, Z_STRVAL_PP(path)) != (NEOERR *)0) {
		php_error(E_WARNING, "Failed to parse CS Object.\n");
		RETURN_FALSE;
	} else {
		RETURN_TRUE;
	}
}

NEOERR *_render_cb(void *ctx, char *buf) {
	STRING *str= (STRING *)ctx;
	return nerr_pass(string_append(str, buf));
}

PHP_FUNCTION(cs_render_nsf)
{
	zval *zcs_dp;
	CSPARSE  *cs = NULL;
	STRING str;
	NEOERR *err;
	string_init(&str);

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "r", &zcs_dp) == FAILURE) {
		WRONG_PARAM_COUNT;
	}
	ZEND_FETCH_RESOURCE(cs, CSPARSE *, &zcs_dp, -1, le_cs_name, le_cs);

	err = cs_render((CSPARSE *)cs, &str, _render_cb);

	RETURN_STRING(str.buf, 1);
	string_clear(&str);
}


/* The previous line is meant for vim and emacs, so it can correctly fold and 
   unfold functions in source code. See the corresponding marks just before 
   function definition, where the functions purpose is also documented. Please 
   follow this convention for the convenience of others editing your code.
*/


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
