#! /usr/bin/env python

'''
Copyright (c) 2005, WukooPy Team (lihuimail@gmail.com)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the WukooPy Team nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

import base64
import time
from quixote.publish import get_publisher,get_request,get_response,get_field,get_cookie,get_path,redirect,get_session,get_session_manager,get_user

from wukoopy.lib.application import Application
from wukoopy import public_publish


wkp=Application()
wkp.get_publisher=get_publisher
wkp.get_request=get_request
wkp.get_response=get_response
wkp.get_field=get_field
wkp.get_cookie=get_cookie
wkp.get_path=get_path
wkp.redirect=redirect
wkp.get_session=get_session
wkp.get_session_manager=get_session_manager
wkp.get_user=get_user

def get_url():
    result=get_request().get_url()
    if get_request().get_query():
        result+='?'+get_request().get_query()
    return result
def get_clientip():
    return get_request().environ.get('REMOTE_ADDR','')
def get_config():
    return get_publisher().config
def get_form(v,default=None):
    return get_request().get_field(v,default)
def get_forms():
    return get_request().get_fields()
def get_post():
    request=get_request()
    if request.get_method() != 'POST':
        request.response.set_status(405, "Only the POST method is accepted")
        return "XML-RPC handlers only accept the POST method."
    length = int(request.environ['CONTENT_LENGTH'])
    result = request.stdin.read(length)
    return result

def get_post1():
    request=get_request()
    length = int(request.get_environ('CONTENT_LENGTH',0))
    if length<>0:
        result = request.stdin.read(length)
    else:
        result=None
    return result

def get_cookies():
    return get_request().get_cookies()
def get_environ(v,default=None):
    return get_request().get_environ(v,default)
def get_header(v,default=None):
    return get_request().get_header(v,default)
def get_method():
    return get_request().get_method()
def get_server():
    return get_request().get_server()
def get_query():
    return get_request().get_query()
def get_encoding():
    return get_request().get_encoding()
def get_accepted_types():
    return get_request().get_accepted_types()

def get_user(m,default=None):
    v=get_session().get_user()
    if v is None:
        result=default
    else:
        result=v.get(m,default)
    return result
def set_user(m,n):
    v=get_session().get_user()
    if v is None:
        k={}
        k[m]=n
    else:
        k=v
        k[m]=n
    get_session().set_user(k)
def get_referer(default=None):
    return get_request().get_header('Referer',default)
def get_host_referer():
    result=None
    v=get_referer()
    if v is not None:
        import urlparse
        result=urlparse.urlsplit(v)[1]
        if result.find('@')<>-1:
            result=result.split('@')[1]
    return result
def get_baseurl():
    return '%s%s/'%(get_scheme(),get_server())
def get_baseauth():
    ha = get_request().get_environ('HTTP_AUTHORIZATION',None)
    if ha:
        auth_type, auth_string = ha.split()
        result= tuple(base64.decodestring(auth_string).split(':'))
    else:
        result=None
    return result

wkp.get_url=get_url
wkp.get_clientip=get_clientip
wkp.get_config=get_config
wkp.get_form=get_form
wkp.get_forms=get_forms
wkp.get_post=get_post
wkp.get_post1=get_post1
wkp.get_cookies=get_cookies
wkp.get_environ=get_environ
wkp.get_header=get_header
wkp.get_method=get_method
wkp.get_server=get_server
wkp.get_query=get_query
wkp.get_encoding=get_encoding
wkp.get_accepted_types=get_accepted_types
wkp.get_user=get_user
wkp.set_user=set_user
wkp.get_referer=get_referer
wkp.get_host_referer=get_host_referer
wkp.get_baseurl=get_baseurl
wkp.get_baseauth=get_baseauth

def set_content_type(content_type, charset='iso-8859-1'):
    get_response().set_content_type(content_type, charset)
def set_charset(charset):
    get_response().set_charset(charset)
def set_status(status, reason=None):
    get_response().set_status(status, reason)
def set_header(name, value):
    get_response().set_header(name, value)
def set_expires(seconds=0, minutes=0, hours=0, days=0):
    get_response().set_expires(seconds, minutes, hours, days)
def set_body(body, compress=False):
    get_response().set_body(body, compress)
def expire_cookie(name, **attrs):
    get_response().expire_cookie(name, **attrs)
def set_cookie(name, value, **attrs):
    get_response().set_cookie(name, value, **attrs)
def add_javascript(code_id, code):
    get_response().add_javascript(code_id, code)
def write(output, include_status=True):
    get_response().write(output, include_status)


wkp.set_content_type=set_content_type
wkp.set_charset=set_charset
wkp.set_status=set_status
wkp.set_header=set_header
wkp.set_expires=set_expires
wkp.set_body=set_body
wkp.expire_cookie=expire_cookie
wkp.set_cookie=set_cookie
wkp.add_javascript=add_javascript
wkp.write=write
from quixote.http_response import Stream 
wkp.Stream=Stream

def set_cookiemy(name,value,seconds=0, minutes=0, hours=0, days=0,months=0,years=0):
    t=seconds+60*(minutes+60*(hours+24*(days+30*(12*months+years))))
    m=time.strftime("%a, %d-%b-%Y %H:%M:%S GMT;",time.gmtime(time.time()+t))
    cookie_dict={
        'path': '/',
        'max-age': t,
        'version':1,
        'expires':m
        }
    wkp.set_cookie(name,value,**cookie_dict)
wkp.set_cookiemy=set_cookiemy

from quixote.util  import  import_object,xmlrpc,FileStream,StaticFile,StaticDirectory,Redirector,dump_request,get_directory_path
wkp.import_object=import_object
wkp.xmlrpc=xmlrpc
wkp.FileStream=FileStream
#wkp.StaticFile=StaticFile
#wkp.StaticDirectory=StaticDirectory
wkp.Redirector=Redirector
wkp.dump_request=dump_request
wkp.get_directory_path=get_directory_path



def get_clientip_name():
    t=wkp.get_clientip().split('.')
    result='%s.%s.%s.%s'%(t[0],t[1],t[2],'*')
    return result

def get_userip_list():
    uid=wkp.get_user('userid',0)
    uname=wkp.get_user('username',None)
    if not uname:
        uname=get_clientip_name
    return (uid,uname)

wkp.get_userip_list=get_userip_list
wkp.get_clientip_name=get_clientip_name

def get_session_name():
    return wkp.get_config().session_cookie_name
def get_session_id():
    return wkp.get_session().id
def get_session_config():
    return (get_session_name(),get_session_id())
def get_session_form():
    return '<input name="%s" type="hidden" value="%s">'%get_session_config()
def get_session_url():
    return '%s=%s'%get_session_config()

wkp.get_session_name=get_session_name
wkp.get_session_id=get_session_id
wkp.get_session_config=get_session_config
wkp.get_session_url=get_session_url
wkp.get_session_form=get_session_form




