#! /usr/bin/env python

'''
Copyright (c) 2005, WukooPy Team (lihuimail@gmail.com)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the WukooPy Team nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

import os
import os.path
import types
import mimetypes
from rfc822 import formatdate


from quixote.publish import Publisher as _Publisher
from quixote.publish import  get_publisher,get_request,get_response,get_field,get_cookie,get_path,redirect,get_session,get_session_manager,get_user
from quixote.util  import  FileStream

from wukoopy.lib.application import Application
from wukoopy import wukoopy_quixote


wkp=Application()


NO_ACCESS_METHOD=['__call__','__class__','__delattr__','__dict__','__doc__','__get__','__getattribute__','__hash__','__init__','__module__','__name__','__new__','__reduce__','__reduce_ex__','__repr__','__setattr__','__str__','func_closure','func_code','func_defaults','func_dict','func_doc','func_globals','func_name']


class Publisher(_Publisher):

    def __init__(self,root_directory,logger=None,session_manager=None,config=None,**kwargs):
        try:
            _Publisher.__init__(self,root_directory,logger,session_manager,config,**kwargs)
        except:
            pass
        self.root_directory = root_directory
        self._request = None


    def try_publish(self, request):
        self.start_request()
        path = request.get_environ('PATH_INFO', '')
        #assert path[:1] == '/'
        #path = path[1:].split('/')
        if type(self.root_directory)==types.ModuleType:
            output = self.my_traverse(path,self.root_directory.root())
        elif type(self.root_directory)==types.FunctionType:
            output = self.my_traverse(path,self.root_directory())
        else:
            output = None
        self.finish_successful_request()
        return output

    def my_pathlist(self,path):
        result=None
        base=os.path.basename(path)
        if base in ['index','index.html','index.htm','index.php','index.asp','index.php3']:
            path=path[:-len(base)]
        try:
            ext=os.path.basename(path).split('.')[1]
        except:
            ext=''
        if ext:
            path=path[:-len('.'+ext)]
        path_list=[v for v in path.split('/') if v]
        if path_list and path_list[-1] and ext:
            path_list[-1]+='.'+ext
        if not path_list:
            result=None
        else:
            result=path_list
        return result
    def my_traverse(self,path,root):
        result=None
        path_list=self.my_pathlist(path)
        root_push=root
        path_index=0
        if path_list is None:
            args=[]
        else:
            for i in range(len(path_list)):
                if i==len(path_list)-1:
                    mm=path_list[i] 
                    if mm.find('.')<>-1:
                        mm=mm.replace('.','_')
                else:
                    mm=path_list[i]
                t=getattr(root_push,mm,None)
                if t is None:
                    path_index=i
                    break
                else:
                    root_push=t
                    path_index=i+1
            args=path_list[path_index:]
            t='/'+'/'.join(path_list[0:path_index])
            get_request().subpath=path[len(t):]
        if hasattr(root_push,'_q_access'):
            access_result=root_push._q_access(wkp,root_push)
        else:
            access_result=None
        if not access_result:
            if args:
                result=root_push(wkp,*args)
            else:
                result=root_push(wkp)
        else:
            result=access_result
        return result


class Test_PathList:
    def my_pathlist(self,path):
        result=None
        if path.startswith('/'):
            path=path[1:]
        base=os.path.basename(path)
        if base in NO_ACCESS_METHOD:
            raise
        if base in ['index','index.html','index.htm','index.php','index.asp','index.php3']:
            path=path[:-len(base)]
        if path.endswith('/'):
            path=path[:-1]
        try:
            ext=os.path.basename(path).split('.')[1]
        except:
            ext=''
        if ext:
            path=path[:-len('.'+ext)]
        path_list=path.split('/')
        path_list=[v for v in path_list if v]
        if path_list and path_list[-1] and ext:
            path_list[-1]+='.'+ext
        if not path_list:
            result=None
        else:
            result=path_list
        return result
    def my_traverse(self,path,root):
        result=None
        path_list=self.my_pathlist(path)
        root_push=root
        path_index=0
        if path_list is None:
            args=[]
        else:
            for i in range(len(path_list)):
                t=getattr(root_push,path_list[i],None)
                if t is None:
                    path_index=i
                    break
                else:
                    root_push=t
                    path_index=i+1
            args=path_list[path_index:]
        if args:
            result=root_push(*args)
        else:
            result=root_push()
        return result

def test_PathList():
    t=Test_PathList()
    assert t.my_pathlist('/')==None
    assert t.my_pathlist('/1/11/11//')==['1', '11', '11']
    assert t.my_pathlist('/1/11/11/')==['1', '11', '11']
    assert t.my_pathlist('/1/11/11/index.html')==['1', '11', '11']
    assert t.my_pathlist('/1/11/11/index.htm')==['1', '11', '11']
    assert t.my_pathlist('/1/11/11/index1.html')==['1', '11', '11', 'index1_html']
    assert t.my_pathlist('/1/index1.html')==['1', 'index1_html']
    assert t.my_pathlist('/1/index1')==['1', 'index1']
    assert t.my_pathlist('/1/index1_html')==['1', 'index1_html']
    assert t.my_pathlist('/index1_html')==['index1_html']
    assert t.my_pathlist('/1')==['1']
    assert t.my_pathlist('/index')==None
    assert t.my_pathlist('/index.php')==None
    assert t.my_pathlist('/1/11//11//')==['1', '11', '11']


def test_root(*args):
    return args

def test_RootPush():
    root=test_root
    root.p=test_root
    root.p1=test_root
    root.p2=test_root
    root.p3=test_root
    root.p.p4=test_root
    t=Test_PathList()
    assert t.my_traverse('/',root)==()
    assert t.my_traverse('',root)==()
    assert t.my_traverse('/11',root)==('11',)
    assert t.my_traverse('/p',root)==()
    assert t.my_traverse('/p/',root)==()
    assert t.my_traverse('/p/11',root)==('11',)
    assert t.my_traverse('/p/',root)==()
    assert t.my_traverse('/p/p1',root)==()
    assert t.my_traverse('/p/p4/p6',root)==('p6',)
    assert t.my_traverse('/p/p1/',root)==()








def StaticFile(path, follow_symlinks=False,mime_type=None, encoding=None,cache_time=None):
    if not os.path.isabs(path):
        raise ValueError, "Path %r is not absolute" % path
    guess_mime, guess_enc = mimetypes.guess_type(os.path.basename(path), strict=False)
    mime_type = mime_type or guess_mime or 'text/plain'
    encoding = encoding or guess_enc or None
    cache_time = cache_time
    follow_symlinks = follow_symlinks
    if not follow_symlinks and os.path.islink(path):
        raise errors.TraversalError(private_msg="Path %r is a symlink"% path)

    request = get_request()
    response = get_response()

    if cache_time is None:
        response.set_expires(None) # don't set the Expires header
    else:
        response.set_expires(seconds=cache_time)

    stat = os.stat(path)
    last_modified = formatdate(stat.st_mtime)
    if last_modified == request.get_header('If-Modified-Since'):
        response.set_status(304)
        return ''

    response.set_content_type(mime_type)
    if encoding:
        response.set_header("Content-Encoding", encoding)
    response.set_header('Last-Modified', last_modified)
    return FileStream(open(path, 'rb'), stat.st_size)


def StaticDirectory(path,*args):
    return StaticFile(os.path.join(path,*args))

def get_subpath():
    return getattr(get_request(),'subpath','')


wkp.StaticFile=StaticFile
wkp.StaticDirectory=StaticDirectory
wkp.get_subpath=get_subpath
