#! /usr/bin/env python

'''
Copyright (c) 2005, WukooPy Team (lihuimail@gmail.com)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the WukooPy Team nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

from quixote.config import *

try:
    from cStringIO import StringIO
except:
    from StringIO import StringIO

from os.path import dirname,abspath,join

class MyBase(Config):
    def dump_to_string(self):
        tmpFile = StringIO()
        self.dump(tmpFile)
        content = tmpFile.getvalue()
        tmpFile.close()
        return content
    def set_from_string(self, configstr):
        config_vars = {}
        try:
            exec(configstr, config_vars)
        except IOError, exc:
            if exc.filename is None:  # arg! execfile() loses filename
                exc.filename = filename
            raise exc
        self.set_from_dict(config_vars)
    def dump_file(self, file=None):
        import sys
        if file is None:
            file = sys.stdout
        for var in self.config_vars:
            try:
                file.write("  %s = %s\n" % (var.upper(), `getattr(self, var)`))
            except:
                pass


class MyConfig(MyBase):
    def __init__(self,*args,**kwargs):
        MyBase.__init__(self,*args,**kwargs)
    def set_from_dict(self, config_vars):
        for name, value in config_vars.items():
            if name.isupper():
                name = name.lower()
                setattr(self, name, value)
                if name in self.config_vars:
                    pass
                else:
                    self.config_vars.append(name)
    def set(self,key,value):
        self.set_from_dict({key.upper():value})
    def get(self,key):
        key=key.lower()
        return getattr(self,key)
    def read_file(self,configfile):
        t=self.path_top
        MyBase.read_file(self,join(t,configfile))
        self.set('PATH_TOP',t)


