#! /usr/bin/env python

'''
Copyright (c) 2005, WukooPy Team (lihuimail@gmail.com)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the WukooPy Team nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''





class ListDB(object):

    def __init__(self,current=1,size=5,baseurl='http://uc66.com/',other=None,dbselect=None,connection=None):
        self.currentPage=1
        self.pageSize=2
        self.baseUrl="http://uc66.com/"
        self._dbSelect=None
        self.pageStart=1
        self.pageEnd=1
        self.pageStep=5
        self.pageNext=0
        self.pagePrev=0
        self.recordStart=0
        self.recordEnd=0

        self.connection=connection

        self.otherParam1=0
        self.otherParam2=None
        self.otherParam3=None
        self.otherParam4=None

        self.stepList=[]

        self.recordCount=0
        self.pageCount=0

        self.currentDbSelect=None

        self.htmlStart=''
        self.htmlEnd=''
        self.htmlPrev=''
        self.htmlNext=''
        self.htmlStepList=[]
        self.htmlStep=''


        self.html1Start=''
        self.html1End=''
        self.html1Prev=''
        self.html1Next=''
        self.html1StepList=[]
        self.html1Step=''

        self.currentPage=current
        self.pageCurrent=current
        self.pageSize=size
        self.baseUrl=baseurl
        self.otherParam1=other
        if dbselect is not None:
            self.setDbSelect(dbselect)
    def setDbSelect(self,db):
        self.stepList=[]
        self.htmlStepList=[]
        self.html1StepList=[]
        self._dbSelect=db
        self.recordCount=self._dbSelect.count()
        if self.recordCount%self.pageSize==0:
            self.pageCount=self.recordCount/self.pageSize
        else:
            self.pageCount=self.recordCount/self.pageSize+1
        self.pageStart=1
        self.pageEnd=self.pageCount
        if self.currentPage<1:
            self.currentPage=1
        if self.currentPage>self.pageCount:
            self.currentPage=self.pageCount
        self.pagePrev=self.currentPage-1
        if self.pagePrev<1:
            self.pagePrev=0
        self.pageNext=self.currentPage+1
        if self.pageNext>self.pageCount:
            self.pageNext=0
        self.recordStart=(self.currentPage-1)*self.pageSize
        self.recordEnd=self.currentPage*self.pageSize
        self.currentDbSelect=self._dbSelect[self.recordStart:self.recordEnd]
        t=self.pageCount-self.currentPage
        if t>self.pageStep:
            t=self.pageStep
        for v in range(self.currentPage+1,self.currentPage+t+1):
            self.stepList.append(v)
        if self.pageStart==self.currentPage:
            self.htmlStart='|&lt;'
        else:
            if self.otherParam1 is None:
                if self.baseUrl.endswith('/'):
                    self.htmlStart='<a href="%s%d_%d.html">|&lt;</a>'%(self.baseUrl,self.pageStart,self.pageSize)
                else:
                    self.htmlStart='<a href="%s_%d_%d.html">|&lt;</a>'%(self.baseUrl,self.pageStart,self.pageSize)
            else:
                self.htmlStart='<a href="%s%d_%d_%d.html">|&lt;</a>'%(self.baseUrl,self.otherParam1,self.pageStart,self.pageSize)
        if self.pageEnd==self.currentPage:
            self.htmlEnd='&gt;|'
        else:
            if self.otherParam1 is None:
                if self.baseUrl.endswith('/'):
                    self.htmlEnd='<a href="%s%d_%d.html">&gt;|</a>'%(self.baseUrl,self.pageEnd,self.pageSize)
                else:
                    self.htmlEnd='<a href="%s_%d_%d.html">&gt;|</a>'%(self.baseUrl,self.pageEnd,self.pageSize)
            else:
                self.htmlEnd='<a href="%s%d_%d_%d.html">&gt;|</a>'%(self.baseUrl,self.otherParam1,self.pageEnd,self.pageSize)
        if self.pagePrev==0:
            self.htmlPrev='&lt;'
        else:
            if self.otherParam1 is None:
                if self.baseUrl.endswith('/'):
                    self.htmlPrev='<a href="%s%d_%d.html">&lt;</a>'%(self.baseUrl,self.pagePrev,self.pageSize)
                else:
                    self.htmlPrev='<a href="%s_%d_%d.html">&lt;</a>'%(self.baseUrl,self.pagePrev,self.pageSize)
            else:
                self.htmlPrev='<a href="%s%d_%d_%d.html">&lt;</a>'%(self.baseUrl,self.otherParam1,self.pagePrev,self.pageSize)
        if self.pageNext==0:
            self.htmlNext='&gt;|'
        else:
            if self.otherParam1 is None:
                if self.baseUrl.endswith('/'):
                    self.htmlNext='<a href="%s%d_%d.html">&gt;|</a>'%(self.baseUrl,self.pageNext,self.pageSize)
                else:
                    self.htmlNext='<a href="%s_%d_%d.html">&gt;|</a>'%(self.baseUrl,self.pageNext,self.pageSize)
            else:
                self.htmlNext='<a href="%s%d_%d_%d.html">&gt;|</a>'%(self.baseUrl,self.otherParam1,self.pageNext,self.pageSize)
        for v in self.stepList:
            if self.otherParam1 is None:
                if self.baseUrl.endswith('/'):
                    v1='<a href="%s%d_%d.html">[%d]</a>'%(self.baseUrl,v,self.pageSize,v)
                else:
                    v1='<a href="%s_%d_%d.html">[%d]</a>'%(self.baseUrl,v,self.pageSize,v)
            else:
                v1='<a href="%s%d_%d_%d.html">[%d]</a>'%(self.baseUrl,self.otherParam1,v,self.pageSize,v)
            self.htmlStepList.append(v1)
            self.htmlStep+=v1+' '
        if self.pageStart==self.currentPage:
            self.html1Start='|&lt;'
        else:
            self.html1Start='<a href="%s?c=%d&s=%d">|&lt;</a>'%(self.baseUrl,self.pageStart,self.pageSize)
        if self.pageEnd==self.currentPage:
            self.html1End='&gt;|'
        else:
            self.html1End='<a href="%s?c=%d&s=%d">&gt;|</a>'%(self.baseUrl,self.pageEnd,self.pageSize)
        if self.pagePrev==0:
            self.html1Prev='&lt;'
        else:
            self.html1Prev='<a href="%s?c=%d&s=%d">&lt;</a>'%(self.baseUrl,self.pagePrev,self.pageSize)
        if self.pageNext==0:
            self.html1Next='&gt;|'
        else:
            self.html1Next='<a href="%s?c=%d&s=%d">&gt;|</a>'%(self.baseUrl,self.pageNext,self.pageSize)
        for v in self.stepList:
            v1='<a href="%s?c=%d&s=%d">[%d]</a>'%(self.baseUrl,v,self.pageSize,v)
            self.html1StepList.append(v1)
            self.html1Step+=v1+' '

    dbSelect=property(None,setDbSelect,None,'dbSelect')

    def execute(self):
        pass


def test_ListDB():
    from dbpublic import desktop
    a=ListDB()
    a.currentPage=5
    a.dbSelect=desktop.FileList.select()
    print a.recordCount
    print a.pageCount
    print a.__dict__




class DisplayDB(object):

    def __init__(self,dbdisplay=None):
        self._dbDisplay=None
        if dbdisplay is not None:
            self.setDbDisplay(dbdisplay)
    def setDbDisplay(self,dbdisplay):
        self._dbDisplay=dbdisplay
    def getDbDisplay(self):
        return self._dbDisplay

    dbDisplay=property(getDbDisplay,setDbDisplay,None,'dbDisplay')



if __name__=='__main__':
    test_ListDB()