#! /usr/bin/env python

'''
Copyright (c) 2005, WukooPy Team (lihuimail@gmail.com)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the WukooPy Team nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''



from singleton import Singleton
from threadinglocal import local


class EmptyClass(object):
    pass


class Application(object):
    __metaclass__ = Singleton
    def __init__(self):
        self.local=local()
        self.threadmy=local()
        self.config=EmptyClass()
        self.public=EmptyClass()
        self.private=EmptyClass()
        self.protect=EmptyClass()
    def get(self,v):
        t=self
        for m in v.split('.'):
            if hasattr(t,m):
                t=getattr(t,m)
                result=t
            else:
                result=None
                break
        return result
    def set(self,k,v):
        t=self
        for m in k.split('.')[:-1]:
            if hasattr(t,m):
                pass
            else:
                setattr(t,m,EmptyClass())
            t=getattr(t,m)
        setattr(t,k.split('.')[-1],v)


class Config(object):
    __metaclass__ = Singleton
    def __init__(self):
        self.local=local()
    def get(self,v):
        t=self
        for m in v.split('.'):
            if hasattr(t,m):
                t=getattr(t,m)
                result=t
            else:
                result=None
                break
        return result
    def set(self,k,v):
        t=self
        for m in k.split('.')[:-1]:
            if hasattr(t,m):
                pass
            else:
                setattr(t,m,EmptyClass())
            t=getattr(t,m)
        setattr(t,k.split('.')[-1],v)


def test_Application():
    t=Application()
    print t.get('myapp')
    t.set('myapp.execute.k',123)
    print t.get('myapp.execute.k')
    print t.get('myapp.execute')
    print t.get('myapp')


if __name__=='__main__':
    test_Application()
