"""Simple proxy server
The requests (HEAD, GET *and POST*) are handled by the 
ProxyRequestHandler class, which sends it to the specified
server. The response sent by this server is then sent
to the client
"""

import sys
import cgi
import socket
import select
import SocketServer
import urllib
import httplib
import urlparse
import SimpleHTTPServer

server_host = 'localhost'
server_port = 8080

class ProxyRequestHandler(SimpleHTTPServer.SimpleHTTPRequestHandler):

    def do_GET(self):
        """Override do_GET() in SimpleHTTPRequest handler"""
        self.handle_data()

    def do_POST(self):
        """Begin serving a POST request. The request data must be readable
        on a file-like object called self.rfile
        Request body is stored in the dictionary self.body"""
        ctype, pdict = cgi.parse_header(self.headers.getheader('content-type'))
        length = int(self.headers.getheader('content-length'))
        if ctype == 'multipart/form-data':
            self.body = cgi.parse_multipart(self.rfile, pdict)
        elif ctype == 'application/x-www-form-urlencoded':
            qs = self.rfile.read(length)
            self.body = cgi.parse_qs(qs, keep_blank_values=1)
        else:
            self.body = {}                   # Unknown content-type
        # throw away additional data [see bug #427345]
        while select.select([self.rfile._sock], [], [], 0)[0]:
            if not self.rfile._sock.recv(1):
                break
        self.handle_data()

    def handle_data(self):
        """Ask the server to handle the request"""
        parsed = urlparse.urlparse(self.path)
        host = parsed[1]
        cx = httplib.HTTPConnection(host)
        headers = dict(self.headers)
        body = ""
        if self.command == 'POST':
            body = urllib.urlencode(self.body, doseq = 1)
        try:
            cx.request(self.command, self.path, body, headers)
        except socket.error:
            self.send_response(200,"Ok")
            self.send_header('Content-type','text/html')
            self.end_headers()
            self.wfile.write("<b>Error - could not connect to server %s:%s</b>" \
                %(server_host, server_port))
            return
        resp = cx.getresponse()
        self.send_response(resp.status,resp.reason)
        if hasattr(resp.msg, 'dict'):
            for (k,v) in resp.msg.dict.items():
                if k not in ['transfer-encoding']:
                    self.send_header(k,v)
                    sys.stderr.write('%s : %s\n' %(k,v))
                else:
                    #self.send_header(k,v)
                    sys.stderr.write('*** %s : %s\n' %(k,v))
                
        self.end_headers()
        data = resp.read()
        self.wfile.write(data)
        sys.stderr.write('%s\n' %len(data))

if __name__=="__main__":
    # launch the server on port 8000
    PORT = 8000
    import SocketServer
    s = SocketServer.TCPServer(('',PORT),ProxyRequestHandler)
    print "ProxyHTTPServer running on port", PORT
    s.serve_forever()