#! /usr/bin/env python

'''
Copyright (c) 2005, WukooPy Team (lihuimail@gmail.com)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the WukooPy Team nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

import urllib

from wukoopy.lib.application import Application
from wukoopy.lib.utils import getAttrib,getModule,getServerID
from wukoopy.lib.dbutils import ListDB


wkp=Application()

wkp.set('dbutils.ListDB',ListDB)


def get_module(value,f=None):
    if f:
        t=value+'.'+f
    else:
        t=value
    if not hasattr(wkp,'ModuleList'):
        wkp.ModuleDict={}
    if not wkp.ModuleDict.has_key(t):
        wkp.ModuleDict[t]=getModule(value,f)
    result=wkp.ModuleDict[t]
    return result

def get_serverid():
    return getServerID(wkp.get_server())

def turn2js(v):
    if hasattr(v,'readlines'):
        mlist=v.readlines()
    elif type(v)==type(''):
        mlist=v.split('\n')
    result='\n'.join(["document.write('%s');"%(v.strip().replace("'","\\'")) for v in mlist if v.strip()])
    return result

def urlget(v):
    try:
        fp=urllib.urlopen(v)
        result=fp.read()
        fp.close()
    except:
        result=None
    return result 

wkp.get_module_import=get_module
wkp.get_module_attrib=getAttrib
wkp.get_serverid=get_serverid
wkp.set('web.turn2js',turn2js)
wkp.set('web.urlget',urlget)

try:
    from cherrytemplate import renderTemplate
    wkp.renderTemplate=renderTemplate
except:
    pass



if __name__=='__main__':
    print get_module('dbpublic.user','User')
    print get_module('dbpublic.user','User')
    print get_module('dbpublic.user','User')
    print wkp.ModuleDict
    print wkp.web.turn2js('''
        <html>
        </html>
        ''')
    print wkp.web.turn2js(wkp.web.urlget('http://127.0.0.1:8080/'))
