#! /usr/bin/env python

'''
Copyright (c) 2005, WukooPy Team (lihuimail@gmail.com)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the WukooPy Team nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

from BaseHTTPServer import *
from cherrypy._cphttpserver import CherryHTTPServer
from quixote.server.simple_server import HTTPRequestHandler
from threading import Thread,Event
from quixote.publish import Publisher

class HTTPServerPlus(CherryHTTPServer, Thread):
    def __init__(self, **kwargs):
        CherryHTTPServer.__init__(self,**kwargs)
        Thread.__init__(self)
    def run(self):
        self.serve_forever()
    def join(self,timeout=None):
        self.shutdown()
        Thread.join(self, timeout)



class TemplateServer(HTTPServerPlus):
    def __init__(self, port):
        HTTPServerPlus.__init__(self,server_address=('', port), RequestHandlerClass=HTTPRequestHandler)
        self.server_port = port
        self.server_name = 'My Local Server'
        create_publisher()
        self.start()

def create_publisher():
    from quixote.demo.root import RootDirectory
    return Publisher(RootDirectory(), display_exceptions='plain')



if __name__=='__main__':
    server = TemplateServer(8800)
    try:
        while 1:
            pass
    except KeyboardInterrupt:
        print 'Got Ctrl-C...'
        server.join(1.0)


