#! /usr/bin/env python

'''
Copyright (c) 2005, WukooPy Team (lihuimail@gmail.com)
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, 
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution.
    * Neither the name of the WukooPy Team nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

import urlparse
import sys
import os.path
import os
import time
from cStringIO import StringIO
import posixpath
import urllib
import string

from quixote.publish import Publisher as _Publisher
import quixote.publish
from quixote.http_response import HTTPResponse as _HTTPResponse
from quixote.util import FileStream
from quixote.config import Config
from quixote.http_response import HTTPResponse
from quixote.logger import DefaultLogger



#------------------------------------------------------

my_k_config=dict(
    initFile='Karrigell.ini',
    PORT=8080,
    protectedDirs=['D:\\pythonMy\\KarrigellLib\\admin'],
    alias={'doc':'D:\\pythonMy\\KarrigellLib/doc','base':'D:\\pythonMy\\KarrigellLib'},
    globalScriptsList=['D:\\pythonMy\\KarrigellLib/myScript1.py','D:\\pythonMy\\KarrigellLib/myScript.py'],
    globalScripts=['myScript1','myScript'],
    extensions_map={'.gif':'image/gif','.jpg':'image/jpeg','.py':'text/html','.nwc':'application/nwc','.html':'text/html','.htm':'text/html'},
    debug=1,
    base='',
    persistentSession=False,
    silent=False,
    language='',
    ignore=['/favicon.ico'],
    serverDir=r'D:\pythonMy\KarrigellLib',
    #rootDir=r'D:\pythonMy\KarrigellLib',
    extensions=['gif','html','nwc','htm','py','jpg'],
    gzip=False,
    )


import  KarrigellLib
m=os.path.dirname(os.path.abspath(KarrigellLib.__file__))
if m not in sys.path:
    sys.path.append(m)

msave=sys.argv
sys.argv=[]
import k_config
sys.argv=msave

for k,v in my_k_config.items():
    setattr(k_config,k,v)
k_config.serverDir=os.path.dirname(os.path.abspath(k_config.__file__))
if  not  k_config.alias.has_key('debugger'):
    k_config.alias['debugger']=os.path.join(k_config.serverDir,'debugger')
if not  k_config.alias.has_key('demo'):
    k_config.alias['demo']=os.path.join(k_config.serverDir,'demo')
if not  k_config.alias.has_key('fckeditor'):
    k_config.alias['fckeditor']=os.path.join(k_config.serverDir,'fckeditor')
if not  k_config.alias.has_key('doc'):
    k_config.alias['doc']=os.path.join(k_config.serverDir,'doc')
if not  k_config.alias.has_key('instant_site'):
    k_config.alias['instant_site']=os.path.join(k_config.serverDir,'instant_site')
if not  k_config.alias.has_key('components'):
    k_config.alias['components']=os.path.join(k_config.serverDir,'components')
if not  k_config.alias.has_key('listDirectory.pih'):
    k_config.alias['listDirectory.pih']=os.path.join(k_config.serverDir,'listDirectory.pih')
if not  k_config.alias.has_key('karrigell.css'):
    k_config.alias['karrigell.css']=os.path.join(k_config.serverDir,'karrigell.css')
if  not  k_config.alias.has_key('admin'):
    k_config.alias['admin']=os.path.join(k_config.serverDir,'admin')



paths=[]
paths.append(os.path.join(k_config.serverDir,'databases'))
for v in paths:
    if v not in sys.path:
        sys.path.append(v)


import SimpleHTTPServer, KarrigellRequestHandler, URLResolution,Template



def translate_path(path):
    """Overrides SimpleHTTPServer's translate_path to handle aliases
    Returns the path to a file name"""
    path = posixpath.normpath(urllib.unquote(path))
    path = path[len(k_config.base):]    # remove base beginning the url
    words = path.split('/')
    words = filter(None, words)
    # for ks scripts, path ends at the word ending with "ks"
    w1,w2=[],[]
    for i,word in enumerate(words):
        w1.append(word)
        if word.lower().endswith(".ks"):
            w2=words[i+1:]
            break
    words=w1
    m=words[-1]
    if m.endswith('.html') and '_' in m:
        words[-1]=m.split('_',1)[0]
    if words and words[0] in k_config.alias.keys():
        path=posixpath.normpath(k_config.alias[words[0]])
        path=os.path.join(k_config.alias[words[0]],string.join(words[1:],"/"))
    else:
        path=os.path.join(k_config.rootDir,string.join(words,"/"))
    return path

def list_directory(path,dirName):
    script = Template.getScript(os.path.join(k_config.serverDir,'listDirectory.pih'))
    return script.render({'path':path,'dirName':dirName}).value

setattr(Template,'list_directory',list_directory)
setattr(URLResolution,'translate_path',translate_path)




class QuixoteHandler(KarrigellRequestHandler.KarrigellRequestHandler,SimpleHTTPServer.SimpleHTTPRequestHandler):
    def __init__(self, request):
        self.response_status=(200,'OK')
        self.response_headers=[]
        self.request = request
        self.wfile = StringIO()
        fs=request.get_fields()
        self.headers=dict(request.environ.items())
        for item in self.headers.keys():
            if item.startswith("HTTP_"):
                hd=item[5:]
                self.headers[hd.lower()]=self.headers[item]
        self.command = self.headers['REQUEST_METHOD']
        self.body = {}
        if self.command == 'POST':
            self.body=fs
        self.client_address=(self.headers["REMOTE_ADDR"],0)
        self.path=self.path_without_qs=self.headers["PATH_INFO"]
        if self.headers.has_key("QUERY_STRING"):
            self.path+="?"+self.headers["QUERY_STRING"]
        self.request_version=self.headers["SERVER_PROTOCOL"]
        self.requestline="%s %s %s" %(self.headers["SERVER_PROTOCOL"],
            self.headers["REQUEST_METHOD"],self.path)
        try:
            self.handle_data()
        finally:
            sys.exc_traceback = None    # Help garbage collection

    def send_response(self,status, reason=None):
        self.response_status=(status, reason)
    def send_header(self,key,value):
        self.response_headers.append((key,value))
    def end_headers(self):
        pass



class Publisher(_Publisher):

    def __init__(self, root_directory, logger=None, session_manager=None,config=None, **kwargs):
        if config is None:
            self.config = Config(**kwargs)
        else:
            if kwargs:
                raise ValueError("cannot provide both 'config' object and"
                                 " config arguments")
            self.config = config
        for k in my_k_config.keys():
            if hasattr(self.config,k.lower()):
                setattr(k_config,k,getattr(self.config,k.lower()))
        if logger is None:
            self.logger = DefaultLogger(error_log=self.config.error_log,
                                        access_log=self.config.access_log,
                                        error_email=self.config.error_email)
        else:
            self.logger = logger
        if session_manager is not None:
            self.session_manager = session_manager
        else:
            from quixote.session import NullSessionManager
            self.session_manager = NullSessionManager()

        if quixote.publish._publisher is not None:
            raise RuntimeError, "only one instance of Publisher allowed"
        quixote.publish._publisher = self

        self.root_directory = root_directory
        if hasattr(root_directory,'__file__'):
            k_config.rootDir=os.path.dirname(os.path.abspath(root_directory.__file__))
        self._request = None


    def try_publish(self, request):
        self.start_request()
        path = request.get_environ('PATH_INFO', '')
        assert path[:1] == '/'
        # split path into components
        path = path[1:].split('/')
        t=QuixoteHandler(request)
        request.response.set_status(t.response_status[0])
        for v in t.response_headers:
            request.response.set_header(v[0],v[1])
        output = t.wfile.getvalue()
        # The callable ran OK, commit any changes to the session
        self.finish_successful_request()
        return output

