[default]
identifiers = 
dots = add,addClass,after,ancestors,animate,append,appendTo,attr,background,before,bind,blur,change,children,click,clone,color,contains,css,dblclick,domManip,each,empty,end,eq,error,extend,fadeIn,fadeOut,fadeTo,filter,find,float,focus,get,getIfModified,grep,gt,height,hide,hover,href,html,id,init,insertAfter,insertBefore,jquery,keydown,keypress,keyup,left,length,load,loadIfModified,lt,map,merge,mousedown,mousemove,mouseout,mouseup,name,next,not,oneblur,onechange,oneclick,onedblclick,oneerror,onefocus,onekeydown,onekeypress,onekeyup,oneload,onemousedown,onemousemove,onemouseout,onemouseup,oneresize,onescroll,oneselect,onesubmit,oneunload,overflow,parent,parents,position,prepend,prependTo,prev,pushStack,ready,rel,remove,removeAttr,removeClass,resize,scroll,select,show,sibling,siblings,size,slideDown,slideToggle,slideUp,src,submit,text,title,toggle,toggleClass,top,trigger,trim,unbind,unblur,unchange,unclick,undblclick,unerror,unfocus,unkeydown,unkeypress,unkeyup,unload,unmousedown,unmousemove,unmouseout,unmouseup,unresize,unscroll,unselect,unsubmit,ununload,val,width,wrap,

[functions]
gt = "jQuery gt(Number pos)  ==> Core\n    Reduce the set of matched elements to all elements after a\n    given position."
show = "jQuery show()  ==> Effects\n    Displays each of the set of matched elements if they are\n    hidden.\n\njQuery show(Object speed)  ==> Effects/Animations\n    Show all matched elements using a graceful animation.\n\njQuery show(Object speed, Function callback)  ==> Effects/Animations\n    Show all matched elements using a graceful animation and\n    firing a callback function after completion."
onemouseout = "jQuery onemouseout(Function fn)  ==> Events/Mouse\n    Bind a function to the mouseout event of each matched\n    element, which will only be executed once."
text = "String text()  ==> DOM\n    Retreive the text contents of all matched elements."
focus = "jQuery focus(Function fn)  ==> Events/UI\n    Bind a function to the focus event of each matched element.\n\njQuery focus()  ==> Events/UI\n    Trigger the focus event of each matched element."
toggle = "jQuery toggle()  ==> Effects\n    Toggles each of the set of matched elements.\n\njQuery toggle(Function even, Function odd)  ==> Events\n    Toggle between two function calls every other click."
undblclick = "jQuery undblclick(Function fn)  ==> Events/Mouse\n    Removes a bound dblclick event from each of the matched\n    elements.\n\njQuery undblclick()  ==> Events/Mouse\n    Removes all bound dblclick events from each of the matched\n    elements."
find = "jQuery find(String expr)  ==> DOM/Traversing\n    Searches for all elements that match the specified\n    expression.\n\nArray<Element> find()  ==> Core\n"
before = "jQuery before(String html)  ==> DOM/Manipulation\n    Insert any number of dynamically generated elements before\n    each of the  matched elements.\n\njQuery before(Element elem)  ==> DOM/Manipulation\n    Insert an element before each of the matched elements.\n\njQuery before(Array<Element> elems)  ==> DOM/Manipulation\n    Insert any number of elements before each of the matched\n    elements."
unscroll = "jQuery unscroll(Function fn)  ==> Events/Browser\n    Removes a bound scroll event from each of the matched\n    elements.\n\njQuery unscroll()  ==> Events/Browser\n    Removes all bound scroll events from each of the matched\n    elements."
title = "String title()  ==> DOM/Attributes\n    Get the current title of the first matched element.\n\njQuery title(String val)  ==> DOM/Attributes\n    Set the title of every matched element."
fadeTo = "jQuery fadeTo(Object speed, Number opacity)  ==> Effects/Animations\n    Fade the opacity of all matched elements to a specified\n    opacity.\n\njQuery fadeTo(Object speed, Number opacity, Function callback)  ==> Effects/Animations\n    Fade the opacity of all matched elements to a specified\n    opacity and  firing a callback function after completion."
init = "undefined init()  ==> Core\n"
html = "String html()  ==> DOM/Attributes\n    Get the html contents of the first matched element.\n\njQuery html(String val)  ==> DOM/Attributes\n    Set the html contents of every matched element."
parents = "Array<Element> parents(Element elem)  ==> DOM/Traversing\n    All ancestors of a given element.\n\njQuery parents()  ==> DOM/Traversing\n    Get a set of elements containing the unique ancestors of the\n    matched set of elements (except for the root element).\n\njQuery parents(String expr)  ==> DOM/Traversing\n    Get a set of elements containing the unique ancestors of the\n    matched set of elements, and filtered by an expression."
mouseout = "jQuery mouseout(Function fn)  ==> Events/Mouse\n    Bind a function to the mouseout event of each matched\n    element.\n\njQuery mouseout()  ==> Events/Mouse\n    Trigger the mouseout event of each matched element."
siblings = "jQuery siblings()  ==> DOM/Traversing\n    Get a set of elements containing all of the unique siblings\n    of each of the  matched set of elements.\n\njQuery siblings(String expr)  ==> DOM/Traversing\n    Get a set of elements containing all of the unique siblings\n    of each of the  matched set of elements, and filtered by an\n    expression."
unmousemove = "jQuery unmousemove(Function fn)  ==> Events/Mouse\n    Removes a bound mousemove event from each of the matched\n    elements.\n\njQuery unmousemove()  ==> Events/Mouse\n    Removes all bound mousemove events from each of the matched\n    elements."
onemousedown = "jQuery onemousedown(Function fn)  ==> Events/Mouse\n    Bind a function to the mousedown event of each matched\n    element, which will only be executed once."
addClass = "jQuery addClass(String class)  ==> DOM\n    Adds the specified class to each of the set of matched\n    elements."
hover = "jQuery hover(Function over, Function out)  ==> Events\n    A method for simulating hovering (moving the mouse on, and\n    off, an object)."
get = "Array<Element> get()  ==> Core\n    Access all matched elements.\n\nElement get(Number num)  ==> Core\n    Access a single matched element.\n\njQuery get(Elements elems)  ==> Core\n    Set the jQuery object to an array of elements.\n\njQuery get(String url)  ==> AJAX\n    Load a remote page using an HTTP GET request.\n\njQuery get(String url, Hash params)  ==> AJAX\n    Load a remote page using an HTTP GET request.\n\njQuery get(String url, Function callback)  ==> AJAX\n    Load a remote page using an HTTP GET request.\n\njQuery get(String url, Hash params, Function callback)  ==> AJAX\n    Load a remote page using an HTTP GET request."
fadeOut = "jQuery fadeOut(Object speed)  ==> Effects/Animations\n    Fade out all matched elements by adjusting their opacity.\n\njQuery fadeOut(Object speed, Function callback)  ==> Effects/Animations\n    Fade out all matched elements by adjusting their opacity and\n    firing a  callback function after completion."
domManip = "jQuery domManip(Array args, Boolean table, Number int, Function fn)  ==> Core\n"
keydown = "jQuery keydown(Function fn)  ==> Events/Keyboard\n    Bind a function to the keydown event of each matched\n    element.\n\njQuery keydown()  ==> Events/Keyboard\n    Trigger the keydown event of each matched element."
mousemove = "jQuery mousemove(Function fn)  ==> Events/Mouse\n    Bind a function to the mousemove event of each matched\n    element.\n\njQuery mousemove()  ==> Events/Mouse\n    Trigger the mousemove event of each matched element."
background = "String background()  ==> CSS\n    Get the current CSS background of the first matched element.\n\njQuery background(String val)  ==> CSS\n    Set the CSS background of every matched element."
not = "jQuery not(Element el)  ==> DOM/Traversing\n    Removes the specified Element from the set of matched\n    elements.\n\njQuery not(String expr)  ==> DOM/Traversing\n    Removes elements matching the specified expression from the\n    set of matched elements."
name = "String name()  ==> DOM/Attributes\n    Get the current name of the first matched element.\n\njQuery name(String val)  ==> DOM/Attributes\n    Set the name of every matched element."
unsubmit = "jQuery unsubmit(Function fn)  ==> Events/Form\n    Removes a bound submit event from each of the matched\n    elements.\n\njQuery unsubmit()  ==> Events/Form\n    Removes all bound submit events from each of the matched\n    elements."
pushStack = "jQuery pushStack(Array a, Array args)  ==> Core\n"
remove = "jQuery remove()  ==> DOM/Manipulation\n    Removes all matched elements from the DOM.\n\njQuery remove(String expr)  ==> DOM/Manipulation\n    Removes only elements (out of the list of matched elements)\n    that match the specified jQuery expression."
merge = "Array merge(Array a, Array b)  ==> Javascript\n    Merge two arrays together, removing all duplicates."
each = "jQuery each(Function fn)  ==> Core\n    Execute a function within the context of every matched\n    element.\n\nObject each(Object obj, Object fn)  ==> Javascript\n    A generic iterator function, which can be used to seemlessly\n    iterate over both objects and arrays."
onekeyup = "jQuery onekeyup(Function fn)  ==> Events/Keyboard\n    Bind a function to the keyup event of each matched element,\n    which will only be executed once."
onemouseup = "jQuery onemouseup(Function fn)  ==> Events/Mouse\n    Bind a function to the mouseup event of each matched\n    element, which will only be executed once."
getIfModified = "jQuery getIfModified(String url)  ==> AJAX\n    Load a remote page using an HTTP GET request, and only if it\n    hasn't been modified since it was last retieved.\n\njQuery getIfModified(String url, Hash params)  ==> AJAX\n    Load a remote page using an HTTP GET request, and only if it\n    hasn't been modified since it was last retieved.\n\njQuery getIfModified(String url, Function callback)  ==> AJAX\n    Load a remote page using an HTTP GET request, and only if it\n    hasn't been modified since it was last retieved.\n\njQuery getIfModified(String url, Hash params, Function callback)  ==> AJAX\n    Load a remote page using an HTTP GET request, and only if it\n    hasn't been modified since it was last retieved."
unresize = "jQuery unresize(Function fn)  ==> Events/Browser\n    Removes a bound resize event from each of the matched\n    elements.\n\njQuery unresize()  ==> Events/Browser\n    Removes all bound resize events from each of the matched\n    elements."
animate = "jQuery animate(Hash params, Object speed, Function callback)  ==> Effects/Animations\n    A function for making your own, custom, animations."
eq = "jQuery eq(Number pos)  ==> Core\n    Reduce the set of matched elements to a single element."
click = "jQuery click(Function fn)  ==> Events/Mouse\n    Bind a function to the click event of each matched element.\n\njQuery click()  ==> Events/Mouse\n    Trigger the click event of each matched element."
append = "jQuery append(String html)  ==> DOM/Manipulation\n    Append any number of elements to the inside of every matched\n    elements, generated from the provided HTML.\n\njQuery append(Element elem)  ==> DOM/Manipulation\n    Append an element to the inside of all matched elements.\n\njQuery append(Array<Element> elems)  ==> DOM/Manipulation\n    Append any number of elements to the inside of all matched\n    elements."
hide = "jQuery hide()  ==> Effects\n    Hides each of the set of matched elements if they are shown.\n\njQuery hide(Object speed)  ==> Effects/Animations\n    Hide all matched elements using a graceful animation.\n\njQuery hide(Object speed, Function callback)  ==> Effects/Animations\n    Hide all matched elements using a graceful animation and\n    firing a callback function after completion."
extend = "Object extend(Object obj)  ==> Core\n\n\nObject extend(Object obj, Object prop)  ==> Javascript\n    Extend one object with another, returning the original,\n    modified, object."
keypress = "jQuery keypress(Function fn)  ==> Events/Keyboard\n    Bind a function to the keypress event of each matched\n    element.\n\njQuery keypress()  ==> Events/Keyboard\n    Trigger the keypress event of each matched element."
unblur = "jQuery unblur(Function fn)  ==> Events/UI\n    Removes a bound blur event from each of the matched\n    elements.\n\njQuery unblur()  ==> Events/UI\n    Removes all bound blur events from each of the matched\n    elements."
children = "jQuery children()  ==> DOM/Traversing\n    Get a set of elements containing all of the unique children\n    of each of the  matched set of elements.\n\njQuery children(String expr)  ==> DOM/Traversing\n    Get a set of elements containing all of the unique children\n    of each of the  matched set of elements, and filtered by an\n    expression."
lt = "jQuery lt(Number pos)  ==> Core\n    Reduce the set of matched elements to all elements before a\n    given position."
onesubmit = "jQuery onesubmit(Function fn)  ==> Events/Form\n    Bind a function to the submit event of each matched element,\n    which will only be executed once."
rel = "String rel()  ==> DOM/Attributes\n    Get the current rel of the first matched element.\n\njQuery rel(String val)  ==> DOM/Attributes\n    Set the rel of every matched element."
blur = "jQuery blur(Function fn)  ==> Events/UI\n    Bind a function to the blur event of each matched element.\n\njQuery blur()  ==> Events/UI\n    Trigger the blur event of each matched element."
onedblclick = "jQuery onedblclick(Function fn)  ==> Events/Mouse\n    Bind a function to the dblclick event of each matched\n    element, which will only be executed once."
removeAttr = "jQuery removeAttr(String name)  ==> DOM\n    Remove an attribute from each of the matched elements."
parent = "jQuery parent()  ==> DOM/Traversing\n    Get a set of elements containing the unique parents of the\n    matched set of elements.\n\njQuery parent(String expr)  ==> DOM/Traversing\n    Get a set of elements containing the unique parents of the\n    matched set of elements, and filtered by an expression."
slideToggle = "jQuery slideToggle(Object speed)  ==> Effects/Animations\n    Toggle the visibility of all matched elements by adjusting\n    their height.\n\njQuery slideToggle(Object speed, Function callback)  ==> Effects/Animations\n    Toggle the visibility of all matched elements by adjusting\n    their height and firing a callback function after\n    completion."
oneblur = "jQuery oneblur(Function fn)  ==> Events/UI\n    Bind a function to the blur event of each matched element,\n    which will only be executed once."
oneerror = "jQuery oneerror(Function fn)  ==> Events/Browser\n    Bind a function to the error event of each matched element,\n    which will only be executed once."
$ = "jQuery $(String expr)  ==> Core\n    This function accepts a string containing a CSS selector,\n    basic XPath, or raw HTML, which is then used to match a set\n    of elements.\n\njQuery $(String expr, Element context)  ==> Core\n    This function accepts a string containing a CSS selector, or\n    basic XPath, which is then used to match a set of elements\n    with the context of the specified DOM element, or document\n\njQuery $(Element elem)  ==> Core\n    Wrap jQuery functionality around a specific DOM Element.\n\njQuery $(Array<Element> elems)  ==> Core\n    Wrap jQuery functionality around a set of DOM Elements.\n\njQuery $(Function fn)  ==> Core\n    A shorthand for $(document).\n\njQuery $(jQuery obj)  ==> Core\n    A means of creating a duplicate copy of a jQuery object."
src = "String src()  ==> DOM/Attributes\n    Get the current src of the first matched element.\n\njQuery src(String val)  ==> DOM/Attributes\n    Set the src of every matched element."
slideUp = "jQuery slideUp(Object speed)  ==> Effects/Animations\n    Hide all matched elements by adjusting their height.\n\njQuery slideUp(Object speed, Function callback)  ==> Effects/Animations\n    Hide all matched elements by adjusting their height and\n    firing a callback function after completion."
filter = "jQuery filter(String expr)  ==> DOM/Traversing\n    Removes all elements from the set of matched elements that\n    do not  match the specified expression.\n\njQuery filter(Array<String> exprs)  ==> DOM/Traversing\n    Removes all elements from the set of matched elements that\n    do not match at least one of the expressions passed to the\n    function."
length = "Number length()  ==> Core\n    The number of elements currently matched."
load = "jQuery load(Function fn)  ==> Events/Browser\n    Bind a function to the load event of each matched element.\n\njQuery load()  ==> Events/Browser\n    Trigger the load event of each matched element.\n\njQuery load(String url, Hash params, Function callback)  ==> AJAX\n    Load HTML from a remote file and inject it into the DOM."
onekeypress = "jQuery onekeypress(Function fn)  ==> Events/Keyboard\n    Bind a function to the keypress event of each matched\n    element, which will only be executed once."
onescroll = "jQuery onescroll(Function fn)  ==> Events/Browser\n    Bind a function to the scroll event of each matched element,\n    which will only be executed once."
color = "String color()  ==> CSS\n    Get the current CSS color of the first matched element.\n\njQuery color(String val)  ==> CSS\n    Set the CSS color of every matched element."
float = "String float()  ==> CSS\n    Get the current CSS float of the first matched element.\n\njQuery float(String val)  ==> CSS\n    Set the CSS float of every matched element."
height = "String height()  ==> CSS\n    Get the current CSS height of the first matched element.\n\njQuery height(String val)  ==> CSS\n    Set the CSS height of every matched element."
href = "String href()  ==> DOM/Attributes\n    Get the current href of the first matched element.\n\njQuery href(String val)  ==> DOM/Attributes\n    Set the href of every matched element."
wrap = "jQuery wrap(String html)  ==> DOM/Manipulation\n    Wrap all matched elements with a structure of other\n    elements.\n\njQuery wrap(Element elem)  ==> DOM/Manipulation\n    Wrap all matched elements with a structure of other\n    elements."
select = "jQuery select(Function fn)  ==> Events/Form\n    Bind a function to the select event of each matched element.\n\njQuery select()  ==> Events/Form\n    Trigger the select event of each matched element."
size = "Number size()  ==> Core\n    The number of elements currently matched."
val = "String val()  ==> DOM/Attributes\n    Get the current value of the first matched element.\n\njQuery val(String val)  ==> DOM/Attributes\n    Set the value of every matched element."
top = "String top()  ==> CSS\n    Get the current CSS top of the first matched element.\n\njQuery top(String val)  ==> CSS\n    Set the CSS top of every matched element."
contains = "jQuery contains(String str)  ==> DOM/Traversing\n    Filter the set of elements to those that contain the\n    specified text."
add = "jQuery add(String expr)  ==> DOM/Traversing\n    Adds the elements matched by the expression to the jQuery\n    object.\n\njQuery add(Array<Element> els)  ==> DOM/Traversing\n    Adds each of the Elements in the array to the set of matched\n    elements.\n\njQuery add(Element el)  ==> DOM/Traversing\n    Adds a single Element to the set of matched elements."
submit = "jQuery submit(Function fn)  ==> Events/Form\n    Bind a function to the submit event of each matched element.\n\njQuery submit()  ==> Events/Form\n    Trigger the submit event of each matched element."
next = "jQuery next()  ==> DOM/Traversing\n    Get a set of elements containing the unique next siblings of\n    each of the  matched set of elements.\n\njQuery next(String expr)  ==> DOM/Traversing\n    Get a set of elements containing the unique next siblings of\n    each of the  matched set of elements, and filtered by an\n    expression."
width = "String width()  ==> CSS\n    Get the current CSS width of the first matched element.\n\njQuery width(String val)  ==> CSS\n    Set the CSS width of every matched element."
trigger = "jQuery trigger(String type)  ==> Events\n    Trigger a type of event on every matched element."
change = "jQuery change(Function fn)  ==> Events/Form\n    Bind a function to the change event of each matched element.\n\njQuery change()  ==> Events/Form\n    Trigger the change event of each matched element."
toggleClass = "jQuery toggleClass(String class)  ==> DOM\n    Adds the specified class if it is present, removes it if it\n    is not present."
insertAfter = "jQuery insertAfter(String expr)  ==> DOM/Manipulation\n    Insert all of the matched elements after another, specified,\n    set of elements."
unmouseout = "jQuery unmouseout(Function fn)  ==> Events/Mouse\n    Removes a bound mouseout event from each of the matched\n    elements.\n\njQuery unmouseout()  ==> Events/Mouse\n    Removes all bound mouseout events from each of the matched\n    elements."
unkeyup = "jQuery unkeyup(Function fn)  ==> Events/Keyboard\n    Removes a bound keyup event from each of the matched\n    elements.\n\njQuery unkeyup()  ==> Events/Keyboard\n    Removes all bound keyup events from each of the matched\n    elements."
prev = "jQuery prev()  ==> DOM/Traversing\n    Get a set of elements containing the unique previous\n    siblings of each of the  matched set of elements.\n\njQuery prev(String expr)  ==> DOM/Traversing\n    Get a set of elements containing the unique previous\n    siblings of each of the  matched set of elements, and\n    filtered by an expression."
empty = "jQuery empty()  ==> DOM/Manipulation\n    Removes all child nodes from the set of matched elements."
unmouseup = "jQuery unmouseup(Function fn)  ==> Events/Mouse\n    Removes a bound mouseup event from each of the matched\n    elements.\n\njQuery unmouseup()  ==> Events/Mouse\n    Removes all bound mouseup events from each of the matched\n    elements."
onefocus = "jQuery onefocus(Function fn)  ==> Events/UI\n    Bind a function to the focus event of each matched element,\n    which will only be executed once."
oneresize = "jQuery oneresize(Function fn)  ==> Events/Browser\n    Bind a function to the resize event of each matched element,\n    which will only be executed once."
overflow = "String overflow()  ==> CSS\n    Get the current CSS overflow of the first matched element.\n\njQuery overflow(String val)  ==> CSS\n    Set the CSS overflow of every matched element."
resize = "jQuery resize(Function fn)  ==> Events/Browser\n    Bind a function to the resize event of each matched element.\n\njQuery resize()  ==> Events/Browser\n    Trigger the resize event of each matched element."
jquery = "String jquery()  ==> Core\n    The current SVN version of jQuery."
prependTo = "jQuery prependTo(String expr)  ==> DOM/Manipulation\n    Prepend all of the matched elements to another, specified,\n    set of elements."
grep = "Array grep(Array array, Function fn, Boolean inv)  ==> Javascript\n    Remove items that aren't matched in an array."
attr = "Object attr(String name)  ==> DOM\n    Access a property on the first matched element.\n\njQuery attr(Hash prop)  ==> DOM\n    Set a hash of key/value object properties to all matched\n    elements.\n\njQuery attr(String key, Object value)  ==> DOM\n    Set a single property to a value, on all matched elements."
onekeydown = "jQuery onekeydown(Function fn)  ==> Events/Keyboard\n    Bind a function to the keydown event of each matched\n    element, which will only be executed once."
ununload = "jQuery ununload(Function fn)  ==> Events/Browser\n    Removes a bound unload event from each of the matched\n    elements.\n\njQuery ununload()  ==> Events/Browser\n    Removes all bound unload events from each of the matched\n    elements."
error = "jQuery error(Function fn)  ==> Events/Browser\n    Bind a function to the error event of each matched element.\n\njQuery error()  ==> Events/Browser\n    Trigger the error event of each matched element."
trim = "String trim(String str)  ==> Javascript\n    Remove the whitespace from the beginning and end of a\n    string."
unmousedown = "jQuery unmousedown(Function fn)  ==> Events/Mouse\n    Removes a bound mousedown event from each of the matched\n    elements.\n\njQuery unmousedown()  ==> Events/Mouse\n    Removes all bound mousedown events from each of the matched\n    elements."
unchange = "jQuery unchange(Function fn)  ==> Events/Form\n    Removes a bound change event from each of the matched\n    elements.\n\njQuery unchange()  ==> Events/Form\n    Removes all bound change events from each of the matched\n    elements."
mouseup = "jQuery mouseup(Function fn)  ==> Events/Mouse\n    Bind a function to the mouseup event of each matched\n    element.\n\njQuery mouseup()  ==> Events/Mouse\n    Trigger the mouseup event of each matched element."
sibling = "Array sibling(Element elem)  ==> DOM/Traversing\n    All elements on a specified axis."
ready = "jQuery ready(Function fn)  ==> Events\n    Bind a function to be executed whenever the DOM is ready to\n    be traversed and manipulated."
oneunload = "jQuery oneunload(Function fn)  ==> Events/Browser\n    Bind a function to the unload event of each matched element,\n    which will only be executed once."
id = "String id()  ==> DOM/Attributes\n    Get the current id of the first matched element.\n\njQuery id(String val)  ==> DOM/Attributes\n    Set the id of every matched element."
unclick = "jQuery unclick(Function fn)  ==> Events/Mouse\n    Removes a bound click event from each of the matched\n    elements.\n\njQuery unclick()  ==> Events/Mouse\n    Removes all bound click events from each of the matched\n    elements."
ancestors = "jQuery ancestors()  ==> DOM/Traversing\n    Get a set of elements containing the unique ancestors of the\n    matched set of elements (except for the root element).\n\njQuery ancestors(String expr)  ==> DOM/Traversing\n    Get a set of elements containing the unique ancestors of the\n    matched set of elements, and filtered by an expression."
end = "jQuery end()  ==> DOM/Traversing\n    End the most recent 'destructive' operation, reverting the\n    list of matched elements back to its previous state."
unkeypress = "jQuery unkeypress(Function fn)  ==> Events/Keyboard\n    Removes a bound keypress event from each of the matched\n    elements.\n\njQuery unkeypress()  ==> Events/Keyboard\n    Removes all bound keypress events from each of the matched\n    elements."
keyup = "jQuery keyup(Function fn)  ==> Events/Keyboard\n    Bind a function to the keyup event of each matched element.\n\njQuery keyup()  ==> Events/Keyboard\n    Trigger the keyup event of each matched element."
prepend = "jQuery prepend(String html)  ==> DOM/Manipulation\n    Prepend any number of elements to the inside of every\n    matched elements, generated from the provided HTML.\n\njQuery prepend(Element elem)  ==> DOM/Manipulation\n    Append an element to the inside of all matched elements.\n\njQuery prepend(Array<Element> elems)  ==> DOM/Manipulation\n    Append any number of elements to the inside of all matched\n    elements."
appendTo = "jQuery appendTo(String expr)  ==> DOM/Manipulation\n    Append all of the matched elements to another, specified,\n    set of elements."
fadeIn = "jQuery fadeIn(Object speed)  ==> Effects/Animations\n    Fade in all matched elements by adjusting their opacity.\n\njQuery fadeIn(Object speed, Function callback)  ==> Effects/Animations\n    Fade in all matched elements by adjusting their opacity and\n    firing a  callback function after completion."
loadIfModified = "jQuery loadIfModified(String url, Hash params, Function callback)  ==> AJAX\n    Load HTML from a remote file and inject it into the DOM,\n    only if it's been modified by the server."
css = "Object css(String name)  ==> CSS\n    Access a style property on the first matched element.\n\njQuery css(Hash prop)  ==> CSS\n    Set a hash of key/value style properties to all matched\n    elements.\n\njQuery css(String key, Object value)  ==> CSS\n    Set a single style property to a value, on all matched\n    elements."
unkeydown = "jQuery unkeydown(Function fn)  ==> Events/Keyboard\n    Removes a bound keydown event from each of the matched\n    elements.\n\njQuery unkeydown()  ==> Events/Keyboard\n    Removes all bound keydown events from each of the matched\n    elements."
map = "Array map(Array array, Function fn)  ==> Javascript\n    Translate all items in array to another array of items."
removeClass = "jQuery removeClass(String class)  ==> DOM\n    Removes the specified class from the set of matched\n    elements."
onechange = "jQuery onechange(Function fn)  ==> Events/Form\n    Bind a function to the change event of each matched element,\n    which will only be executed once."
insertBefore = "jQuery insertBefore(String expr)  ==> DOM/Manipulation\n    Insert all of the matched elements before another,\n    specified, set of elements."
clone = "jQuery clone()  ==> DOM/Manipulation\n    Create cloned copies of all matched DOM Elements."
after = "jQuery after(String html)  ==> DOM/Manipulation\n    Insert any number of dynamically generated elements after\n    each of the  matched elements.\n\njQuery after(Element elem)  ==> DOM/Manipulation\n    Insert an element after each of the matched elements.\n\njQuery after(Array<Element> elems)  ==> DOM/Manipulation\n    Insert any number of elements after each of the matched\n    elements."
oneclick = "jQuery oneclick(Function fn)  ==> Events/Mouse\n    Bind a function to the click event of each matched element,\n    which will only be executed once."
unerror = "jQuery unerror(Function fn)  ==> Events/Browser\n    Removes a bound error event from each of the matched\n    elements.\n\njQuery unerror()  ==> Events/Browser\n    Removes all bound error events from each of the matched\n    elements."
slideDown = "jQuery slideDown(Object speed)  ==> Effects/Animations\n    Reveal all matched elements by adjusting their height.\n\njQuery slideDown(Object speed, Function callback)  ==> Effects/Animations\n    Reveal all matched elements by adjusting their height and\n    firing a callback function after completion."
unselect = "jQuery unselect(Function fn)  ==> Events/Form\n    Removes a bound select event from each of the matched\n    elements.\n\njQuery unselect()  ==> Events/Form\n    Removes all bound select events from each of the matched\n    elements."
mousedown = "jQuery mousedown(Function fn)  ==> Events/Mouse\n    Bind a function to the mousedown event of each matched\n    element.\n\njQuery mousedown()  ==> Events/Mouse\n    Trigger the mousedown event of each matched element."
onemousemove = "jQuery onemousemove(Function fn)  ==> Events/Mouse\n    Bind a function to the mousemove event of each matched\n    element, which will only be executed once."
oneselect = "jQuery oneselect(Function fn)  ==> Events/Form\n    Bind a function to the select event of each matched element,\n    which will only be executed once."
unbind = "jQuery unbind(String type, Function fn)  ==> Events\n    The opposite of bind, removes a bound event from each of the\n    matched elements.\n\njQuery unbind(String type)  ==> Events\n    Removes all bound events of a particular type from each of\n    the matched elements.\n\njQuery unbind()  ==> Events\n    Removes all bound events from each of the matched elements."
unload = "jQuery unload(Function fn)  ==> Events/Browser\n    Removes a bound load event from each of the matched\n    elements.\n\njQuery unload()  ==> Events/Browser\n    Removes all bound load events from each of the matched\n    elements.\n\njQuery unload(Function fn)  ==> Events/Browser\n    Bind a function to the unload event of each matched element.\n\njQuery unload()  ==> Events/Browser\n    Trigger the unload event of each matched element."
bind = "jQuery bind(String type, Function fn)  ==> Events\n    Binds a particular event (like click) to a each of a set of\n    match elements."
oneload = "jQuery oneload(Function fn)  ==> Events/Browser\n    Bind a function to the load event of each matched element,\n    which will only be executed once."
unfocus = "jQuery unfocus(Function fn)  ==> Events/UI\n    Removes a bound focus event from each of the matched\n    elements.\n\njQuery unfocus()  ==> Events/UI\n    Removes all bound focus events from each of the matched\n    elements."
position = "String position()  ==> CSS\n    Get the current CSS position of the first matched element.\n\njQuery position(String val)  ==> CSS\n    Set the CSS position of every matched element."
scroll = "jQuery scroll(Function fn)  ==> Events/Browser\n    Bind a function to the scroll event of each matched element.\n\njQuery scroll()  ==> Events/Browser\n    Trigger the scroll event of each matched element."
dblclick = "jQuery dblclick(Function fn)  ==> Events/Mouse\n    Bind a function to the dblclick event of each matched\n    element.\n\njQuery dblclick()  ==> Events/Mouse\n    Trigger the dblclick event of each matched element."
left = "String left()  ==> CSS\n    Get the current CSS left of the first matched element.\n\njQuery left(String val)  ==> CSS\n    Set the CSS left of every matched element."

