#include <boost/python.hpp>
#include <boost/python/dict.hpp>
#include "search.hpp"

using namespace boost::python;
/*
	void keyword(char* word)
	void clear()
	char_uint search(char* content,unsigned length=0)
*/
  
class SearchPy{
	Search _search;
public:
	SearchPy():_search(){

	}
	void keyword(char* word){
		_search.keyword(word);
	}
	void clear(){
		_search.clear();
	}
	dict count(char* content){
		vec_str_count result=_search.count(content);
		dict k_c;
		for(vec_str_count::iterator i=result.begin();i!=result.end();++i)
			k_c.setdefault(i->first,i->second);
		return k_c;
	}
	
};
BOOST_PYTHON_MODULE(search){

   class_<SearchPy>("Search", init<>())
         .def("keyword", &SearchPy::keyword)
         .def("count", &SearchPy::count)
		 .def("clear", &SearchPy::clear)
	;

}
