#include <vector>
#include <string>
#include <map>
extern "C" {
#include "acsmx2.h"
}

void acsm_free(ACSM_STRUCT2 * acsm);

using namespace std;

struct KeyWord{
	string keyword;
	unsigned count;
	KeyWord(char* k):count(0),keyword(k){
	}
};


int match_recall(void * id, int index, void *data);

typedef vector<KeyWord> vec_key;
typedef vector<KeyWord*> vec_key_ptr;
typedef vector<pair<string,unsigned> > vec_str_count;
class Search{
	vec_key _keywords;// ҹؼ
	ACSM_STRUCT2* _compiled;// Ĺؼ
	bool _has_compile;

public:
	Search(){
		_has_compile=false;
		_compiled=0;
	}

	~Search(){
		acsm_free(_compiled);
	}

	void keyword(char* word){
		_has_compile=false;
		_keywords.push_back(KeyWord(word));
	}
	void clear(){
		_has_compile=false;
		_keywords.clear();
	}
	void scan(char* content,int recall(void * id, int index, void *data),void *data){
		compile();
		size_t length=strlen(content);
		int state=0;
		acsmSearch2(
			_compiled,//Ĺؼ
			(unsigned char **) &content,// (صʱ, ޸)
            length,                     // ݵĳ
			recall,       // صint (*Match) (void * id, int index, void *data),
			data,                  // صĵ
			&state
		);				// ڱ״̬
	
	}

	vec_str_count count(char* content){
		vec_key_ptr count;
		scan(content,match_recall,&count);
		vec_str_count result;
		for(vec_key_ptr::iterator i=count.begin();i!=count.end();++i){
			result.push_back(make_pair((*i)->keyword,(*i)->count));
			(*i)->count=0;
		}
		return result;
	}

private:
	void compile(){
		if(_has_compile)return;
		
		acsm_free(_compiled);

		_compiled=acsmNew2();
		_compiled->acsmFormat = ACF_SPARSE;
		_compiled->acsmFSA    = FSA_DFA;

		for(vec_key::iterator i=_keywords.begin();i!=_keywords.end();++i){
			acsmAddPattern2(
				_compiled,
				(unsigned char*)((*i).keyword.c_str()),
				(*i).keyword.length(),
				false ,           // bool not nocase
				0,                // int offset
				0,                // int depth
				static_cast<void *>(&(*i)),	// void * id
				0               // int iid;
			);
		}

		acsmCompile2(_compiled);

		_has_compile=true;
	}
};

