from decorator import decorator

from db.query import Query
from model import Model
from db.relations import ForeignKey,OneToMany

def transaction(func):
    def  _func(func,*args, **kwds):
        Query.begin()
        try:
            result = func(*args, **kwds)
            Query.commit()
            return result
        except:
            Query.rollback()
            raise
    return decorator(_func, func)

