from docutils import nodes, utils
from docutils.parsers.rst import directives, states

import docnodes

display_values = ('on', 'off')

def display(argument):
    return directives.choice(argument, display_values)

def code(name, arguments, options, content, lineno,
          content_offset, block_text, state, state_machine):
    opt = {'display':'on'}
    opt.update(options)
    
    docnodes.Node(content, ''.join(arguments), **opt)
    if opt['display'].lower() == 'on':
        return [nodes.literal_block('', '\n'.join(content))]
    else:
        return []

code.content = 1
code.arguments = (1, 0, 1)
code.options = {
                'file':directives.unchanged,    #used to save code to the file
                'display':display,              #if show code in document
                }

directives.register_directive('code', code)

try:
    import locale
    locale.setlocale(locale.LC_ALL, '')
except:
    pass

from docutils.core import publish_cmdline, default_description


description = ('Generates (X)HTML documents from standalone reStructuredText '
               'sources.  ' + default_description)

publish_cmdline(writer_name='html', description=description)

docnodes.render()