// STConverter.cpp : Defines the entry point for the DLL application.
//

#include <Python.h>
#include <windows.h>
#include <stdio.h>
#include <Oleauto.h>

#pragma comment(lib, "Oleaut32")

static void* hConverter;
typedef int  (*CONVERTBYWORD)(void*, wchar_t*, int, void*, void*, int*, wchar_t**, int*);
typedef int  (*CONVERTBYCHAR)(void*, wchar_t*, int, wchar_t**, int*);

static CONVERTBYCHAR S2TC;
static CONVERTBYCHAR T2SC;
static CONVERTBYWORD S2TW;
static CONVERTBYWORD T2SW;

static PyObject* STConverter_Traditional2SimplifiedByWord(PyObject* self, PyObject* args)
{
	PyObject* arg = NULL;
	PyObject* result = NULL;
	wchar_t* res = NULL;
	int len = 0;
	int ret = 0;
	int nWord = 0;
	if (!PyArg_ParseTuple(args, "U", &arg))
	{
		PyErr_SetString(PyExc_TypeError, "only unicode is supported");
		return NULL;
	}

	ret = T2SW(hConverter, 
					PyUnicode_AS_UNICODE(arg), PyUnicode_GetSize(arg),
					NULL, NULL, &nWord,
					&res, &len);

	if (!ret)
	{
		if (res)
			SysFreeString(res);
		PyErr_SetString(PyExc_ValueError, "convert error!");
		return NULL;
	}

	result = PyUnicode_FromUnicode(res, len);
	SysFreeString(res);
	return result;
}

static PyObject* STConverter_Simplified2TraditionalByWord(PyObject* self, PyObject* args)
{
	PyObject* arg = NULL;
	PyObject* result = NULL;
	wchar_t* res = NULL;
	int len = 0;
	int ret = 0;
	int nWord = 0;
	if (!PyArg_ParseTuple(args, "U", &arg))
	{
		PyErr_SetString(PyExc_TypeError, "only unicode is supported");
		return NULL;
	}

	ret = S2TW(hConverter, 
					PyUnicode_AS_UNICODE(arg), PyUnicode_GetSize(arg),
					NULL, NULL, &nWord,
					&res, &len);

	if (!ret)
	{
		if (res)
			SysFreeString(res);
		PyErr_SetString(PyExc_ValueError, "convert error!");
		return NULL;
	}

	result = PyUnicode_FromUnicode(res, len);
	SysFreeString(res);
	return result;
}

static PyObject* STConverter_Traditional2SimplifiedByChar(PyObject* self, PyObject* args)
{
	PyObject* arg = NULL;
	PyObject* result = NULL;
	wchar_t* res = NULL;
	int len = 0;
	int ret = 0;
	if (!PyArg_ParseTuple(args, "U", &arg))
	{
		PyErr_SetString(PyExc_TypeError, "only unicode is supported");
		return NULL;
	}

	ret = T2SC(hConverter, 
					PyUnicode_AS_UNICODE(arg), PyUnicode_GetSize(arg),
					&res, &len);

	if (!ret)
	{
		if (res)
			SysFreeString(res);
		PyErr_SetString(PyExc_ValueError, "convert error!");
		return NULL;
	}

	result = PyUnicode_FromUnicode(res, len);
	SysFreeString(res);
	return result;
}

static PyObject* STConverter_Simplified2TraditionalByChar(PyObject* self, PyObject* args)
{
	PyObject* arg = NULL;
	PyObject* result = NULL;
	wchar_t* res = NULL;
	int len = 0;
	int ret = 0;
	if (!PyArg_ParseTuple(args, "U", &arg))
	{
		PyErr_SetString(PyExc_TypeError, "only unicode is supported");
		return NULL;
	}

	ret = S2TC(hConverter, 
					PyUnicode_AS_UNICODE(arg), PyUnicode_GetSize(arg),
					&res, &len);

	if (!ret)
	{
		if (res)
			SysFreeString(res);
		PyErr_SetString(PyExc_ValueError, "convert error!");
		return NULL;
	}

	result = PyUnicode_FromUnicode(res, len);
	SysFreeString(res);
	return result;
}

static PyMethodDef STConverterMethods[] = {
	{ "Traditional2SimplifiedByWord",  STConverter_Traditional2SimplifiedByWord, METH_VARARGS },
	{ "Simplified2TraditionalByWord",  STConverter_Simplified2TraditionalByWord, METH_VARARGS },
	{ "Traditional2SimplifiedByChar",  STConverter_Traditional2SimplifiedByChar, METH_VARARGS },
	{ "Simplified2TraditionalByChar",  STConverter_Simplified2TraditionalByChar, METH_VARARGS },
	{ NULL, NULL },
};

int InitConverter()
{
	wchar_t szFileName[MAX_PATH];
	wchar_t *pszEnd = NULL;
	HMODULE hMdl = LoadLibraryW(L"WordConvertDll.dll");
	typedef int (*INITCONVERTER)(wchar_t*);
	typedef void*  (*CREATECONVERTER)();
	INITCONVERTER IC;
	CREATECONVERTER CC;

	if (hMdl == NULL)
		return 1;

	IC = (INITCONVERTER)GetProcAddress(hMdl, "InitConverter");
	CC = (CREATECONVERTER)GetProcAddress(hMdl, "CreateConverter");
	if (IC == NULL || CC == NULL)
		return 2;

	if (!GetModuleFileNameW(hMdl, szFileName, MAX_PATH)) 
		return 3;

	pszEnd = wcsrchr(szFileName, L'\\');
	if (pszEnd == NULL)
		return 4;

	wcscpy(pszEnd+1, L"STConverterData\\");
	if (IC(szFileName))
		return 5;

	hConverter = CC();
	if (hConverter == NULL)
		return 6;

	S2TC = (CONVERTBYCHAR)GetProcAddress(hMdl, "Simplified2TraditionalByChar");
	T2SC = (CONVERTBYCHAR)GetProcAddress(hMdl, "Traditional2SimplifiedByChar");
	S2TW = (CONVERTBYWORD)GetProcAddress(hMdl, "Simplified2TraditionalByWord");
	T2SW = (CONVERTBYWORD)GetProcAddress(hMdl, "Traditional2SimplifiedByWord");
	if (!S2TC || !T2SC || !S2TW || !T2SW)
		return 7;
	return 0;
}

PyMODINIT_FUNC initSTConverter()
{
	Py_InitModule("STConverter", STConverterMethods);

	if (InitConverter())
	{
		PyErr_SetString(PyExc_ImportError, "Load \"WordConvertDll.dll\" Error!");
		return;
	}
}
