from django.shortcuts import render_to_response
from django.template.context import RequestContext
import utils
from models import Paper

def index(request):
    return render_to_response('contest/index.html')

def paper_view(request, paper=None):
    paper = paper or utils.make_random_paper()
    results = {}
    if request.POST:
        results = {'cq':[],'bq':[],'aq':[]}
        print request.POST
        for key, value in request.POST.lists():
            if key.startswith('cq') or key.startswith('aq')\
                    or key.startswith('bq'):
                if key.startswith('cq') or key.startswith('aq'):
                    value = value[0]
                number = int(key[2:])
                results[key[:2]].append((number, value))
            #elif key.startswith('bq'):
                #q_number, blank_number = key.rsplit('_', 1)
                #number = int(q_number[2:])
                #blank_number = int(blank_number)
             #   results.setdefault(key[:2],[]).append((number, 
        dict_results = {}
        for key, value in results.items():
            dict_results[key] = dict(value)

        for key, value in results.copy().items():
            value.sort(key=lambda i:i[0])
            results[key] = [i[1] for i in value]

    if not results:
        cqs = [cq.to_html('cq'+str(i)) for i, cq in enumerate(paper['cqs'])]
        bqs = [bq.to_html('bq'+str(i)) for i, bq in enumerate(paper['bqs'])]
        aqs = [aq.to_html('aq'+str(i)) for i, aq in enumerate(paper['aqs'])]
        return render_to_response('contest/paper.html',
                RequestContext(request,
                    {'cqs':cqs,'bqs':bqs,'aqs':aqs,'paper':paper}))
    else:
        print 'results:',results
        print 'dict_results:',dict_results
        cqs = [cq.to_html('cq'+str(i), value=dict_results['cq'].get(i,'')) for i, cq in enumerate(paper['cqs'])]
        bqs = [bq.to_html('bq'+str(i), value=dict_results['bq'].get(i,[])) for i, bq in enumerate(paper['bqs'])]
        aqs = [aq.to_html('aq'+str(i), value=dict_results['aq'].get(i,'')) for i, aq in enumerate(paper['aqs'])]
        return render_to_response('contest/paper.html',
                RequestContext(request,
                    {'cqs':cqs,'bqs':bqs,'aqs':aqs,'paper':paper,'results':results}))

def get_paper(request, id):
    paper = Paper.objects.get(pk=int(id))
    data = {'title':paper.title,
            'cqs':paper.cqs.all(),
            'bqs':paper.bqs.all(),
            'aqs':paper.aqs.all(),
            }
    return paper_view(request, data)
