#!/usr/bin/python

# Don't use setuptools as I can't get it to work right
# with Django at the moment
from distutils.core import setup
import sys

# Work-around python < 2.3
if sys.version_info < (2, 3):
    _setup = setup
    def setup(**kwargs):
        if kwargs.has_key("classifiers"):
            del kwargs["classifiers"]
        _setup(**kwargs)

classifiers = """\
Development Status :: 5 - Production/Stable
Environment :: Web Environment
License :: OSI Approved :: MIT License
Intended Audience :: Developers
Operating System :: OS Independent
Programming Language :: Python
Topic :: Internet :: WWW/HTTP :: Dynamic Content :: CGI Tools/Libraries
Topic :: Software Development :: Testing
"""

setup(name = "djangovalidator",
      author = "Luke Plant",
      author_email = "L.Plant.98@cantab.net",
      url = "http://lukeplant.me.uk/resources/djangovalidator/",
      version = '1.2',
      description = "A Django app and middleware for performing validation on outgoing HTML",
      platforms = ["any"],
      py_modules = [
        'lukeplant_me_uk.__init__',
        'lukeplant_me_uk.django.__init__',
        'lukeplant_me_uk.django.validator.__init__',
        'lukeplant_me_uk.django.validator.urls',
        'lukeplant_me_uk.django.validator.views',
        'lukeplant_me_uk.django.validator.models',
        'lukeplant_me_uk.django.validator.middleware',
      ],
      # Don't list higher level packages as otherwise all modules will be included
      packages = ['lukeplant_me_uk.django.validator'],
      package_data = {'lukeplant_me_uk.django.validator': ['templates/validator/*.html'] },
      classifiers = filter(None, classifiers.split("\n")),
      long_description = """\
This app is intended to be plugged into a Django installation while
it is being developped.  Using a external validator, all outgoing HTML
is checked for validity and any failures are logged and can be browsed
easily.
""",

      license = "http://www.opensource.org/licenses/mit-license",

      #      namespace_packages = [
      #        'lukeplant_me_uk',
      #        'lukeplant_me_uk.django',
      #      ],
      #      zip_safe = False,
)
