from lukeplant_me_uk.django.validator.models import ValidationFailure
from django.http import HttpResponseRedirect

def bulkdelete(request):
    if request.POST:
        postkeys = request.POST.keys()
        if 'deleteall' in postkeys:
            ValidationFailure.objects.all().delete()
        elif 'deleteselected' in postkeys:
            for k in postkeys:
                if k.startswith('deleteitem'):
                    k = k[len('deleteitem'):]
                    try:
                        vf = ValidationFailure.objects.get(id=k)
                        vf.delete()
                    except ValidationFailure.DoesNotExist:
                        pass
            
    return HttpResponseRedirect("../")
    
def delete(request, object_id):
    if request.POST:
        try:
            vf = ValidationFailure.objects.get(id=object_id)
            vf.delete()
        except ValidationFailure.DoesNotExist:
            pass
    return HttpResponseRedirect("../../")
        
