#!/usr/bin/python
"""
Creates a source distribution from a project in this tree
"""

import sys
import os
import shutil

SETUPDIR = 'setup'
if len(sys.argv) == 1:
    print """Usage:
    python dist.py <projectname>
    
    where <projectname> is one of:    """
    for d in os.listdir(os.path.realpath(SETUPDIR)):
        if not d.startswith('.') and os.path.isdir(os.path.join(SETUPDIR,d)):
            print "        " + d
    
    print
else:
    d = os.path.join(SETUPDIR, sys.argv[1])
    if not os.path.isdir(d):
        print "'%s' is not a directory in the setup folder."
        exit(1)
    
    for f in ['setup.py', 'MANIFEST.in', 'README', 'AUTHORS']:
        fullpath = os.path.join(d, f)
        if os.path.isfile('../' + f):
            os.unlink('../' + f)
        if os.path.isfile(fullpath):
            shutil.copy(fullpath, '../')
    os.chdir('../')
    os.system('python setup.py sdist --force-manifest')
