#test-dict4ini.py

import os,sys
print "we are in %s" % os.getcwd()
dir = 'c:\\programs'
#os.chdir(dir)
sys.path[:0] = [dir]
import p3p
import p3p.dict4ini as dict4ini

class MyDict:
    def __init__(self, fid):
        self.fid = fid
        self.env = 'prod'    #default
        x = dict4ini.DictIni(inifile=fid)
        self.x = x
       
    def read_ini(self):
        x = self.x
        env =  x.common.env
        print "env = %s" % env
        self.env = env
        self.drive = eval('x.%s.drive' % env)
        self.myHome = eval('x.%s.home' % env)
        self.programHome = eval('x.%s.programHome' % env)
        self.pwHome = eval('x.%s.pwHome' % env)
        self.pwPythonHome = eval('x.%s.pwPythonHome' % env)
        print "read %s file" % fid
       
    def print_vars(self):
        print "env: %s\ndrive: %s\nhome: %s\nprogramHome: %s\npwHome: %s\npythonHome: %s\n" % (
            self.env, self.drive, self.myHome, self.programHome, self.pwHome, self.pwPythonHome)
   
    def write_ini(self):
        x = self.x
        x.dev._comment = "'dev' is for when you are running in a development environment"
        x.dev.drive = 'd'
        x.dev.home = 'c:/programs/PipeworksB/lib/python/mtr'
        x.dev.pwHome = 'c:/programs/PipeworksB'
        x.dev.lwHome = 'd:/lw21/lw21-kmep'
        x.dev.pwPythonHome = 'c:/programs/PipeworksB/lib/python'
        x.dev.programHome = 'c:/programs'
        x.dev.email = ['stewart.midwinter','criticalcontrol.com']
        x.dev.mailServer = '11EXG01'
        print "wrote dev section"

        x.faraway._comment = "'faraway' is for when you are running in production"
        x.faraway.drive = 'd'
        x.faraway.home = 'd:/data/dev/python/monitoring/mtr'
        x.faraway.pwHome = 'd:/programs/PipeworksB'
        x.faraway.lwHome = 'd:/lw21-kmep'
        x.faraway.pwPythonHome = 'd:/data/dev/python/monitoring/'
        x.faraway.programHome = 'd:/programs'
        x.faraway.email = ['stewart.midwinter','criticalcontrol.com']
        x.faraway.mailServer = '11EXG01'
        print "wrote faraway section"

        x.mac._comment = "'mac' is for when you are running in production"
        x.mac.drive = '/Volumes/stewartmidwinter'
        x.mac.home = '/Volumes/stewartmidwinter/MyDocuments/data/dev/python/monitoring/mtr'
        x.mac.pwHome = '/Applications/PipeworksB'
        x.mac.lwHome = '/Applications/lw21-kmep'
        x.mac.pwPythonHome = '/Volumes/stewartmidwinter/MyDocuments/data/dev/python/monitoring/'
        x.mac.programHome = '/Applications'
        x.mac.email = ['stewartmidwinter','localhost']
        x.mac.mailServer = 'localhost'
        print "wrote mac section"

        x.prod._comment = "'prod' is for when you are running in production"
        x.prod.comment('drive',"'drive' is where we store all of our modules, e.g. Pmw, p3p")
        x.prod.drive = 'c'
        x.prod.comment('home','home is where this file, and monitorLW.py, reside')
        x.prod.home = 'c:/programs/PipeworksB/lib/python/mtr'
        x.prod.comment('pwHome', "pwHome is where PipeWorks lives")
        x.prod.pwHome = 'c:/programs/PipeworksB'
        x.prod.comment('lwHome', "pwHome is where LeakWarn Classic lives")
        x.prod.lwHome = 'd:/lw21'
        x.prod.comment('pwPythonHome',"pwPythonHome contains the mtr and sm folder")
        x.prod.pwPythonHome = 'c:/programs/PipeworksB/lib/python'
        x.prod.comment('programHome','programHome is where Pmw and p3p live')
        x.prod.programHome = 'c:/programs'
        x.prod.comment('email',"email username, domain-name")
        x.prod.email = ['stewart.midwinter','criticalcontrol.com']
        x.prod.comment('mailServer',"email server that with SMTP protocol available")
        x.prod.mailServer = '11EXG01'
        print "wrote prod section"

        x.common._comment = 'monitorLW.ini - settings for monitorLW.py app' \
                +'\nthis ini file is read/written by the app using dict4ini, available from: http://wiki.woodpecker.org.cn/moin/Dict4Ini' \
                +"\n\n#'common' is for settings common to all environments"
        x.common.comment('env',"first set your env: 'prod', 'dev', 'faraway' or 'mac'")
        x.common.env = self.env     #write out value that was read in from ini file
        x.common.comment('sender',"sender's first-name, last-name")
        x.common.sender = ['Stewart', 'Midwinter']
        print "wrote common section"
       
        x.save()

if __name__ == "__main__":
    print "we are in %s" % os.getcwd()
    os.chdir('c:\\programs\\PipeWorksB\\lib\\python\\mtr')
    fid = 'monitorLWtest.ini'
    dic = MyDict(fid)
    dic.read_ini()
    dic.print_vars()
    dic.write_ini()
