from meteor import *

header = T('''
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" 
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">

<head>
<title><#title#></title>
<meta name="version" content="S5 1.0" />
<link rel="stylesheet" href="ui/slides.css" type="text/css" media="projection" id="slideProj" />
<link rel="stylesheet" href="ui/opera.css" type="text/css" media="projection" id="operaFix" />
<link rel="stylesheet" href="ui/print.css" type="text/css" media="print" id="slidePrint" />
<script src="ui/slides.js" type="text/javascript"></script>
</head>
<body>
''')

body = T('''
<div class="layout">

<div id="currentSlide"></div>
<div id="header"></div>
<div id="footer">
<h1><#location_date_of_presentation#></h1>
<h2><#slide_show_title_here#></h2>
<div id="controls"></div>
</div>

</div>


<div class="presentation">

<div class="slide">
<h1><#slide_show_title_here#></h1>
<h3><#name_of_presenter#></h3>
<h4><#affiliation_of_presenter#></h4>
</div>

<#slides#>

</div>
''')
footer = T('''
</body>
</html>
''')

slides = T('''
<div class="slide">
<h1><#slide_title#></h1>
<#content#>
<div class="handout">
[any material that should appear in print but not on the slide]
</div>
</div>
''')

html = T('''<#header#><#body#><#footer#>''')
