#!/usr/bin/env python
# -*- coding: utf-8; -*-
# report bugs to: riverfor@sina.com.cn
"""This is the console of the admin's console
"""
import sys
import string
from cmd_map import map_add_service
from twisted.internet.protocol import Protocol, ClientFactory
from twisted.internet import reactor, defer
#from twisted.python import log
from compass.common.config import DISPATCHER_SERVER_HOST, DISPATCHER_SERVER_PORT
from compass.protocols.admin import AdminClient

class AdminClientProtocol(AdminClient, Protocol):
    __doc__ = "the protocol admin used"

    def dataReceived(self, data):
        print "received:", [data]
	AdminClient.dataReceived(self, data)

    def connectionLost(self, reason):
        """undocumented
	"""
	reactor.stop()
	print "lose connection"

    def connectionMade(self):
        """
	before this was call, the getCommand must have been called to get the next command
	"""
	args = (map_add_service(),)
	self.cmd_callback(self.add_service, args)
	self.connect()

class AdminClientFactory(ClientFactory):
    """
    the factory of admin client
    """
    def buildProtocol(self, addr):
        return AdminClientProtocol()

    def startedConnecting(sekf, connector):
        print "started to connect %s:%s" % (DISPATCHER_SERVER_HOST, DISPATCHER_SERVER_PORT)

    def clientConnectionLost(self, connector, reason):
        print "lose connection with server %s:%s" % (DISPATCHER_SERVER_HOST, DISPATCHER_SERVER_PORT)
	reactor.stop()

def getHelp():
    """ get help infomation from ADMIN
    """
    fd = open("ADMIN")
    line = fd.readline()
    while line <> "":
        print ">>>%s" % string.strip(line)
	line = fd.readline()

def execute(cmd):
    """
    execute command
    """
    cfd = AdminClientFactory()
    reactor.connectTCP(DISPATCHER_SERVER_HOST, DISPATCHER_SERVER_PORT, cfd)
    reactor.run()

if __name__ == "__main__":
    """
    mail loop of admin console
    """
    getHelp()
    #log.startLogging(sys.stdout)
    while 1:
	cmd = string.strip(raw_input("INPUTCMD\n>>>"))
	if cmd == "h":
	    getHelp()
	else:
	    execute(cmd)
