#!/usr/bin/env python
# -*- coding: utf-8 -*-
# report bugs to: riverfor@sina.com.cn
"""
Test target module: compass.comon.cs
"""
from compass.test.dispatcherserver.base import DispatcherServerTestCase
from compass.test.adminclient.base import AdminClientTestCase
from compass.test.framework import TargetTest
from compass.protocols.base import makeAuthSource, checkAuthSource

class CsForServerTestCase(DispatcherServerTestCase):
    """
    this part is response to the request of the service's operation
    """
    def testTestProtocol(self):
	self._socketDone('test message')
	self.assertEquals(len(self.server.config), 10)
	self.assertEquals(self.server.config['password'], 'testpsw')
	self.assertEquals(self.server.config['service_id'], 'test001')

    def testConnectFail(self):
	packet = self.client.data_packed('connect', \
	                                 ('service_id', 's001'), \
	                		 ('version', 0x0001), \
					 ('time_stamp', '20041213'), \
					 ('auth_source', 'riverfor@gmail.com')  \
					)
	self.assertEquals(self.client.messages, [])
	self._socketDone(packet)
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'connect')
	self.assertEquals(len(bag.body.fields), 4)
	self.assertEquals(bag.body['version'], 0x001)
	self.assertEquals(bag.body['time_stamp'], '20041213')
	self.assertEquals(bag.body['auth_source'], 'riverfor@gmail.com')
	self.assertEquals(bag.body['service_id'], 's001')
	self.assertEquals(self.client.messages, [])

    def testConnectSuccessResp(self):
	auth_source = makeAuthSource('s001', self.server.config['password'], '20041225')
	packet = self.client.data_packed('connect', \
	                                 ('service_id', 's001'), \
	                    	         ('version', 0x02), \
					 ('time_stamp', '20041225'), \
					 ('auth_source', auth_source) \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'connect')
	self.assertEquals(sbag.body['service_id'], 's001')
	self.assertEquals(sbag.body['version'], 2)
	self.assertEquals(sbag.body['time_stamp'], '20041225')
	self.assertEquals(sbag.body['auth_source'], auth_source)
	self.assertEquals(cbag.msgname, 'connect_resp')
	self.assertNotEquals(type(cbag.body['status']), str)

    def testDisconnect(self):
	self._socketDone(self.client.data_packed('disconnect'))
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'disconnect')
	self.assertEquals(len(sbag.body.fields), 0)
	self.assertEquals(cbag.msgname, 'disconnect_resp')
	self.assertEquals(len(cbag.body.fields), 0)

class CsForClientTestCase(AdminClientTestCase):
    """undocumented
    """
    def testConnect(self):
	"""undocumented
	"""
	def a(arg):
	    return arg
	self.client.cmd_callback(a, ('aa',))
	self._socketDone(self.server.data_packed('connect_resp', ('status', 1), ('version', 0x001)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'connect_resp')
	self.assertEquals(self.client.prev_cmd, a)
	self.assertEquals(self.client.prev_args, ("aa",))
