#!/usr/bin/env python
# -*- coding: utf-8 -*-
# report bugs to: riverfor@sina.com.cn
"""
This module includes some mock object
"""
from twisted.internet import defer, reactor
from twisted.protocols import loopback
from compass.test.framework import unittest
from compass.protocols.base import ByteMessageProtocol 
from compass.common.framework import DataPacked
from compass.storage.storage import Storage
from compass.test.libutil import getMessages
from compass.common.error import SUCCESS
loopbackFunc = loopback.loopback

class PacketSender(ByteMessageProtocol, DataPacked):
    """
    Mock object
    """
    def __init__(self):
        ByteMessageProtocol.__init__(self)
        self.conn = defer.Deferred()
	self.messages = []

    def connectionMade(self):
        self.conn.callback(None)

    def dataReceived(self, data):
        self.messages.extend(getMessages(data))
        ByteMessageProtocol.dataReceived(self, data)

class PacketSaver(ByteMessageProtocol, DataPacked):
    """
    Mock object
    """
    def __init__(self):
        ByteMessageProtocol.__init__(self)
        self.conn = defer.Deferred()
	self.test_packets = []
        self.messages = []

    def connectionMade(self):
        self.conn.callback(None)

    def dataReceived(self, data):
        def notTestTestProtocol(data):
            return not data[:4] == 'test'
        if notTestTestProtocol(data):
            self.messages.extend(getMessages(data))
        self.transport.loseConnection()

class MockStorage(Storage):
    """
    Mock one recode storage
    """
    data = {}
    result = None
    ### Build the commands
    def lookup(self, zone, conditions):
        self.result = []
	for item in self.data[zone]:
	    flag = 1
	    for key in conditions.keys():
	        if item[key] != conditions[key]:
		    flag = 0
	    if flag:	    
	        self.result.append(item)
	if len(self.result) == 0:
	    self.result = None
	return self.result    

    def delete(self, zone, conditions):
	for item in self.data[zone]:
	    flag = 1
	    for key in conditions.keys():
	        if item[key] != conditions[key]:
		    flag = 0
	    if flag:	    
	        self.data[zone].remove(item)
	self.result = SUCCESS
	return self.result

    def add(self, zone, key2value):
	self.data[zone].append(key2value)
	self.result = SUCCESS
	return self.result

    def update(self, zone, conditions, key2value):
	for item in self.data[zone]:
	    flag = 1
	    for key in conditions.keys():
	        if item[key] != conditions[key]:
		    flag = 0
	    if flag:
	        tmp = item.update(key2value)
        self.result = SUCCESS
	return self.result

    def close(self):
        pass

"""
undocumented
"""
class TargetTest(unittest.TestCase):
    """Tested target
    """
    target = None
    mock_object = None

    def _setUp(self):
        """
	undocumented
	"""
	self.testconf = {'service_id' : 'test001', 'password'  : 'testpsw'} # used testProtocol
        self.target.config.update(self.testconf)

    def tearDown(self):
        for dc in reactor.getDelayedCalls():
            dc.cancel()
        del self.testconf
        del self.mock_object
	del self.target

    def _socketDone(self, packet):
	"""
	undocumented
	"""
	def socketfunc(parameter):
	    self.mock_object.sendData(packet)
	    self.mock_object.transport.loseConnection()
	# end
	self.mock_object.conn.addCallback(socketfunc)
	loopbackFunc(self.target, self.mock_object)

    def _csocketDone(self, func, *parameters):
	"""
	undocumented
	"""
	def csocketfunc(parameter):
	    apply(func, parameters)
	    self.mock_object.transport.loseConnection()
	# end
	self.mock_object.conn.addCallback(csocketfunc)
	loopbackFunc(self.target, self.mock_object)

    def _cocketDone(self, packet):
	def cocketfunc(parameter):
	    self.target.sendData(packet)
	    self.target.transport.loseConnection()
	# end
	self.target.conn.addCallback(cocketfunc)
	loopbackFunc(self.target, self.mock_object)

    ### mock stoage and init
    def _db_setup(self):
        """
	undocumented
	"""
	self.target.storage = MockStorage()
	self.target.lookup = self.target.storage.lookup
	self.target.delete = self.target.storage.delete
	self.target.add = self.target.storage.add
	self.target.update = self.target.storage.update
	self.target.storage.data = {}

    def _dbInit(self, data = {}):
	"""
	undocumented
	"""
        self.target.storage.data = data
