#!/usr/bin/env python
# -*- coding: utf-8 -*-
# report bugs to: riverfor@sina.com.cn
"""
Test target module: compass.common.response.dispatcherservice
"""

from compass.common.error import SUCCESS, DB_IO, SERVICE_NO_EXIST
from compass.common.config import SR_STATUS_DEAD, SR_STATUS_ACTIVE, SR_STATUS_LOGOUT, SR_STATUS_LOGIN, SR_STATUS_INWARNING
from compass.test.dispatcherserver.base import DispatcherServerTestCase

class ServiceForResponseTestCase(DispatcherServerTestCase):
    """
    this part is the response to the request of the service's operation
    """
    def testAddServiceFail(self):
	"""
	this function replace the real io operation
	"""
	self._dbInit({'service': [{'id': 'test004'}]})
	packet = self.client.data_packed('add_service', \
	                                 ('service_id', 'test004'), \
					 ('desc', 'desc for add'), \
					 ('password', 'password'), \
					 ('host', '192.185.90'), \
					 ('port', 9999), \
					 ('domain', 0x003), \
					 ('tactics', 0x004), \
					 ('status', 'A') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'add_service')
	self.assertEquals(sbag.body['password'], 'password')
	self.assertEquals(sbag.body['service_id'], 'test004')
	self.assertEquals(sbag.body['desc'], 'desc for add')
	self.assertEquals(sbag.body['host'], '192.185.90')
	self.assertEquals(sbag.body['port'], 9999)
	self.assertEquals(sbag.body['domain'], 0x003)
	self.assertEquals(sbag.body['tactics'], 0x004)
	self.assertEquals(sbag.body['status'], 'A')
	self.assertEquals(cbag.msgname, 'add_service_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['service']
	result = self.server.storage.result
	self.assertEquals(len(data), 1)
	self.assertEquals(data[0]['id'], 'test004')
	self.assertNotEquals(result, SUCCESS)
	
    def testAddServiceSuccess(self):
	"""
	this functionreplace the real io operation
	"""
	self._dbInit({'service': [{'id': 'test003'}]})
	packet = self.client.data_packed('add_service', \
	                                 ('service_id', 'test004'), \
					 ('desc', 'desc for add'), \
					 ('password', 'password'), \
					 ('host', '192.185.90'), \
					 ('port', 9999), \
					 ('domain', 0x003), \
					 ('tactics', 0x004), \
					 ('status', 'A') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'add_service')
	self.assertEquals(sbag.body['password'], 'password')
	self.assertEquals(sbag.body['service_id'], 'test004')
	self.assertEquals(sbag.body['desc'], 'desc for add')
	self.assertEquals(sbag.body['host'], '192.185.90')
	self.assertEquals(sbag.body['port'], 9999)
	self.assertEquals(sbag.body['domain'], 0x003)
	self.assertEquals(sbag.body['tactics'], 0x004)
	self.assertEquals(sbag.body['status'], 'A')
	self.assertEquals(cbag.msgname, 'add_service_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['service']
	result = self.server.storage.result
	self.assertEquals(len(data), 2)
	self.assertEquals(data[0]['id'], 'test003')
	self.assertEquals(data[1]['id'], 'test004')
	self.assertEquals(data[1]['password'], 'password')
	self.assertEquals(data[1]['desc'], 'desc for add')
	self.assertEquals(data[1]['host'], '192.185.90')
	self.assertEquals(data[1]['port'], 9999)
	self.assertEquals(data[1]['domain'], 3)
	self.assertEquals(data[1]['tactics'], 4)
	self.assertEquals(data[1]['status'], 'A')
	self.assertEquals(result, SUCCESS)

    def testDelServiceFail(self):
	self._dbInit({'service': [{'id': 'test003'}, {'id': 'test004'}], \
	              'sgservice': [{'serviceid': 'test003', 'sgid': 'sg001'}, \
		                    {'serviceid': 'test004', 'sgid': 'sg001'} \
				   ]})
	self._socketDone(self.client.data_packed('del_service', ('service_id', 'r004')))
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'del_service')
	self.assertEquals(sbag.body['service_id'], 'r004')
	self.assertEquals(cbag.msgname, 'del_service_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	datas = self.server.storage.data['service']
	datag = self.server.storage.data['sgservice']
	result = self.server.storage.result
	self.assertEquals(len(datas), 2)
	self.assertEquals(len(datag), 2)
	self.assertEquals(datas[0]['id'], 'test003')
	self.assertEquals(datas[1]['id'], 'test004')
	self.assertEquals(datag[0]['serviceid'], 'test003')
	self.assertEquals(datag[0]['sgid'], 'sg001')
	self.assertEquals(datag[1]['serviceid'], 'test004')
	self.assertEquals(datag[1]['sgid'], 'sg001')
	self.assertNotEquals(result, SUCCESS)
	
    def testDelServiceSuccess(self):
	self._dbInit({'service': [{'id': 'r004'}, {'id': 'test004'}], \
	              'sgservice': [{'serviceid': 'r004', 'sgid': 'sg001'}, \
		                    {'serviceid': 'test004', 'sgid': 'sg001'} \
				   ]})
	self._socketDone(self.client.data_packed('del_service', ('service_id', 'r004')))
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'del_service')
	self.assertEquals(sbag.body['service_id'], 'r004')
	self.assertEquals(cbag.msgname, 'del_service_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	datas = self.server.storage.data['service']
	datag = self.server.storage.data['sgservice']
	result = self.server.storage.result
	self.assertEquals(len(datas), 1)
	self.assertEquals(len(datag), 1)
	self.assertEquals(datas[0]['id'], 'test004')
	self.assertEquals(datag[0]['serviceid'], 'test004')
	self.assertEquals(datag[0]['sgid'], 'sg001')
	self.assertEquals(result, SUCCESS)

    def testServiceLoginSuccess(self):
        self._dbInit({'service': [{'id': 's001', 'status': 'D'}]})
	packet = self.client.data_packed('service_login', \
	                                 ('service_id', 's001'), \
			                 ('listen_host', 'local'), \
					 ('listen_port', 8000), \
					 ('status', SR_STATUS_LOGIN) \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'service_login')
	self.assertEquals(sbag.body['service_id'], 's001')
	self.assertEquals(sbag.body['listen_host'], 'local')
	self.assertEquals(sbag.body['listen_port'], 8000)
	self.assertEquals(sbag.body['status'], SR_STATUS_LOGIN)
	self.assertEquals(cbag.msgname, 'service_login_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['service']
	result = self.server.storage.result
	self.assertEquals(len(data), 1)
	self.assertEquals(data[0]['id'], 's001')
	self.assertEquals(data[0]['status'], SR_STATUS_LOGIN)
	self.assertEquals(data[0]['listen_port'], 8000)
	self.assertEquals(data[0]['listen_host'], 'local')
	self.assertEquals(result, SUCCESS)
	
    def testServiceLoginFail(self):
        self._dbInit({'service': [{'id': 's002', 'status': 'D'}]})
	packet = self.client.data_packed('service_login', \
	                                 ('service_id', 's001'), \
			                 ('listen_host', 'local'), \
					 ('listen_port', 8000), \
					 ('status', SR_STATUS_LOGIN) \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'service_login')
	self.assertEquals(sbag.body['service_id'], 's001')
	self.assertEquals(sbag.body['listen_host'], 'local')
	self.assertEquals(sbag.body['listen_port'], 8000)
	self.assertEquals(sbag.body['status'], SR_STATUS_LOGIN)
	self.assertEquals(cbag.msgname, 'service_login_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['service']
	result = self.server.storage.result
	self.assertEquals(len(data), 1)
	self.assertEquals(data[0]['id'], 's002')
	self.assertEquals(data[0]['status'], 'D')
	self.assertNotEquals(result, SUCCESS)
	
    def testServiceLogout(self):
        self._dbInit({'service': [{'id': 's002', 'status': 'A'}, \
	                          {'id': 's001', 'status': 'A'} \
				 ]})
	packet = self.client.data_packed('service_logout', ('service_id', 's002'))
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'service_logout')
	self.assertEquals(sbag.body['service_id'], 's002')
	self.assertEquals(cbag.msgname, 'service_logout_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['service']
	result = self.server.storage.result
	self.assertEquals(len(data), 2)
	self.assertEquals(data[0]['id'], 's002')
	self.assertEquals(data[0]['status'], SR_STATUS_LOGOUT)
	self.assertEquals(data[1]['id'], 's001')
	self.assertEquals(data[1]['status'], 'A')
	self.assertEquals(result, SUCCESS)

    def testServiceWarningSuccess(self):
        self._dbInit({'service': [{'id': 's002', 'status': 'A'}, \
	                          {'id': 's003', 'status': 'A'} \
				 ]})
	packet = self.client.data_packed('service_warning', \
	                                 ('service_id', 's002'), \
					 ('warning_id', 's003'), \
					 ('level', 5) \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'service_warning')
	self.assertEquals(sbag.body['service_id'], 's002')
	self.assertEquals(sbag.body['warning_id'], 's003')
	self.assertEquals(sbag.body['level'], 5)
	self.assertEquals(cbag.msgname, 'service_warning_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['service']
	result = self.server.storage.result
	self.assertEquals(len(data), 2)
	self.assertEquals(data[0]['id'], 's002')
	self.assertEquals(data[0]['status'], 'A')
	self.assertEquals(data[1]['id'], 's003')
	self.assertEquals(data[1]['status'], SR_STATUS_INWARNING)
	self.assertEquals(result, SUCCESS)

    def testServiceWarningFail(self):
        self._dbInit({'service': [{'id': 's001', 'status': 'A'}, \
	                          {'id': 's003', 'status': 'A'} \
				 ]})
	packet = self.client.data_packed('service_warning', \
	                                 ('service_id', 's002'), \
					 ('warning_id', 's003'), \
					 ('level', 5) \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'service_warning')
	self.assertEquals(sbag.body['service_id'], 's002')
	self.assertEquals(sbag.body['warning_id'], 's003')
	self.assertEquals(sbag.body['level'], 5)
	self.assertEquals(cbag.msgname, 'service_warning_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['service']
	result = self.server.storage.result
	self.assertEquals(len(data), 2)
	self.assertEquals(data[0]['id'], 's001')
	self.assertEquals(data[0]['status'], 'A')
	self.assertEquals(data[1]['id'], 's003')
	self.assertEquals(data[1]['status'], 'A')
	self.assertNotEquals(result, SUCCESS)

    def testGetService(self):
        self._dbInit({'service': [{'id': 's001',  \
	                           'status': 'A', \
				   'listen_host': 'localhost', \
				   'listen_port': 8080, \
				   'domain': 1234, \
				   'tactics': 1343, \
				   'desc': 'desc for this', \
				   'host': 'riverfor', \
				   'port': 8000 \
				  }]})
	self._socketDone(self.client.data_packed('get_service', ('service_id' , 's001')))
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'get_service')
	self.assertEquals(sbag.body['service_id'], 's001')
	self.assertEquals(cbag.msgname, 'get_service_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['service']
	self.assertEquals(len(data), 1)
	self.assertEquals(data[0]['id'], 's001')
	self.assertEquals(data[0]['status'], 'A')
	self.assertEquals(data[0]['listen_host'], 'localhost')
	self.assertEquals(data[0]['listen_port'], 8080)
	result = cbag.getlist()
	self.assertEquals(result[0]['service_id'], 's001')
	self.assertEquals(result[0]['status'], 'A')
	self.assertEquals(result[0]['desc'], 'desc for this')
	self.assertEquals(result[0]['listen_host'], 'localhost')
	self.assertEquals(result[0]['listen_port'], 8080)
	self.assertEquals(result[0]['domain'], 1234)
	self.assertEquals(result[0]['tactics'], 1343)
	self.assertEquals(result[0]['host'], 'riverfor')
	self.assertEquals(result[0]['port'], 8000)

    # for agentclient only #
    def testSelectService(self):
        self._dbInit({'service': [{'id': 'red03', \
	                           'status': 'A', \
				   'listen_host': 'localhost', \
				   'listen_port': 8080, \
				   'domain': 1234, \
				   'tactics': 1343, \
				   'desc': 'desc for this', \
				   'host': 'riverfor', \
				   'port': 8000 \
				  }], \
		      'sgservice': [{'sgid': 'sg001', \
		                     'serviceid': 'red03', \
				     'level': 3, \
				     'weight': 5 \
				    }, \
				    {'sgid': 'sg003', \
				     'serviceid': 'red02', \
				     'level': 4, \
				     'weight': 5 \
				    }, \
				    {'sgid' : 'sg002', \
				     'serviceid': 'red03', \
				     'level': 4, \
				     'weight': 3 \
				    }]})
	self._socketDone(self.client.data_packed('select_service', ('service_id', 'red03')))
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'select_service')
	self.assertEquals(sbag.body['service_id'], 'red03')
	self.assertEquals(cbag.msgname, 'select_service_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	self.assertNotEquals(type(cbag.body['service_num']), str)
	## db's
	sgdata = cbag.getlist()
	self.assertEquals(len(sgdata), 2)
	self.assertEquals(sgdata[0]['service_id'], 'red03')
	self.assertEquals(sgdata[0]['servicegroup_id'], 'sg001')
	self.assertEquals(sgdata[0]['level'], 3)
	self.assertEquals(sgdata[0]['weight'], 5)
	self.assertEquals(sgdata[0]['host'], 'riverfor')
	self.assertEquals(sgdata[0]['port'], 8000)
	self.assertEquals(sgdata[1]['service_id'], 'red03')
	self.assertEquals(sgdata[1]['servicegroup_id'], 'sg002')
	self.assertEquals(sgdata[1]['level'], 4)
	self.assertEquals(sgdata[1]['weight'], 3)
	self.assertEquals(sgdata[1]['host'], 'riverfor')
	self.assertEquals(sgdata[1]['port'], 8000)

    def testModifyService1(self):
        self._dbInit({'service': [{'id': 'r009', \
	                           'desc': 'here desc', \
				   'password': 'passwd', \
				   'host': 'host1', \
				   'port': 9000, \
				   'domain': 81, \
				   'tactics': 98, \
				   'status': 'C' \
				   }]})
	packet = self.client.data_packed('modify_service', \
	                                 ('service_id', 'r009'), \
					 ('mask', 5), \
					 ('desc', 'desc for modify'), \
					 ('password', 'pass'), \
					 ('host', 'host'), \
					 ('port', 0x8989), \
					 ('domain', 0x00), \
					 ('tactics', 0x01), \
					 ('status', 'C') \
					) 
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'modify_service')
	self.assertEquals(sbag.body['service_id'], 'r009')
	self.assertEquals(sbag.body['mask'], 5)
	self.assertEquals(sbag.body['desc'], 'desc for modify')
	self.assertEquals(sbag.body['password'], 'pass')
	self.assertEquals(sbag.body['host'], 'host')
	self.assertEquals(sbag.body['port'], 0x8989)
	self.assertEquals(sbag.body['domain'], 0x00)
	self.assertEquals(sbag.body['tactics'], 0x01)
	self.assertEquals(sbag.body['status'], 'C')
	self.assertEquals(cbag.msgname, 'modify_service_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['service'][0]
	self.assertEquals(data['id'], 'r009')
	self.assertEquals(data['desc'], 'desc for modify')
	self.assertEquals(data['password'], 'passwd')
	self.assertEquals(data['host'], 'host')
	self.assertEquals(data['port'], 9000)
	self.assertEquals(data['domain'], 81)
	self.assertEquals(data['tactics'], 98)
	self.assertEquals(data['status'], 'C')
	
    def testModifyService2(self):
        self._dbInit({'service': [{'id': 'r009', \
	                           'desc': 'desc for modify1', \
				   'password': 'password1', \
				   'host': 'localhost', \
				   'port': 10000, \
				   'domain': 9877, \
				   'tactics': 1, \
				   'status': 'F' \
				  }]})
	packet = self.client.data_packed('modify_service', \
	                                 ('service_id', 'r009'), \
					 ('mask', 13), \
					 ('desc', 'desc for modify'), \
					 ('password', 'pass'), \
					 ('host', 'host'), \
					 ('port', 8989), \
					 ('domain', 0x00), \
					 ('tactics', 0x01), \
					 ('status', 'C') \
					) 
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'modify_service')
	self.assertEquals(sbag.body['service_id'], 'r009')
	self.assertEquals(sbag.body['mask'], 13)
	self.assertEquals(sbag.body['desc'], 'desc for modify')
	self.assertEquals(sbag.body['password'], 'pass')
	self.assertEquals(sbag.body['host'], 'host')
	self.assertEquals(sbag.body['port'], 8989)
	self.assertEquals(sbag.body['domain'], 0x00)
	self.assertEquals(sbag.body['tactics'], 0x01)
	self.assertEquals(sbag.body['status'], 'C')
	self.assertEquals(cbag.msgname, 'modify_service_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['service'][0]
	self.assertEquals(data['id'], 'r009')
	self.assertEquals(data['desc'], 'desc for modify')
	self.assertEquals(data['password'], 'password1')
	self.assertEquals(data['host'], 'host')
	self.assertEquals(data['port'], 8989)
	self.assertEquals(data['domain'], 9877)
	self.assertEquals(data['tactics'], 1)
	self.assertEquals(data['status'], 'F')
