#!/usr/bin/env python
# -*- coding: utf-8 -*-
# report bugs to: riverfor@sina.com.cn
"""
Test target module: compass.common.response.dispatcherdepend
"""

from compass.common.error import SUCCESS 
from compass.test.dispatcherserver.base import DispatcherServerTestCase

class AppendForResponseTestCase(DispatcherServerTestCase):
    """
    this part is response to the request of the append's operation
    """
    def testAddDependFail(self):
        self._dbInit({'depended': [{'sgid': 'fid001', 'dependedid': 'tid001'}], \
	              'servicegroup': [{'id': 'fid001'}, {'id': 'tid001'} \
		      ]})
        packet = self.client.data_packed('add_depend', \
	                                 ## sgid
	                                 ('from_id', 'fid001'), \
					 ## depended 
					 ('to_id', 'tid001') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'add_depend')
	self.assertEquals(sbag.body['from_id'], 'fid001')
	self.assertEquals(sbag.body['to_id'], 'tid001')
	self.assertEquals(cbag.msgname, 'add_depend_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## storage's
	gdata = self.server.storage.data['servicegroup']
	ddata = self.server.storage.data['depended']
	result = self.server.storage.result
	self.assertEquals(len(gdata), 2)
	self.assertEquals(len(ddata), 1)
	self.assertEquals(gdata[0]['id'], 'fid001')
	self.assertEquals(gdata[1]['id'], 'tid001')
	self.assertEquals(ddata[0]['sgid'], 'fid001')
	self.assertEquals(ddata[0]['dependedid'], 'tid001')
	self.assertNotEquals(result, SUCCESS)

    def testAddDependFailForDependEach(self):
        self._dbInit({'depended': [{'sgid': 'tid001', 'dependedid': 'fid001'}], \
	              'servicegroup': [{'id': 'fid001'}, {'id': 'tid001'} \
		      ]})
        packet = self.client.data_packed('add_depend', \
	                                 ## sgid
	                                 ('from_id', 'fid001'), \
					 ## depended 
					 ('to_id', 'tid001') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'add_depend')
	self.assertEquals(sbag.body['from_id'], 'fid001')
	self.assertEquals(sbag.body['to_id'], 'tid001')
	self.assertEquals(cbag.msgname, 'add_depend_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## storage's
	gdata = self.server.storage.data['servicegroup']
	ddata = self.server.storage.data['depended']
	result = self.server.storage.result
	self.assertEquals(len(gdata), 2)
	self.assertEquals(len(ddata), 1)
	self.assertEquals(gdata[0]['id'], 'fid001')
	self.assertEquals(gdata[1]['id'], 'tid001')
	self.assertEquals(ddata[0]['sgid'], 'tid001')
	self.assertEquals(ddata[0]['dependedid'], 'fid001')
	self.assertNotEquals(result, SUCCESS)

    def testAddDependSuccess(self):
        self._dbInit({'depended': [{'sgid': 'fid000', 'dependedid': 'tid001'}], \
	              'servicegroup': [{'id': 'fid001'}, {'id': 'tid001'} \
		      ]})
        packet = self.client.data_packed('add_depend', \
	                                 ## sgid
	                                 ('from_id', 'fid001'), \
					 ## depended 
					 ('to_id', 'tid001') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'add_depend')
	self.assertEquals(sbag.body['from_id'], 'fid001')
	self.assertEquals(sbag.body['to_id'], 'tid001')
	self.assertEquals(cbag.msgname, 'add_depend_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## storage's
	gdata = self.server.storage.data['servicegroup']
	ddata = self.server.storage.data['depended']
	result = self.server.storage.result
	self.assertEquals(len(gdata), 2)
	self.assertEquals(len(ddata), 2)
	self.assertEquals(gdata[0]['id'], 'fid001')
	self.assertEquals(gdata[1]['id'], 'tid001')
	self.assertEquals(ddata[0]['sgid'], 'fid000')
	self.assertEquals(ddata[0]['dependedid'], 'tid001')
	self.assertEquals(ddata[1]['sgid'], 'fid001')
	self.assertEquals(ddata[1]['dependedid'], 'tid001')
	self.assertEquals(result, SUCCESS)

    def testDelDepend(self):
        self._dbInit({'depended': [{'sgid': 'fid002', 'dependedid': 'tid002'}, \
	                           {'sgid': 'fid002', 'dependedid': 'tid001'}, \
				   {'sgid': 'fid001', 'dependedid': 'tid002'}\
				   ]})
        packet = self.client.data_packed('del_depend', \
	                                 ('from_id', 'fid002'), \
					 ('to_id', 'tid002') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'del_depend')
	self.assertEquals(sbag.body['from_id'], 'fid002')
	self.assertEquals(sbag.body['to_id'], 'tid002')
	self.assertEquals(cbag.msgname, 'del_depend_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## storages's
	data = self.server.storage.data['depended']
	self.assertEquals(len(data), 2)
	self.assertEquals(data[0]['sgid'], 'fid002')
	self.assertEquals(data[0]['dependedid'], 'tid001')
	self.assertEquals(data[1]['sgid'], 'fid001')
	self.assertEquals(data[1]['dependedid'], 'tid002')

    def testGetDepend(self):
        self._dbInit({'depended': [{'sgid': 'fi004', 'dependedid': 'tid004'}, \
	                           {'sgid': 'fi004', 'dependedid': 'tid003'}, \
				   {'sgid': 'fi003', 'dependedid': 'tid004'}, \
				   {'sgid': 'fi001', 'dependedid': 'tid001'}
				   ]})
        packet = self.client.data_packed('get_depend', \
	                                 ('from_id', 'fi004'), \
					 ('to_id', 'tid004') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'get_depend')
	self.assertEquals(sbag.body['from_id'], 'fi004')
	self.assertEquals(sbag.body['to_id'], 'tid004')
	self.assertEquals(cbag.msgname, 'get_depend_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## result's
	result = cbag.getlist()
	self.assertEquals(len(result), 3)
	self.assertEquals(result[0]['from_id'], 'fi004')
	self.assertEquals(result[0]['to_id'], 'tid004')
	self.assertEquals(result[1]['from_id'], 'fi004')
	self.assertEquals(result[1]['to_id'], 'tid003')
	self.assertEquals(result[2]['from_id'], 'fi003')
	self.assertEquals(result[2]['to_id'], 'tid004')
