#!/usr/bin/env python
# -*- coding: utf-8 -*-
# report bugs to: riverfor@sina.com.cn
"""
Test target module: compass.common.response.dispatcherapp
"""

from compass.common.error import SUCCESS
from compass.test.dispatcherserver.base import DispatcherServerTestCase

class ApplicationForResponseTestCase(DispatcherServerTestCase):
    """
    This part is the response to the request of the application's operation
    """
    def testAddApplicationFail(self):
        self._dbInit({'application': [{'id': 'app001', 'desc': 'desc for app001'}, \
	                              {'id': 'app002', 'desc': 'desc for app002'} \
				     ] \
		    })
	packet = self.client.data_packed('add_application', \
	                                 ('application_id', 'app001'), \
					 ('desc', 'desc for app') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'add_application')
	self.assertEquals(sbag.body['application_id'], 'app001')
	self.assertEquals(sbag.body['desc'], 'desc for app')
	self.assertEquals(cbag.msgname, 'add_application_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['application']
	result = self.server.storage.result
	self.assertEquals(len(data), 2)
	self.assertEquals(data[0]['id'], 'app001')
	self.assertEquals(data[0]['desc'], 'desc for app001')
	self.assertEquals(data[1]['id'], 'app002')
	self.assertEquals(data[1]['desc'], 'desc for app002')
	self.assertNotEquals(result, SUCCESS)

    def testAddApplicationSuccess(self):
        self._dbInit({'application': [{'id': 'app002', 'desc': 'desc for app002'}]})
	packet = self.client.data_packed('add_application', \
	                                 ('application_id', 'app001'), \
					 ('desc', 'desc for app') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'add_application')
	self.assertEquals(sbag.body['application_id'], 'app001')
	self.assertEquals(sbag.body['desc'], 'desc for app')
	self.assertEquals(cbag.msgname, 'add_application_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['application']
	result = self.server.storage.result
	self.assertEquals(len(data), 2)
	self.assertEquals(data[0]['id'], 'app002')
	self.assertEquals(data[0]['desc'], 'desc for app002')
	self.assertEquals(data[1]['id'], 'app001')
	self.assertEquals(data[1]['desc'], 'desc for app')
	self.assertEquals(result, SUCCESS)

    def testDelApplicationFail(self):
        self._dbInit({'application': [{'id': 'appdel00'}]})
        packet = self.client.data_packed('del_application', \
	                                ('application_id', 'appdel01') \
				       )
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'del_application')
	self.assertEquals(sbag.body['application_id'], 'appdel01')
	self.assertEquals(cbag.msgname, 'del_application_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['application']
	result = self.server.storage.result
	self.assertEquals(len(data), 1)
	self.assertEquals(data[0]['id'], 'appdel00')
	self.assertNotEquals(result, SUCCESS)

    def testDelApplicationSuccess(self):
        self._dbInit({'application': [{'id': 'appdel00'}, {'id': 'appdel01'}], \
	              'appsg': [{'appid': 'appdel01', 'sgid': 'sg001'}, \
		                {'appid': 'appdel00', 'sgid': 'sg001'} \
			       ]})
        packet = self.client.data_packed('del_application', \
	                                ('application_id', 'appdel01') \
				       )
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'del_application')
	self.assertEquals(sbag.body['application_id'], 'appdel01')
	self.assertEquals(cbag.msgname, 'del_application_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	adata = self.server.storage.data['application']
	agdata = self.server.storage.data['appsg']
	result = self.server.storage.result
	self.assertEquals(len(adata), 1)
	self.assertEquals(len(agdata), 1)
	self.assertEquals(adata[0]['id'], 'appdel00')
	self.assertEquals(result, SUCCESS)
	self.assertEquals(agdata[0]['appid'], 'appdel00')
	self.assertEquals(agdata[0]['sgid'], 'sg001')

    def testModifyApplication(self):
        self._dbInit({'application': [{'id': 'ap004', 'desc': 'no desc'}, \
	                              {'id': 'ap003', 'desc': 'desc for ap003'} \
				     ]})
        packet = self.client.data_packed('modify_application', \
	                                 ('application_id', 'ap004'), \
					 ('desc', 'desc for modify') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'modify_application')
	self.assertEquals(sbag.body['application_id'], 'ap004')
	self.assertEquals(sbag.body['desc'], 'desc for modify')
	self.assertEquals(cbag.msgname, 'modify_application_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['application']
	result = self.server.storage.result
	self.assertEquals(len(data), 2)
	self.assertEquals(data[0]['id'], 'ap004')
	self.assertEquals(data[0]['desc'], 'desc for modify')
	self.assertEquals(data[1]['id'], 'ap003')
	self.assertEquals(data[1]['desc'], 'desc for ap003')
	self.assertEquals(result, SUCCESS)

    def testGetApplication(self):
        self._dbInit({'application': [{'id': 'getap001', 'desc': 'desc for 001'}, \
	                              {'id': 'getap002', 'desc': 'desc for 002'} \
				      ]})
        packet = self.client.data_packed('get_application', \
	                                 ('application_id', 'getap001') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'get_application')
	self.assertEquals(sbag.body['application_id'], 'getap001')
	self.assertEquals(cbag.msgname, 'get_application_resp')
	self.assertEquals(cbag.body['application_num'], 1)
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	result = cbag.getlist()
	self.assertEquals(len(result), 1)
	self.assertEquals(result[0]['application_id'], 'getap001')
	self.assertEquals(result[0]['desc'], 'desc for 001')
