#!/usr/bin/env python
# -*- coding: utf-8 -*-
# report bugs to: riverfor@gmail.com

from compass.test.agentclient.base import AgentClientTestCase

class ServiceForRequest(AgentClientTestCase):
    """
    This part is the request to dispatcherserver with service operation
    """
    def testServiceLogin(self):
	self._csocketDone(self.client.service_login, 'test001', 'testhost', 8080, 'A')
	m = self.server.messages[0]
	self.assertEquals(m.msgname, 'service_login')
	self.assertEquals(m.head.length, 65)
	self.assertEquals(m.body['service_id'], 'test001')
	self.assertEquals(m.body['listen_host'], 'testhost')
	self.assertEquals(m.body['listen_port'], 8080)
	self.assertEquals(m.body['status'], 'A')

    def testServiceLoginResp(self):
	self._socketDone(self.server.data_packed('service_login_resp', ('status', 1)))
	packet = self.client.messages[0]
	self.assertEquals(packet.msgname, 'service_login_resp')
	self.assertEquals(packet.body['status'], 1)

    def testServiceLogout(self):
	self._csocketDone(self.client.service_logout, 'test001')
	m = self.server.messages[0]
	self.assertEquals(m.msgname, 'service_logout')
	self.assertEquals(m.head.length, 28)
	self.assertEquals(m.body['service_id'], 'test001')

    def testServiceLogoutResp(self):
	self._socketDone(self.server.data_packed('service_logout_resp', ('status', 1)))
	packet = self.client.messages[0]
	self.assertEquals(packet.msgname, 'service_logout_resp')
	self.assertEquals(packet.body['status'], 1)

    def testServiceWarning(self):
	self._csocketDone(self.client.service_warning, 'test001', 'test002', 3)
	m = self.server.messages[0]
	self.assertEquals(m.msgname, 'service_warning')
	self.assertEquals(m.body['service_id'], 'test001')
	self.assertEquals(m.body['warning_id'], 'test002')
	self.assertEquals(m.body['level'], 3)

    def testServiceWarningResp(self):
	self._socketDone(self.server.data_packed('service_warning_resp', ('status', 0)))
	packet = self.client.messages[0]
	self.assertEquals(packet.msgname, 'service_warning_resp')
	self.assertEquals(packet.body['status'], 0)

    def testGetService(self):
	self._csocketDone(self.client.get_service, 's002')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'get_service')
	self.assertEquals(bag.body['service_id'], 's002')

    def testGetServiceResp(self):
	packet = self.server.data_packed('get_service_resp',
	                                 ('status', 1),
				         ('service_num', 3),
				         ('list_num', 1),
				         [
					  {'service_id' : 'test001',
				           'desc' : 'no desc for this',
				           'host' : 'localhost',
				           'port' : 9090,
				           'listen_host' : 'localhost',
				           'listen_port' : 9091,
				           'domain' : 0x002,
				           'tactics' : 0x003,
				           'status' : 'a'
				          }
				         ])
	self._socketDone(packet)
	packet, packet_list = self.client.messages[0], self.client.messages[0].getlist()[0]
	self.assertEquals(packet.msgname, 'get_service_resp')
	self.assertEquals(packet.body['status'], 1)
	self.assertEquals(packet.body['service_num'], 3)
	self.assertEquals(packet.body['list_num'], 1)
	self.assertEquals(packet_list['service_id'], 'test001')
	self.assertEquals(packet_list['desc'], 'no desc for this')
	self.assertEquals(packet_list['host'], 'localhost')
	self.assertEquals(packet_list['port'], 9090)
	self.assertEquals(packet_list['listen_host'], 'localhost')
	self.assertEquals(packet_list['listen_port'], 9091)
	self.assertEquals(packet_list['domain'], 0x002)
	self.assertEquals(packet_list['tactics'], 0x003)
	self.assertEquals(packet_list['status'], 'a')
