#!/usr/bin/env python
# -*- coding: utf-8 -*-
# report bugs to: riverfor@sina.com.cn
"""
Test target module: compass.common.response.adminservice
"""

from compass.test.adminclient.base import AdminClientTestCase

class ServiceForRequestTestCase(AdminClientTestCase):
    """
    This part is the request to dispatcherserver for service operation
    """
    def testServiceLogin(self):
        # self's function definition
	self._csocketDone(self.client.service_login, 'test001', 'testhost', 8080, 'A')
	m = self.server.messages[0]
	self.assertEquals(m.msgname, 'service_login')
	self.assertEquals(m.head.length, 65)
	self.assertEquals(m.body['service_id'], 'test001')
	self.assertEquals(m.body['listen_host'], 'testhost')
	self.assertEquals(m.body['listen_port'], 8080)
	self.assertEquals(m.body['status'], 'A')

    def testServiceLoginResp(self):
        self._socketDone(self.server.data_packed('service_login_resp', ('status', 1)))
	packet = self.client.messages[0]
	self.assertEquals(packet.msgname, 'service_login_resp')
	self.assertEquals(packet.body['status'], 1)

    def testServiceLogout(self):
        self._csocketDone(self.client.service_logout, 'test001')
	m = self.server.messages[0]
	self.assertEquals(m.msgname, 'service_logout')
	self.assertEquals(m.head.length, 28)
	self.assertEquals(m.body['service_id'], 'test001')

    def testServiceLogoutResp(self):
        self._socketDone(self.server.data_packed('service_logout_resp', ('status', 1)))
	packet = self.client.messages[0]
	self.assertEquals(packet.msgname, 'service_logout_resp')
	self.assertEquals(packet.body['status'], 1)

    def testServiceWarning(self):
        self._csocketDone(self.client.service_warning, 'test001', 'test002', 3)
	m = self.server.messages[0]
	self.assertEquals(m.msgname, 'service_warning')
	self.assertEquals(m.body['service_id'], 'test001')
	self.assertEquals(m.body['warning_id'], 'test002')
	self.assertEquals(m.body['level'], 3)

    def testServicewarningresp(self):
        # mock a server's response to the client's warning request
	self._socketDone(self.server.data_packed('service_warning_resp', ('status', 0)))
	packet = self.client.messages[0]
	self.assertEquals(packet.msgname, 'service_warning_resp')
	self.assertEquals(packet.body['status'], 0)

    def testGetService(self):
        # send a get request
	self._csocketDone(self.client.get_service, 's002')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'get_service')
	self.assertEquals(bag.body['service_id'], 's002')

    def testGetServiceResp(self):
        # mock a server's response to the request of get_service
	packet = self.server.data_packed('get_service_resp',
	                                 ('status', 1),
				         ('service_num', 3),
				         ('list_num', 1),
				         [{'service_id' : 'test001',
				           'desc' : 'no desc for this',
				           'host' : 'localhost',
				           'port' : 9090,
				           'listen_host' : 'localhost',
				           'listen_port' : 9091,
				           'domain' : 0x002,
				           'tactics' : 0x003,
				           'status' : 'a'
				          }
				         ])
	self._socketDone(packet)
	packet, packet_list = self.client.messages[0], self.client.messages[0].getlist()[0]
	self.assertEquals(packet.msgname, 'get_service_resp')
	self.assertEquals(packet.body['status'], 1)
	self.assertEquals(packet.body['service_num'], 3)
	self.assertEquals(packet.body['list_num'], 1)
	self.assertEquals(packet_list['service_id'], 'test001')
	self.assertEquals(packet_list['desc'], 'no desc for this')
	self.assertEquals(packet_list['host'], 'localhost')
	self.assertEquals(packet_list['port'], 9090)
	self.assertEquals(packet_list['listen_host'], 'localhost')
	self.assertEquals(packet_list['listen_port'], 9091)
	self.assertEquals(packet_list['domain'], 0x002)
	self.assertEquals(packet_list['tactics'], 0x003)
	self.assertEquals(packet_list['status'], 'a')

    def testAddService(self):
	"""undocumented
	"""
	service_data = {'service_id': 'serid001', 'desc': 'nodesc', 'password': 'password', \
	    'host': 'host003', 'port': 8080, 'domain': 0x003, 'tactics': 0x005, 'status': 'C'}
	self._csocketDone(self.client.add_service, service_data)
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'add_service')
	self.assertEquals(bag.body['service_id'], 'serid001')
	self.assertEquals(bag.body['desc'], 'nodesc')
	self.assertEquals(bag.body['password'], 'password')
	self.assertEquals(bag.body['host'], 'host003')
	self.assertEquals(bag.body['port'], 8080)
	self.assertEquals(bag.body['domain'], 0x003)
	self.assertEquals(bag.body['tactics'], 0x005)
	self.assertEquals(bag.body['status'], 'C')
	# check the assigned cmd
	self.assertEquals(self.client.next_cmd, self.client.disconnect)
	self.assertEquals(self.client.next_args, ())

    def testAddServiceResp(self):
        # mock a server's response to the add_service's request
	self._socketDone(self.server.data_packed('add_service_resp', ('status', 0)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'add_service_resp')
	self.assertEquals(bag.body['status'], 0)

    def testDelService(self):
	self._csocketDone(self.client.del_service, 'delservice003')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'del_service')
	self.assertEquals(bag.body['service_id'], 'delservice003')

    def testDelServiceResp(self):
	self._socketDone(self.server.data_packed('del_service_resp', ('status', 1)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'del_service_resp')
	self.assertEquals(bag.body['status'], 1)

    def testModifyService(self):
	service_data = {'service_id': 's003', 'desc': 'nodesc', 'password': 'password', \
	    'host': 'localhost', 'port': 8088, 'domain': 0x00, 'tactics': 0x01, 'status': 'C'}
	self._csocketDone(self.client.modify_service, 1, service_data)
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'modify_service')
	self.assertEquals(bag.body['service_id'], 's003')
	self.assertEquals(bag.body['mask'], 1)
	self.assertEquals(bag.body['desc'], 'nodesc')
	self.assertEquals(bag.body['host'], 'localhost')
	self.assertEquals(bag.body['port'], 8088)
	self.assertEquals(bag.body['domain'], 0x00)
	self.assertEquals(bag.body['tactics'], 0x01) 
	self.assertEquals(bag.body['status'], 'C')

    def testModifyServiceResp(self):
	self._socketDone(self.server.data_packed('modify_service_resp', ('status', 1)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'modify_service_resp')
	self.assertEquals(bag.body['status'], 1)

    def testServiceNotify(self):
	self._csocketDone(self.client.service_notify, 'ser003', 8, 0x003, 'C')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'service_notify')
	self.assertEquals(bag.body['service_id'], 'ser003')
	self.assertEquals(bag.body['level'], 8)
	self.assertEquals(bag.body['weight'], 0x003)
	self.assertEquals(bag.body['status'], 'C')

    def testServiceNotifyResp(self):
	self._socketDone(self.server.data_packed('service_notify_resp', ('status', 0x004)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'service_notify_resp')
	self.assertEquals(bag.body['status'], 0x004)

    #### service group
    def testAddServiceGroup(self):
	self._csocketDone(self.client.add_servicegroup, 'test004sg', 'desc for add')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'add_servicegroup')
	self.assertEquals(bag.body['servicegroup_id'], 'test004sg')
	self.assertEquals(bag.body['desc'], 'desc for add')

    def testAddServiceGroupResp(self):
	self._socketDone(self.server.data_packed('add_servicegroup_resp', ('status', 0x04)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'add_servicegroup_resp')
	self.assertEquals(bag.body['status'], 0x04)

    def testModifyServiceGroup(self):
	self._csocketDone(self.client.modify_servicegroup, 'test004', 'changed desc')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'modify_servicegroup')
	self.assertEquals(bag.body['servicegroup_id'], 'test004')
	self.assertEquals(bag.body['desc'], 'changed desc')

    def testModifyServiceGroupResp(self):
	self._socketDone(self.server.data_packed('modify_servicegroup_resp', ('status', 0x05)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'modify_servicegroup_resp')
	self.assertEquals(bag.body['status'], 0x05)

    def testDelServiceGroup(self):
	self._csocketDone(self.client.del_servicegroup, 'test005app')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'del_servicegroup')
	self.assertEquals(bag.body['servicegroup_id'], 'test005app')

    def testDelServiceGroupResp(self):
	self._socketDone(self.server.data_packed('del_servicegroup_resp', ('status', 0x05)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'del_servicegroup_resp')
	self.assertEquals(bag.body['status'], 0x05)

    def testGetServiceGroup(self):
	self._csocketDone(self.client.get_servicegroup, 'sgid01')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'get_servicegroup')
	self.assertEquals(bag.body['servicegroup_id'], 'sgid01')

    def testGetServiceGroupResp(self):
	packet = self.server.data_packed('get_servicegroup_resp',
	                                 ('status', 0x001),
					 ('servicegroup_num', 5),
					 [{'servicegroup_id': 't001sg', 'desc': 'desc1'}, {'servicegroup_id': 't002sg', 'desc': 'desc2'}]
					)
        self._socketDone(packet)
	bag, ibag = self.client.messages[0], self.client.messages[0].getlist()
	self.assertEquals(bag.msgname, 'get_servicegroup_resp')
	self.assertEquals(bag.body['status'], 1)
	self.assertEquals(bag.body['list_num'], 2)
	self.assertEquals(ibag[0]['servicegroup_id'], 't001sg')
	self.assertEquals(ibag[0]['desc'], 'desc1')
	self.assertEquals(ibag[1]['servicegroup_id'], 't002sg')
	self.assertEquals(ibag[1]['desc'], 'desc2')

    #### service 2 group
    def testAddService2Group(self):
	self._csocketDone(self.client.add_service2group, 'sg003', 's003', 0x003, 0x004)
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'add_service2group')
	self.assertEquals(bag.body['servicegroup_id'], 'sg003')
	self.assertEquals(bag.body['service_id'], 's003')
	self.assertEquals(bag.body['level'], 0x003)
	self.assertEquals(bag.body['weight'], 0x004)

    def testAddService2GroupResp(self):
	self._socketDone(self.server.data_packed('add_service2group_resp', ('status', 0x01)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'add_service2group_resp')
	self.assertEquals(bag.body['status'], 0x01)

    def testDelService2group(self):
	self._csocketDone(self.client.del_service2group, 'sg002', 's003')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'del_service2group')
	self.assertEquals(bag.body['servicegroup_id'], 'sg002')
	self.assertEquals(bag.body['service_id'], 's003') 

    def testDelService2GroupResp(self):
	self._socketDone(self.server.data_packed('del_service2group_resp', ('status', 0x04)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'del_service2group_resp')
	self.assertEquals(bag.body['status'], 0x04)

    def testGetService2Group(self):
	self._csocketDone(self.client.get_service2group, 'sg0043')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'get_service2group')
	self.assertEquals(bag.body['servicegroup_id'], 'sg0043')

    def testGetService2GroupResp(self):
	packet = self.server.data_packed('get_service2group_resp',
	                                 ('status', 0x01),
					 ('service_num', 0x11),
					 [{'service_id': 's001',
					   'host': 'host01',
					   'port': 9000,
					   'listen_host': 'lhost01',
					   'listen_port': 9001,
					   'level': 0x01,
					   'weight': 0x10,
					   'domain': 0x11,
					   'tactics': 0x02,
					   'status': 'A'
					   },
					   {'service_id': 's002',
					    'host': 'host02',
					    'port': 9000,
					    'listen_host': 'lhost02',
					    'listen_port': 9002,
					    'level': 0x02,
					    'weight': 0x20,
					    'domain': 0x21,
					    'tactics': 0x02,
					    'status': 'C'
					    }])
        self._socketDone(packet)
	bag, ibag = self.client.messages[0], self.client.messages[0].getlist()
	self.assertEquals(bag.msgname, 'get_service2group_resp')
	self.assertEquals(bag.body['service_num'], 0x11)
	self.assertEquals(bag.body['status'], 1)
	self.assertEquals(bag.body['list_num'], 2)
	self.assertEquals(len(ibag[0]), 10)
	self.assertEquals(len(ibag[1]), 10)
	self.assertEquals(ibag[0]['service_id'], 's001')
	self.assertEquals(ibag[0]['host'], 'host01')
	self.assertEquals(ibag[0]['port'], 9000)
	self.assertEquals(ibag[0]['listen_host'], 'lhost01')
	self.assertEquals(ibag[0]['listen_port'], 9001)
	self.assertEquals(ibag[0]['level'], 1)
	self.assertEquals(ibag[0]['weight'], 0x10)
	self.assertEquals(ibag[0]['domain'], 0x11)
	self.assertEquals(ibag[0]['tactics'], 0x02)
	self.assertEquals(ibag[0]['status'], 'A')
	self.assertEquals(ibag[1]['service_id'], 's002')
	self.assertEquals(ibag[1]['host'], 'host02')
	self.assertEquals(ibag[1]['port'], 9000)
	self.assertEquals(ibag[1]['listen_host'], 'lhost02')
	self.assertEquals(ibag[1]['listen_port'], 9002)
	self.assertEquals(ibag[1]['level'], 2)
	self.assertEquals(ibag[1]['weight'], 0x20)
	self.assertEquals(ibag[1]['domain'], 0x21)
	self.assertEquals(ibag[1]['tactics'], 0x02)
	self.assertEquals(ibag[1]['status'], 'C')

    #### service of group
    def testGetServiceOfGroup(self):
	self._csocketDone(self.client.get_serviceofgroup, 'sid001')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'get_serviceofgroup')
	self.assertEquals(bag.body['service_id'], 'sid001')

    def testGetServiceOfGroupResp(self):
	packet = self.server.data_packed('get_serviceofgroup_resp',
	                                 ('status', 0x01),
					 [{'servicegroup_id': 'sg001', 'desc': 'desc001'}, {'servicegroup_id': 'sg002', 'desc': 'desc002'}])
	self._socketDone(packet)
	bag, ibag = self.client.messages[0], self.client.messages[0].getlist()
	self.assertEquals(bag.msgname, 'get_serviceofgroup_resp')
	self.assertEquals(bag.body['status'], 1)
	self.assertEquals(bag.body['servicegroup_num'], 2)
	self.assertEquals(len(ibag[0]), 2)
	self.assertEquals(len(ibag[1]), 2)
	self.assertEquals(ibag[0]['servicegroup_id'], 'sg001')
	self.assertEquals(ibag[0]['desc'], 'desc001')
	self.assertEquals(ibag[1]['servicegroup_id'], 'sg002')
	self.assertEquals(ibag[1]['desc'], 'desc002')

    #### this part is about application
    def testAddApplication(self):
	self._csocketDone(self.client.add_application, 'appid003', 'such app')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'add_application')
	self.assertEquals(bag.body['application_id'], 'appid003')
	self.assertEquals(bag.body['desc'], 'such app')

    def testApplcationResp(self):
	self._socketDone(self.server.data_packed('add_application_resp', ('status', 0x045)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'add_application_resp')
	self.assertEquals(bag.body['status'], 0x045)

    def testDelApplication(self):
	self._csocketDone(self.client.del_application, 'app123')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'del_application')
	self.assertEquals(bag.body['application_id'], 'app123')

    def testDelApplicationResp(self):
	self._socketDone(self.server.data_packed('del_application_resp', ('status', 0x04)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'del_application_resp')
	self.assertEquals(bag.body['status'], 0x04)

    def testModifyApplication(self):
	self._csocketDone(self.client.modify_application, 'app123', 'modify desc')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'modify_application')
	self.assertEquals(bag.body['application_id'], 'app123')
	self.assertEquals(bag.body['desc'], 'modify desc')

    def testModifyApplicationResp(self):
	self._socketDone(self.server.data_packed('modify_application_resp', ('status', 0x03)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'modify_application_resp')
	self.assertEquals(bag.body['status'], 0x03)

    def testGetApplication(self):
	self._csocketDone(self.client.get_application, 'test00456')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'get_application')
	self.assertEquals(bag.body['application_id'], 'test00456')

    def testGetApplicationResp(self):
        packet = self.server.data_packed('get_application_resp', ('status', 9), [{'application_id' : 'test003', 'desc' : 'for test'}, {'application_id' : 'test004', 'desc' : 'for test2'}])

	self._socketDone(packet)
	bag, ibag = self.client.messages[0], self.client.messages[0].getlist()
	self.assertEquals(bag.msgname, 'get_application_resp')
	self.assertEquals(bag.body['status'], 9)
	self.assertEquals(bag.body['application_num'], 2)
	self.assertEquals(ibag[0]['application_id'], 'test003')
	self.assertEquals(ibag[0]['desc'], 'for test')
	self.assertEquals(ibag[1]['application_id'], 'test004')
	self.assertEquals(ibag[1]['desc'], 'for test2')

    #### group2app
    def testAddGroup2App(self):
	self._csocketDone(self.client.add_group2app, 'app001', 'sgroup001')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'add_group2app')
	self.assertEquals(bag.body['application_id'], 'app001')
	self.assertEquals(bag.body['servicegroup_id'], 'sgroup001')

    def testAddGroup2AppResp(self):
	self._socketDone(self.server.data_packed('add_group2app_resp', ('status', 0x045)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'add_group2app_resp')
	self.assertEquals(bag.body['status'], 0x045)

    def testDelGroup2App(self):
	self._csocketDone(self.client.del_group2app, 'testapp001', 'testgroup002')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'del_group2app')
	self.assertEquals(bag.body['application_id'], 'testapp001')
	self.assertEquals(bag.body['servicegroup_id'], 'testgroup002')

    def testDelGroup2AppResp(self):
	self._socketDone(self.server.data_packed('del_group2app_resp', ('status', 0x34)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'del_group2app_resp')
	self.assertEquals(bag.body['status'], 0x34)

    def testGetGroup2App(self):
	self._csocketDone(self.client.get_group2app, 'app005')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'get_group2app')
	self.assertEquals(bag.body['application_id'], 'app005')

    def testGetGroup2AppResp(self):
	packet = self.server.data_packed('get_group2app_resp',
	                                 ('status', 1),
					 [{'servicegroup_id': 'test005app', 'desc': ''}, 
					  {'servicegroup_id': 'test006app', 'desc': 'no desc for'}
					 ]
					 )
	self._socketDone(packet)
	bag, ibag = self.client.messages[0], self.client.messages[0].getlist()
	self.assertEquals(bag.msgname, 'get_group2app_resp')
	self.assertEquals(bag.body['status'], 1)
	self.assertEquals(bag.body['servicegroup_num'], 2)
	self.assertEquals(ibag[0]['servicegroup_id'], 'test005app')
	self.assertEquals(ibag[0]['desc'], '')
	self.assertEquals(ibag[1]['servicegroup_id'], 'test006app')
	self.assertEquals(ibag[1]['desc'], 'no desc for')

    ### group of app
    def testGetGroupOfApp(self):
	self._csocketDone(self.client.get_groupofapp, 'sgid_0023')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'get_groupofapp')
	self.assertEquals(bag.body['servicegroup_id'], 'sgid_0023')

    def	testGetGroupOfAppResp(self):
	packet = self.server.data_packed('get_groupofapp_resp',
	                                 ('status', 0x02),
					 [{'application_id': 'app01', 'desc': 'desc01'},
					  {'application_id': 'app02', 'desc': 'desc02'}])
	self._socketDone(packet)
	bag, ibag = self.client.messages[0], self.client.messages[0].getlist()
	self.assertEquals(bag.msgname, 'get_groupofapp_resp')
	self.assertEquals(bag.body['status'], 0x02)
	self.assertEquals(ibag[0]['application_id'], 'app01')
	self.assertEquals(ibag[0]['desc'], 'desc01')
	self.assertEquals(ibag[1]['application_id'], 'app02')
	self.assertEquals(ibag[1]['desc'], 'desc02')

    #### depend relevance	
    def testAddDepend(self):
	self._csocketDone(self.client.add_depend, 'sg001', 'sg002')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'add_depend')
	self.assertEquals(bag.body['from_id'], 'sg001')
	self.assertEquals(bag.body['to_id'], 'sg002')

    def testAddDependResp(self):
	self._socketDone(self.server.data_packed('add_depend_resp', ('status', 10)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'add_depend_resp')
	self.assertEquals(bag.body['status'], 10)

    def testDelDepend(self):
	self._csocketDone(self.client.del_depend, 'sg001', 'sg002')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'del_depend')
	self.assertEquals(bag.body['from_id'], 'sg001')
	self.assertEquals(bag.body['to_id'], 'sg002')

    def testDelDependResp(self):
	self._socketDone(self.server.data_packed('del_depend_resp', ('status', 0x03)))
	bag = self.client.messages[0]
	self.assertEquals(bag.msgname, 'del_depend_resp')
	self.assertEquals(bag.body['status'], 0x03)

    def testGetDepend(self):
	self._csocketDone(self.client.get_depend, 'sgfr01', 'sgto02')
	bag = self.server.messages[0]
	self.assertEquals(bag.msgname, 'get_depend')
	self.assertEquals(bag.body['from_id'], 'sgfr01')
	self.assertEquals(bag.body['to_id'], 'sgto02')

    def testGetDependResp(self):
	packet = self.server.data_packed('get_depend_resp',
	                                 ('status', 1),
					 [{'from_id': 'f001', 'to_id': 'to001'}, {'from_id': 'f002', 'to_id': 'to002'}])
	self._socketDone(packet)
	bag, ibag = self.client.messages[0], self.client.messages[0].getlist()
	self.assertEquals(bag.msgname, 'get_depend_resp')
	self.assertEquals(bag.body['depend_num'], 2)
	self.assertEquals(ibag[0]['from_id'], 'f001')
	self.assertEquals(ibag[0]['to_id'], 'to001')
	self.assertEquals(ibag[1]['from_id'], 'f002')
	self.assertEquals(ibag[1]['to_id'], 'to002')
