#!/usr/bin/env python
# -*- coding: utf-8 -*-
# report bugs to: riverfor@sina.com.cn
"""
offer the sqlite io suport
"""

from compass.common.config import DB_FILE
from compass.common.error import SUCCESS, ERR_ARGS
from compass.storage import storage
import sqlite

class Storage(storage.Storage):

    def opendb(self):
        """
	"""
        self.db_conn = sqlite.connect(DB_FILE)
	self.cursor = self.db_conn.cursor()

    def close(self):
        self.cursor.close()
	self.db_conn.close()

    def lookup(self, zone, conditions):
        """
	"""
        st = len(conditions) <> 0 and "SELECT * FROM %s WHERE " % zone or "SELECT * FROM %s" % zone
	st += self._gen_st(conditions)
	self.cursor.execute(st)
	result = self.cursor.fetchall()
	return len(result) <> 0 and result or None

    def delete(self, zone, conditions):
        """
	"""
        st = len(conditions) <> 0 and "DELETE FROM %s WHERE " % zone or "DELETE FROM %s" % zone
	st += self._gen_st(conditions)
	self.cursor.execute(st)
	self.db_conn.commit()
	return SUCCESS

    def add(self, zone, key2value):
        """
	"""
	values = self._gen_it(zone, key2value)
	if values == ERR_ARGS:
	    return ERR_ARGS
	st = "INSERT INTO %s VALUES(%s)" % (zone, values)
	self.cursor.execute(st)
	self.db_conn.commit()
	return SUCCESS
	
    def update(self, zone, conditions, key2value):
        """
	"""
	st = "UPDATE %s SET %s WHERE %s" % (zone, self._gen_ut(key2value), self._gen_st(conditions))
	self.cursor.execute(st)
	self.db_conn.commit()
	return SUCCESS

    def _gen_st(self, conditions):
        """
	generate the sql statement
	"""
	st = ""
	keys = conditions.keys()
	for item in keys:
	    st += "%s = \"%s\" AND " % (item, conditions[item])
	return st[:-5] 

    def _gen_ut(self, key2value):
        """
	generate the sql statement
	"""
	st = ""
	keys = key2value.keys()
	for item in keys:
	    st += "%s = \"%s\", " % (item, key2value[item])
	return st[:-2] 
	
    def _gen_it(self, zone, key2value):	
	if zone == "application" or zone == "servicegroup":
	    values = "\"%s\", \"%s\"" % (key2value["id"], key2value["desc"])
	elif zone == "service":
	    values = "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\"" % (key2value["id"], key2value["desc"], key2value["password"], key2value["host"], key2value["port"], "", "", key2value["domain"], key2value["tactics"], key2value["status"])
	elif zone == "appsg":
	    values = "\"%s\", \"%s\"" % (key2value["appid"], key2value["sgid"])
	elif zone == "sgservice":
	    values = "\"%s\", \"%s\", \"%s\", \"%s\"" % (key2value["sgid"], key2value["serviceid"], key2value["level"], key2value["weight"])
	else:
	    values = ERR_ARGS
	return values    
