#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: -*-
# report bug to: riverfor@gmail.com
"""
This module includes the data packed class
"""

## compass's packages
from compass.messages.gnspmsg import GNSPMessage
from compass.protocols.cmdmap import CmdMap
from compass.common.config import *

class DataPacked(CmdMap):
    __doc__ = "inherit CmdMap for less code"

    def loadConfig(self):
	"""undocumented
	"""
        self.config['version'] = VERSION
        self.config['service_id'] = SERVICE_ID
        self.config['password'] = PASSWORD
        self.config['host'] = HOST
        self.config['port'] = PORT
        self.config['listen_host'] = LISTEN_HOST
        self.config['listen_port'] = LISTEN_PORT
        self.config['domain'] = DOMAIN
        self.config['tactics'] = TACTICS
        self.config['status'] = STATUS

    def data_packed(self, packet_name, *body_item):
	"""undocumented
	"""
        packet = GNSPMessage()
        packet.setMsgName(packet_name)
	for i in range(len(body_item)):
	    body_type = type(body_item[i])
	    # get the key by assigned
	    if body_type == tuple:
	        packet.body.setField(body_item[i][0], body_item[i][1])
	    elif body_type == list:
	        packet.addlist(body_item[i])
	    elif body_type == dict:
	        for dict_item in body_item[i].keys():
		    packet.body.setField(dict_item, body_item[i][dict_item])
	    else:
	    # set the key by default vallue
	        packet.body.setField(body_item[i], self.config[body_item[i]])
        return packet.packed()

    def common_out(self, *args):
        """
	This function was used to send common data
	"""
	return self.sendData(apply(self.data_packed, args))
        
    def simple_out(self, msg_name, status):	
        """
	This function was used to send data without list
	"""
        return self.sendData(self.data_packed(msg_name, ('status', status)))

    def out_with_list(self, msg_name, status, list_num_name, data):
        """
	This function was used to send data with list
	"""
	packet = self.data_packed(msg_name, \
	                          ('status', status), \
				  (list_num_name, len(data)), \
				  data \
				 ) 
	return self.sendData(packet)			 
