#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.test_gnspmsg -*-
# report bug to: riverfor@gmail.com
"""
Open Unified Storage System Protocol
Stability: None
@author: U{HD<mailto:hdcola@gmail.com>}
@see: Open Unified Storage System Protocol norm
"""

## framework's packages
import struct
import zlib
import cPickle
## comapss's packages
from compass.messages import bytemsg
##
pickle = cPickle

### class GNSPMessage
class GNSPMessage(bytemsg.ByteMessage):
    # transe code between pack and unpack
    transe_code = {'connect' 			: '16s40sI22s',
                   'connect_resp' 		: 'II',
		   'add_application' 		: '16s64s',
		   'add_application_resp' 	: 'I',
		   'del_application' 		: '16s',
		   'del_application_resp' 	: 'I',
		   'modify_application' 	: '16s64s',
		   'modify_application_resp' 	: 'I',
		   'get_application' 		: '16s',
		   'get_application_resp' 	: '16s64s',
		   'add_servicegroup' 		: '16s64s',
		   'add_servicegroup_resp' 	: 'I',
		   'modify_servicegroup' 	: '16s64s',
		   'modify_servicegroup_resp' 	: 'I',
		   'del_servicegroup' 		: '16s',
		   'del_servicegroup_resp' 	: 'I',
		   'get_servicegroup' 		: '16s',
		   'get_servicegroup_resp' 	: '16s64s',
		   'add_service' 		: '16s64s18s32sIII1s',
		   'add_service_resp' 		: 'I',
		   'modify_service' 		: '16sI64s18s32sIII1s',
		   'modify_service_resp' 	: 'I',
		   'del_service' 		: '16s',
		   'del_service_resp' 		: 'I',
		   'get_service' 		: '16s',
		   'get_service_resp' 		: '16s64s32sI32sIII1s',
		   'add_depend' 		: '16s16s',
		   'add_depend_resp' 		: 'I',
		   'del_depend' 		: '16s16s',
		   'del_depend_resp' 		: 'I',
		   'get_depend' 		: '16s16s',
		   'get_depend_resp' 		: '16s16s',
		   'service_login'		: '16s32sI1s',
		   'service_login_resp' 	: 'I',
		   'service_logout' 		: '16s',
		   'service_logout_resp' 	: 'I',
		   'select_service' 		: '16s',
		   'select_service_resp' 	: '16s16s32sIII',
		   'service_warning' 		: '16s16sI',
		   'service_warning_resp' 	: 'I',
		   'service_notify' 		: '16sII1s',
		   'service_notify_resp' 	: 'I',
		   'add_group2app' 		: '16s16s',
		   'add_group2app_resp' 	: 'I',
		   'del_group2app' 		: '16s16s',
		   'del_group2app_resp' 	: 'I',
		   'get_group2app' 		: '16s',
		   'get_group2app_resp' 	: '16s64s',
		   'get_groupofapp' 		: '16s',
		   'get_groupofapp_resp' 	: '16s64s',
		   'add_service2group' 		: '16s16sII',
		   'add_service2group_resp' 	: 'I',
		   'del_service2group' 		: '16s16s',
		   'del_service2group_resp' 	: 'I',
		   'modify_service2group' 	: '16s16sII',
		   'modify_service2group_resp' 	: 'I',
		   'get_service2group' 		: '16s',
		   'get_service2group_resp' 	: '16s32sI32sIIIII1s',
		   'get_serviceofgroup' 	: '16s',
		   'get_serviceofgroup_resp' 	: '16s64s',
		   }
    def __init__(self):
        bytemsg.ByteMessage.__init__(self)
        self.head = bytemsg.ByteMessageHead(self)
        self.body = bytemsg.ByteMessageBody(self)
        self.msgutilcls = GNSPMessageUtil
        self.protocolname = 'gnsp'
        self.msgname = ''
        self._list = []

    def pack_gnsp_connect(self, fields):
        message = struct.pack(self.transe_code['connect'],
                              fields['service_id'],
                              fields['auth_source'],
                              fields['version'],
                              fields['time_stamp'])
        return message

    def unpack_gnsp_connect(self, packet):
        len = struct.calcsize(self.transe_code['connect'])
        self.body.fields['service_id'], \
            self.body.fields['auth_source'], \
            self.body.fields['version'], \
            self.body.fields['time_stamp'] = \
            struct.unpack(self.transe_code['connect'], packet[:len])

    def pack_gnsp_connect_resp(self, fields):
        message = struct.pack(self.transe_code['connect_resp'],
                              fields['status'],
                              fields['version'])
        return message

    def unpack_gnsp_connect_resp(self, packet):
        len = struct.calcsize(self.transe_code['connect_resp'])
        self.body.fields['status'], \
            self.body.fields['version'] = \
            struct.unpack(self.transe_code['connect_resp'], packet[:len])

    def pack_gnsp_disconnect(self, fields):
        return None

    def unpack_gnsp_disconnect(self, packet):
        pass

    def pack_gnsp_disconnect_resp(self, fields):
        return None

    def unpack_gnsp_disconnect_resp(self, packet):
        pass

    def pack_gnsp_add_application(self, fields):
        message = struct.pack(self.transe_code['add_application'],
                              fields['application_id'],
                              fields['desc'])
        return message

    def unpack_gnsp_add_application(self, packet):
        len = struct.calcsize(self.transe_code['add_application'])
        self.body.fields['application_id'], \
            self.body.fields['desc'] = \
            struct.unpack(self.transe_code['add_application'], packet[:len])

    def pack_gnsp_add_application_resp(self, fields):
        message = struct.pack(self.transe_code['add_application_resp'],
                fields['status'])
        return message

    def unpack_gnsp_add_application_resp(self, packet):
        len = struct.calcsize(self.transe_code['add_application_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['add_application_resp'], packet[:len])

    def pack_gnsp_del_application(self, fields):
        message = struct.pack(self.transe_code['del_application'],
                fields['application_id'])
        return message

    def unpack_gnsp_del_application(self, packet):
        len = struct.calcsize(self.transe_code['del_application'])
        (self.body.fields['application_id'],) = \
            struct.unpack(self.transe_code['del_application'], packet[:len])

    def pack_gnsp_del_application_resp(self, fields):
        message = struct.pack(self.transe_code['del_application_resp'],
                fields['status'])
        return message

    def unpack_gnsp_del_application_resp(self, packet):
        len = struct.calcsize(self.transe_code['del_application_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['del_application_resp'], packet[:len])

    def pack_gnsp_modify_application(self, fields):
        message = struct.pack(self.transe_code['modify_application'],
                fields['application_id'], \
                fields['desc'])
        return message

    def unpack_gnsp_modify_application(self, packet):
        len = struct.calcsize(self.transe_code['modify_application'])
        self.body.fields['application_id'], \
            self.body.fields['desc'] = \
            struct.unpack(self.transe_code['modify_application'], packet[:len])

    def pack_gnsp_modify_application_resp(self, fields):
        """modify_application_resp报文打包"""
        message = struct.pack(self.transe_code['modify_application_resp'],
                fields['status'])
        return message

    def unpack_gnsp_modify_application_resp(self, packet):
        len = struct.calcsize(self.transe_code['modify_application_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['modify_application_resp'], packet[:len])

    def pack_gnsp_get_application(self, fields):
        message = struct.pack(self.transe_code['get_application'],
                fields['application_id'])
        return message

    def unpack_gnsp_get_application(self, packet):
        len = struct.calcsize(self.transe_code['get_application'])
        (self.body.fields['application_id'],) = \
            struct.unpack(self.transe_code['get_application'], packet[:len])

    def pack_gnsp_get_application_resp(self, fields):
        def packitem(item):
            return struct.pack(self.transe_code['get_application_resp'],
                    item['application_id'],
                    item['desc']
                    )
        m0 = struct.pack('II', fields['status'], len(self._list))
        m1 = map(packitem, self._list)
        message = ''.join([m0,] + m1)
        return message

    def unpack_gnsp_get_application_resp(self, packet):
        self.body.fields['status'], \
            self.body.fields['application_num'] = \
            struct.unpack('II',packet[:8])
        for i in range(self.body.fields['application_num']):
            self._list.append(dict(zip(['application_id','desc'],
                struct.unpack(self.transe_code['get_application_resp'], packet[8+80*i:8+80*i+80]))))

    def pack_gnsp_add_servicegroup(self, fields):
        message = struct.pack(self.transe_code['add_servicegroup'],
                fields['servicegroup_id'], \
                fields['desc'])
        return message

    def unpack_gnsp_add_servicegroup(self, packet):
        len = struct.calcsize(self.transe_code['add_servicegroup'])
        self.body.fields['servicegroup_id'], \
            self.body.fields['desc'] = \
            struct.unpack(self.transe_code['add_servicegroup'], packet[:len])

    def pack_gnsp_add_servicegroup_resp(self, fields):
        message = struct.pack(self.transe_code['add_servicegroup_resp'],
                fields['status'])
        return message

    def unpack_gnsp_add_servicegroup_resp(self, packet):
        len = struct.calcsize(self.transe_code['add_servicegroup_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['add_servicegroup_resp'], packet[:len])

    def pack_gnsp_modify_servicegroup(self, fields):
        message = struct.pack(self.transe_code['modify_servicegroup'],
                fields['servicegroup_id'], \
                fields['desc'])
        return message

    def unpack_gnsp_modify_servicegroup(self, packet):
        len = struct.calcsize(self.transe_code['modify_servicegroup'])
        self.body.fields['servicegroup_id'], \
            self.body.fields['desc'] = \
            struct.unpack(self.transe_code['modify_servicegroup'], packet[:len])

    def pack_gnsp_modify_servicegroup_resp(self, fields):
        message = struct.pack(self.transe_code['modify_servicegroup_resp'],
                fields['status'])
        return message

    def unpack_gnsp_modify_servicegroup_resp(self, packet):
        len = struct.calcsize(self.transe_code['modify_servicegroup_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['modify_servicegroup_resp'], packet[:len])

    def pack_gnsp_del_servicegroup(self, fields):
        """del_servicegroup报文打包"""
        message = struct.pack(self.transe_code['del_servicegroup'],
                fields['servicegroup_id'])
        return message

    def unpack_gnsp_del_servicegroup(self, packet):
        len = struct.calcsize(self.transe_code['del_servicegroup'])
        (self.body.fields['servicegroup_id'],) = \
            struct.unpack(self.transe_code['del_servicegroup'], packet[:len])

    def pack_gnsp_del_servicegroup_resp(self, fields):
        message = struct.pack(self.transe_code['del_servicegroup_resp'],
                fields['status'])
        return message

    def unpack_gnsp_del_servicegroup_resp(self, packet):
        len = struct.calcsize(self.transe_code['del_servicegroup_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['del_servicegroup_resp'], packet[:len])

    def pack_gnsp_get_servicegroup(self, fields):
        message = struct.pack(self.transe_code['get_servicegroup'],
                fields['servicegroup_id'])
        return message

    def unpack_gnsp_get_servicegroup(self, packet):
        len = struct.calcsize(self.transe_code['get_servicegroup'])
        (self.body.fields['servicegroup_id'],) = \
            struct.unpack(self.transe_code['get_servicegroup'], packet[:len])

    def pack_gnsp_get_servicegroup_resp(self, fields):
        def packitem(item):
            return struct.pack(self.transe_code['get_servicegroup_resp'],
                    item['servicegroup_id'],
                    item['desc']
                    )
        m0 = struct.pack('III',
                fields['status'],
                fields['servicegroup_num'],
                len(self._list))
        m1 = map(packitem, self._list)
        message = ''.join([m0,] + m1)
        return message

    def unpack_gnsp_get_servicegroup_resp(self, packet):
        self.body.fields['status'], \
            self.body.fields['servicegroup_num'], \
            self.body.fields['list_num'] = \
            struct.unpack('III', packet[:12])
        for i in range(self.body.fields['list_num']):
            self._list.append(dict(zip(['servicegroup_id','desc'],
                struct.unpack(self.transe_code['get_servicegroup_resp'] , packet[12+80*i:12+80*i+80]))))

    def pack_gnsp_add_service(self, fields):
        message = struct.pack(self.transe_code['add_service'],
                fields['service_id'], \
                fields['desc'], \
                fields['password'], \
                fields['host'], \
                fields['port'], \
                fields['domain'], \
                fields['tactics'], \
                fields['status'])
        return message

    def unpack_gnsp_add_service(self, packet):
        len = struct.calcsize(self.transe_code['add_service'])
        self.body.fields['service_id'], \
            self.body.fields['desc'], \
            self.body.fields['password'], \
            self.body.fields['host'], \
            self.body.fields['port'], \
            self.body.fields['domain'], \
            self.body.fields['tactics'], \
            self.body.fields['status'] = \
            struct.unpack(self.transe_code['add_service'], packet[:len])

    def pack_gnsp_add_service_resp(self, fields):
        message = struct.pack(self.transe_code['add_service_resp'],
                fields['status'])
        return message

    def unpack_gnsp_add_service_resp(self, packet):
        len = struct.calcsize(self.transe_code['add_service_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['add_service_resp'], packet[:len])

    def pack_gnsp_modify_service(self, fields):
        message = struct.pack(self.transe_code['modify_service'],
                fields['service_id'], \
                fields['mask'], \
                fields['desc'], \
                fields['password'], \
                fields['host'], \
                fields['port'], \
                fields['domain'], \
                fields['tactics'], \
                fields['status'])
        return message

    def unpack_gnsp_modify_service(self, packet):
        len = struct.calcsize(self.transe_code['modify_service'])
        self.body.fields['service_id'], \
            self.body.fields['mask'], \
            self.body.fields['desc'], \
            self.body.fields['password'], \
            self.body.fields['host'], \
            self.body.fields['port'], \
            self.body.fields['domain'], \
            self.body.fields['tactics'], \
            self.body.fields['status'] = \
            struct.unpack(self.transe_code['modify_service'], packet[:len])

    def pack_gnsp_modify_service_resp(self, fields):
        message = struct.pack(self.transe_code['modify_service_resp'],
                fields['status'])
        return message

    def unpack_gnsp_modify_service_resp(self, packet):
        len = struct.calcsize(self.transe_code['modify_service_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['modify_service_resp'], packet[:len])

    def pack_gnsp_del_service(self, fields):
        message = struct.pack(self.transe_code['del_service'],
                fields['service_id'])
        return message

    def unpack_gnsp_del_service(self, packet):
        len = struct.calcsize(self.transe_code['del_service'])
        (self.body.fields['service_id'],) = \
            struct.unpack(self.transe_code['del_service'], packet[:len])

    def pack_gnsp_del_service_resp(self, fields):
        message = struct.pack(self.transe_code['del_service_resp'],
                fields['status'])
        return message

    def unpack_gnsp_del_service_resp(self, packet):
        len = struct.calcsize(self.transe_code['del_service_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['del_service_resp'], packet[:len])

    def pack_gnsp_get_service(self, fields):
        message = struct.pack(self.transe_code['get_service'],
                fields['service_id'])
        return message

    def unpack_gnsp_get_service(self, packet):
        len = struct.calcsize(self.transe_code['get_service'])
        (self.body.fields['service_id'],) = \
            struct.unpack(self.transe_code['get_service'], packet[:len])

    def pack_gnsp_get_service_resp(self, fields):
        def packitem(item):
            return struct.pack(self.transe_code['get_service_resp'],
                    item['service_id'],
                    item['desc'],
                    item['host'],
                    item['port'],
                    item['listen_host'],
                    item['listen_port'],
                    item['domain'],
                    item['tactics'],
                    item['status'],
                    )
        m0 = struct.pack('III',
                fields['status'],
                fields['service_num'],
                len(self._list))
        m1 = map(packitem, self._list)
        message = ''.join([m0,] + m1)
        return message


    def unpack_gnsp_get_service_resp(self, packet):
        self.body.fields['status'], \
            self.body.fields['service_num'], \
            self.body.fields['list_num'] = \
            struct.unpack('III', packet[:12])
        for i in range(self.body.fields['list_num']):
            self._list.append(dict(zip(
                ['service_id', 'desc', 'host', 'port',
                 'listen_host', 'listen_port', 'domain', 'tactics', 'status'],
                struct.unpack(self.transe_code['get_service_resp'],
                    packet[12+161*i:12+161*i+161]))))

    def pack_gnsp_add_depend(self, fields):
        message = struct.pack(self.transe_code['add_depend'],
                fields['from_id'], \
                fields['to_id'])
        return message

    def unpack_gnsp_add_depend(self, packet):
        len = struct.calcsize(self.transe_code['add_depend'])
        self.body.fields['from_id'], \
            self.body.fields['to_id'] = \
            struct.unpack(self.transe_code['add_depend'], packet[:len])

    def pack_gnsp_add_depend_resp(self, fields):
        message = struct.pack(self.transe_code['add_depend_resp'],
                fields['status'])
        return message

    def unpack_gnsp_add_depend_resp(self, packet):
        len = struct.calcsize(self.transe_code['add_depend_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['add_depend_resp'], packet[:len])

    def pack_gnsp_del_depend(self, fields):
        message = struct.pack(self.transe_code['del_depend'],
                fields['from_id'], \
                fields['to_id'])
        return message

    def unpack_gnsp_del_depend(self, packet):
        len = struct.calcsize(self.transe_code['del_depend'])
        self.body.fields['from_id'], \
            self.body.fields['to_id'] = \
            struct.unpack(self.transe_code['del_depend'], packet[:len])

    def pack_gnsp_del_depend_resp(self, fields):
        message = struct.pack(self.transe_code['del_depend_resp'],
                fields['status'])
        return message

    def unpack_gnsp_del_depend_resp(self, packet):
        len = struct.calcsize(self.transe_code['del_depend_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['del_depend_resp'], packet[:len])

    def pack_gnsp_get_depend(self, fields):
        message = struct.pack(self.transe_code['get_depend'],
                fields['from_id'], \
                fields['to_id'])
        return message

    def unpack_gnsp_get_depend(self, packet):
        len = struct.calcsize(self.transe_code['get_depend'])
        self.body.fields['from_id'], \
            self.body.fields['to_id'] = \
            struct.unpack(self.transe_code['get_depend'], packet[:len])

    def pack_gnsp_get_depend_resp(self, fields):
        def packitem(item):
            return struct.pack(self.transe_code['get_depend_resp'],
                    item['from_id'],
                    item['to_id']
                    )
        m0 = struct.pack('II', fields['status'], len(self._list))
        m1 = map(packitem, self._list)
        message = ''.join([m0,] + m1)
        return message


    def unpack_gnsp_get_depend_resp(self, packet):
        self.body.fields['status'], \
            self.body.fields['depend_num'] = \
            struct.unpack('II',packet[:8])
        for i in range(self.body.fields['depend_num']):
            self._list.append(dict(zip(['from_id','to_id'], struct.unpack(self.transe_code['get_depend_resp'], packet[8+32*i:8+32*i+32]))))

    def pack_gnsp_service_login(self, fields):
        message = struct.pack(self.transe_code['service_login'],
                fields['service_id'], \
                fields['listen_host'], \
                fields['listen_port'], \
                fields['status'])
        return message

    def unpack_gnsp_service_login(self, packet):
        len = struct.calcsize(self.transe_code['service_login'])
        self.body.fields['service_id'], \
            self.body.fields['listen_host'], \
            self.body.fields['listen_port'], \
            self.body.fields['status'] = \
            struct.unpack(self.transe_code['service_login'], packet[:len])

    def pack_gnsp_service_login_resp(self, fields):
        message = struct.pack(self.transe_code['service_login_resp'],
                fields['status'])
        return message

    def unpack_gnsp_service_login_resp(self, packet):
        len = struct.calcsize(self.transe_code['service_login_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['service_login_resp'], packet[:len])

    def pack_gnsp_service_logout(self, fields):
        message = struct.pack(self.transe_code['service_logout'],
                fields['service_id'])
        return message

    def unpack_gnsp_service_logout(self, packet):
        len = struct.calcsize(self.transe_code['service_logout'])
        (self.body.fields['service_id'],) = \
            struct.unpack(self.transe_code['service_logout'], packet[:len])

    def pack_gnsp_service_logout_resp(self, fields):
        message = struct.pack(self.transe_code['service_logout_resp'],
                fields['status'])
        return message

    def unpack_gnsp_service_logout_resp(self, packet):
        len = struct.calcsize(self.transe_code['service_logout_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['service_logout_resp'], packet[:len])

    def pack_gnsp_select_service(self, fields):
        message = struct.pack(self.transe_code['select_service'],
                fields['service_id'])
        return message

    def unpack_gnsp_select_service(self, packet):
        len = struct.calcsize(self.transe_code['select_service'])
        (self.body.fields['service_id'],) = \
            struct.unpack(self.transe_code['select_service'], packet[:len])

    def pack_gnsp_select_service_resp(self, fields):
        def packitem(item):
            return struct.pack(self.transe_code['select_service_resp'],
                    item['service_id'],
                    item['servicegroup_id'],
                    item['host'],
                    item['port'],
                    item['level'],
                    item['weight'],
                    )
        m0 = struct.pack('II', fields['status'], len(self._list))
        m1 = map(packitem, self._list)
        message = ''.join([m0,] + m1)
        return message

    def unpack_gnsp_select_service_resp(self, packet):
        self.body.fields['status'], \
            self.body.fields['service_num'] = \
            struct.unpack('II',packet[:8])
        for i in range(self.body.fields['service_num']):
            self._list.append(dict(zip(
                ['service_id', 'servicegroup_id',
                 'host', 'port', 'level', 'weight'],
                struct.unpack(self.transe_code['select_service_resp'], packet[8+76*i:8+76*i+76]))))

    def pack_gnsp_service_warning(self, fields):
        message = struct.pack(self.transe_code['service_warning'],
                fields['service_id'], \
                fields['warning_id'], \
                fields['level'])
        return message

    def unpack_gnsp_service_warning(self, packet):
        len = struct.calcsize(self.transe_code['service_warning'])
        self.body.fields['service_id'], \
            self.body.fields['warning_id'], \
            self.body.fields['level'] = \
            struct.unpack(self.transe_code['service_warning'], packet[:len])

    def pack_gnsp_service_warning_resp(self, fields):
        message = struct.pack(self.transe_code['service_warning_resp'],
                fields['status'])
        return message

    def unpack_gnsp_service_warning_resp(self, packet):
        len = struct.calcsize(self.transe_code['service_warning_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['service_warning_resp'], packet[:len])

    def pack_gnsp_service_notify(self, fields):
        message = struct.pack(self.transe_code['service_notify'],
                fields['service_id'], \
                fields['level'], \
                fields['weight'], \
                fields['status'])
        return message

    def unpack_gnsp_service_notify(self, packet):
        len = struct.calcsize(self.transe_code['service_notify'])
        self.body.fields['service_id'], \
            self.body.fields['level'], \
            self.body.fields['weight'], \
            self.body.fields['status'] = \
            struct.unpack(self.transe_code['service_notify'], packet[:len])

    def pack_gnsp_service_notify_resp(self, fields):
        message = struct.pack(self.transe_code['service_notify_resp'],
                fields['status'])
        return message

    def unpack_gnsp_service_notify_resp(self, packet):
        len = struct.calcsize(self.transe_code['service_notify_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['service_notify_resp'], packet[:len])

    def pack_gnsp_add_group2app(self, fields):
        message = struct.pack(self.transe_code['add_group2app'],
                fields['application_id'], \
                fields['servicegroup_id'])
        return message

    def unpack_gnsp_add_group2app(self, packet):
        len = struct.calcsize(self.transe_code['add_group2app'])
        self.body.fields['application_id'], \
            self.body.fields['servicegroup_id'] = \
            struct.unpack(self.transe_code['add_group2app'], packet[:len])

    def pack_gnsp_add_group2app_resp(self, fields):
        message = struct.pack(self.transe_code['add_group2app_resp'],
                fields['status'])
        return message

    def unpack_gnsp_add_group2app_resp(self, packet):
        len = struct.calcsize(self.transe_code['add_group2app_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['add_group2app_resp'], packet[:len])

    def pack_gnsp_del_group2app(self, fields):
        message = struct.pack(self.transe_code['del_group2app'],
                fields['application_id'], \
                fields['servicegroup_id'])
        return message

    def unpack_gnsp_del_group2app(self, packet):
        len = struct.calcsize(self.transe_code['del_group2app'])
        self.body.fields['application_id'], \
            self.body.fields['servicegroup_id'] = \
            struct.unpack(self.transe_code['del_group2app'], packet[:len])

    def pack_gnsp_del_group2app_resp(self, fields):
        message = struct.pack(self.transe_code['del_group2app_resp'],
                fields['status'])
        return message

    def unpack_gnsp_del_group2app_resp(self, packet):
        len = struct.calcsize(self.transe_code['del_group2app_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['del_group2app_resp'], packet[:len])

    def pack_gnsp_get_group2app(self, fields):
        message = struct.pack(self.transe_code['get_group2app'],
                fields['application_id'])
        return message

    def unpack_gnsp_get_group2app(self, packet):
        len = struct.calcsize(self.transe_code['get_group2app'])
        (self.body.fields['application_id'],) = \
            struct.unpack(self.transe_code['get_group2app'], packet[:len])

    def pack_gnsp_get_group2app_resp(self, fields):
        def packitem(item):
            return struct.pack(self.transe_code['get_group2app_resp'],
                    item['servicegroup_id'],
                    item['desc']
                    )
        m0 = struct.pack('II', fields['status'], len(self._list))
        m1 = map(packitem, self._list)
        message = ''.join([m0,] + m1)
        return message

    def unpack_gnsp_get_group2app_resp(self, packet):
        self.body.fields['status'], \
            self.body.fields['servicegroup_num'] = \
            struct.unpack('II',packet[:8])
        for i in range(self.body.fields['servicegroup_num']):
            self._list.append(dict(zip(['servicegroup_id','desc'],
                struct.unpack(self.transe_code['get_group2app_resp'], packet[8+80*i:8+80*i+80]))))

    def pack_gnsp_get_groupofapp(self, fields):
        message = struct.pack(self.transe_code['get_groupofapp'],
                fields['servicegroup_id'])
        return message

    def unpack_gnsp_get_groupofapp(self, packet):
        len = struct.calcsize(self.transe_code['get_groupofapp'])
        (self.body.fields['servicegroup_id'],) = \
            struct.unpack(self.transe_code['get_groupofapp'], packet[:len])

    def pack_gnsp_get_groupofapp_resp(self, fields):
        def packitem(item):
            return struct.pack(self.transe_code['get_groupofapp_resp'],
                    item['application_id'],
                    item['desc']
                    )
        m0 = struct.pack('II', fields['status'], len(self._list))
        m1 = map(packitem, self._list)
        message = ''.join([m0,] + m1)
        return message


    def unpack_gnsp_get_groupofapp_resp(self, packet):
        self.body.fields['status'], \
            self.body.fields['application_num'] = \
            struct.unpack('II',packet[:8])
        for i in range(self.body.fields['application_num']):
            self._list.append(dict(zip(['application_id','desc'], struct.unpack(self.transe_code['get_groupofapp_resp'], packet[8+80*i:8+80*i+80]))))

    def pack_gnsp_add_service2group(self, fields):
        message = struct.pack(self.transe_code['add_service2group'],
                fields['servicegroup_id'], \
                fields['service_id'], \
                fields['level'], \
                fields['weight'])
        return message

    def unpack_gnsp_add_service2group(self, packet):
        len = struct.calcsize(self.transe_code['add_service2group'])
        self.body.fields['servicegroup_id'], \
            self.body.fields['service_id'], \
            self.body.fields['level'], \
            self.body.fields['weight'] = \
            struct.unpack(self.transe_code['add_service2group'], packet[:len])

    def pack_gnsp_add_service2group_resp(self, fields):
        message = struct.pack(self.transe_code['add_service2group_resp'] ,
                fields['status'])
        return message

    def unpack_gnsp_add_service2group_resp(self, packet):
        len = struct.calcsize(self.transe_code['add_service2group_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['add_service2group_resp'], packet[:len])

    def pack_gnsp_del_service2group(self, fields):
        message = struct.pack(self.transe_code['del_service2group'],
                fields['servicegroup_id'], \
                fields['service_id'])
        return message

    def unpack_gnsp_del_service2group(self, packet):
        len = struct.calcsize(self.transe_code['del_service2group'])
        self.body.fields['servicegroup_id'], \
            self.body.fields['service_id'] = \
            struct.unpack(self.transe_code['del_service2group'], packet[:len])

    def pack_gnsp_del_service2group_resp(self, fields):
        message = struct.pack(self.transe_code['del_service2group_resp'],
                fields['status'])
        return message

    def unpack_gnsp_del_service2group_resp(self, packet):
        len = struct.calcsize(self.transe_code['del_service2group_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['del_service2group_resp'], packet[:len])

    def pack_gnsp_modify_service2group(self, fields):
        message = struct.pack(self.transe_code['modify_service2group'],
                fields['servicegroup_id'], \
                fields['service_id'], \
                fields['level'], \
                fields['weight'])
        return message

    def unpack_gnsp_modify_service2group(self, packet):
        len = struct.calcsize(self.transe_code['modify_service2group'])
        self.body.fields['servicegroup_id'], \
            self.body.fields['service_id'], \
            self.body.fields['level'], \
            self.body.fields['weight'] = \
            struct.unpack(self.transe_code['modify_service2group'], packet[:len])

    def pack_gnsp_modify_service2group_resp(self, fields):
        message = struct.pack(self.transe_code['modify_service2group_resp'],
                fields['status'])
        return message

    def unpack_gnsp_modify_service2group_resp(self, packet):
        len = struct.calcsize(self.transe_code['modify_service2group_resp'])
        (self.body.fields['status'],) = \
            struct.unpack(self.transe_code['modify_service2group_resp'], packet[:len])

    def pack_gnsp_get_service2group(self, fields):
        message = struct.pack(self.transe_code['get_service2group'],
                fields['servicegroup_id'])
        return message

    def unpack_gnsp_get_service2group(self, packet):
        len = struct.calcsize(self.transe_code['get_service2group'])
        (self.body.fields['servicegroup_id'],) = \
            struct.unpack(self.transe_code['get_service2group'], packet[:len])

    def pack_gnsp_get_service2group_resp(self, fields):
        def packitem(item):
            return struct.pack(self.transe_code['get_service2group_resp'],
                    item['service_id'],
                    item['host'],
                    item['port'],
                    item['listen_host'],
                    item['listen_port'],
                    item['level'],
                    item['weight'],
                    item['domain'],
                    item['tactics'],
                    item['status'],
                    )
        m0 = struct.pack('III',
                fields['status'],
                fields['service_num'],
                len(self._list))
        m1 = map(packitem, self._list)
        message = ''.join([m0,] + m1)
        return message

    def unpack_gnsp_get_service2group_resp(self, packet):
        self.body.fields['status'], \
            self.body.fields['service_num'], \
            self.body.fields['list_num'] = \
            struct.unpack('III',packet[:12])
        for i in range(self.body.fields['list_num']):
            self._list.append(dict(zip(
                ['service_id', 'host', 'port', 'listen_host', 'listen_port',
                 'level', 'weight', 'domain', 'tactics', 'status'],
                struct.unpack(self.transe_code['get_service2group_resp'], packet[12+105*i:12+105*i+105]))))

    def pack_gnsp_get_serviceofgroup(self, fields):
        message = struct.pack(self.transe_code['get_serviceofgroup'],
                fields['service_id'])
        return message

    def unpack_gnsp_get_serviceofgroup(self, packet):
        len = struct.calcsize(self.transe_code['get_serviceofgroup'])
        (self.body.fields['service_id'],) = \
            struct.unpack(self.transe_code['get_serviceofgroup'], packet[:len])

    def pack_gnsp_get_serviceofgroup_resp(self, fields):
        def packitem(item):
            return struct.pack(self.transe_code['get_serviceofgroup_resp'],
                    item['servicegroup_id'],
                    item['desc'],
                    )
        m0 = struct.pack('II', fields['status'], len(self._list))
        m1 = map(packitem, self._list)
        message = ''.join([m0,] + m1)
        return message


    def unpack_gnsp_get_serviceofgroup_resp(self, packet):
        self.body.fields['status'], \
            self.body.fields['servicegroup_num'] = \
            struct.unpack('II',packet[:8])
        for i in range(self.body.fields['servicegroup_num']):
            self._list.append(dict(zip(['servicegroup_id','desc'],
                struct.unpack(self.transe_code['get_serviceofgroup_resp'], packet[8+80*i:8+80*i+80]))))

class GNSPMessageUtil(bytemsg.ByteMessageUtil):
    def __init__(self):
        pass

## GNSP Message
GNSPMessageUtil.commandinfo = {
    0x00000001L : 'connect',	###
    0xff000001L : 'connect_resp',	###
    0x00000002L : 'disconnect',	###
    0xff000002L : 'disconnect_resp',	###
    0x00000010L : 'add_application',	###
    0xff000010L : 'add_application_resp',	###
    0x00000011L : 'del_application',	###
    0xff000011L : 'del_application_resp',	###
    0x00000012L : 'modify_application',	###
    0xff000012L : 'modify_application_resp',	###
    0x00000013L : 'get_application',	###
    0xff000013L : 'get_application_resp',	###
    0x00000014L : 'add_servicegroup',	###
    0xff000014L : 'add_servicegroup_resp',	###
    0x00000015L : 'modify_servicegroup',	###
    0xff000015L : 'modify_servicegroup_resp',	###
    0x00000016L : 'del_servicegroup',	###
    0xff000016L : 'del_servicegroup_resp',	###
    0x00000017L : 'get_servicegroup',	###
    0xff000017L : 'get_servicegroup_resp',	###
    0x00000018L : 'add_service',	###
    0xff000018L : 'add_service_resp',	###
    0x00000019L : 'modify_service',	###
    0xff000019L : 'modify_service_resp',	###
    0x0000001aL : 'del_service',	###
    0xff00001aL : 'del_service_resp',	###
    0x0000001bL : 'get_service',	###
    0xff00001bL : 'get_service_resp',	###
    0x0000001cL : 'add_depend',	###
    0xff00001cL : 'add_depend_resp',	###
    0x0000001dL : 'del_depend',	###
    0xff00001dL : 'del_depend_resp',	###
    0x0000001eL : 'get_depend',	###
    0xff00001eL : 'get_depend_resp',	###
    0x0000001fL : 'service_login',	###
    0xff00001fL : 'service_login_resp',	###
    0x00000020L : 'service_logout',	###
    0xff000020L : 'service_logout_resp',	###
    0x00000021L : 'select_service',	###
    0xff000021L : 'select_service_resp',	###
    0x00000022L : 'service_warning',	###
    0xff000022L : 'service_warning_resp',	###
    0x00000023L : 'service_notify',	###
    0xff000023L : 'service_notify_resp',	###
    0x00000024L : 'add_group2app',	###
    0xff000024L : 'add_group2app_resp',	###
    0x00000025L : 'del_group2app',	###
    0xff000025L : 'del_group2app_resp',	###
    0x00000026L : 'get_group2app',	###
    0xff000026L : 'get_group2app_resp',	###
    0x00000027L : 'get_groupofapp',	###
    0xff000027L : 'get_groupofapp_resp',	###
    0x00000028L : 'add_service2group',	###
    0xff000028L : 'add_service2group_resp',	###
    0x00000029L : 'del_service2group',	###
    0xff000029L : 'del_service2group_resp',	###
    0x0000002aL : 'modify_service2group',	###
    0xff00002aL : 'modify_service2group_resp',	###
    0x0000002bL : 'get_service2group',	###
    0xff00002bL : 'get_service2group_resp',	###
    0x0000002cL : 'get_serviceofgroup',	###
    0xff00002cL : 'get_serviceofgroup_resp'	###
    }

### 
GNSPMessageUtil.nametoid = {}
for k in GNSPMessageUtil.commandinfo.keys():
    GNSPMessageUtil.nametoid[GNSPMessageUtil.commandinfo[k]] = k
