#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.test_bytemsg-*-
# report bug to: riverfor@gmail.com
#
# $Id: bytemsg.py,v 1.3 2005/02/18 07:49:10 hecun Exp $
"""
Open Unified Storage System Protocol
Stability: None
@author: U{HD<mailto:hdcola@gmail.com>}
@see: Open Unified Storage System Protocol norm
"""

## framework's packages
import struct

### class that pack or unpack the packet 
class ByteMessage:
    def __init__(self):
        pass
        # self.head = None
        # self.body = None
        # self.msgutilcls = None
        # self.msgname = ''
        # self.protocolname = ''
        # self._list = []

    def addlist(self, items):
        self._list = []
        for item in items:
            self._list.append(dict(item))

    def getlist(self):
        return self._list

    def loadMessage(self, packet):
        self.head.loadHead(packet[:len(self.head)])
        self.msgname = self.msgutilcls.commandinfo[self.head.id]
        self.body.loadBody(self.msgname, packet[len(self.head):])

    def setMsgName(self, msgname):
        self.head.setId(self.msgutilcls.nametoid[msgname])
        self.msgname = msgname

    def packed(self):
        body = self.body.packed()
        if (body == None):
            return self.head.packed()
        else:
            self.head.setLength(len(self.head) + len(body))
            return self.head.packed() + body

    def __str__(self):
        return str(self.head) + '\n' + str(self.body)

### the packet's Head class
class ByteMessageHead:
    # Packet of Head : length(4 bytes), commandid(4 bytes), sequence(4 bytes)
    def __init__(self, parent):
        self.length = 12
        self.id = 0
        self.sequence = 0
        self.parent = parent

    def __len__(self):
        return 12

    def setId(self,id):
        self.id = id

    def setSequence(self,sequence):
        self.sequence = sequence

    def setLength(self, length):
        self.length = length

    def loadHead(self, header):
        ## translate the stream to packet
        self.length,self.id,self.sequence = struct.unpack('>III', header)

    def packed(self):
        return struct.pack('>III', self.length, self.id, self.sequence)

    def __str__(self):
        plist = []
        plist.append("packet's id: %s" % self.id)
        plist.append("packet's length: %s" % self.length)
        plist.append("packet's sequence: %s" % self.sequence)
        return reduce(lambda x, y: x + "\n" + y, plist)

### the packet's body class
class ByteMessageBody:
    def __init__(self, parent):
        self.fields = {}
        self.setField = self.fields.__setitem__
        self.__setitem__ = self.fields.__setitem__
        self.__getitem__ = self.fields.__getitem__
        self.parent = parent

    def loadBody(self, msgname, packet):
        method = getattr(self.parent , "unpack_%s_%s" %(self.parent.protocolname, msgname), None)
        method(packet)
        self.conversionString()

    def packed(self):
        method = getattr(self.parent , "pack_%s_%s" %(self.parent.protocolname, self.parent.msgname), None)
        return method(self.fields)

    def conversionString(self):
        for field in self.fields.keys():
            if ( isinstance(self.fields[field],str) ):
                index = self.fields[field].find('\0')
                if index > -1:
                    self.fields[field] = self.fields[field][:index]
        for item in self.parent._list:
            for k in item.keys():
                if isinstance(item[k], str):
                    index = item[k].find('\0')
                    if index > -1:
                        item[k] = item[k][:index]

    def __str__(self):
        if len(self.fields) > 0:
            plist = []
            for field in self.fields.keys():
                plist.append(str(field) + ": "  + str(self.fields[field]))
            return reduce(lambda x, y: x + "\n" + y, plist)
        else:
            return ""

### packet's util class
class ByteMessageUtil:
    def __init__(self):
        self.commandinfo = {}
        self.nametoid = {}

    def getCommandinfo(self):
        return self.commandinfo

    def getCommandName(self, commandid):
        return self.commandinfo[commandid]
