#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.dispatcherclient.test_server-*-
# report bug to: riverfor@sina.com.cn
"""
dispatcherclient's module
"""
from compass.common.framework import Storage
from compass.common.framework import DataPacked
from compass.common.error import SUCCESS, DB_IO, SERVICE_NO_EXIST, SGSERVICE_NO_EXIST

### the part of request
class ServiceRequest(DataPacked, Storage):
    def _service_notify(self, sgid, service_id):
        """
.s operation for service_notify
	"""
	packet = ""
	sdata = self.lookup('service', {'id': service_id})
	if sdata == None:
	    return (SERVICE_NO_EXIST, packet)
	sgdata = self.lookup('sgservice', {'serviceid': service_id, 'sgid': sgid})
	if sgdata == None:
	    return (SGSERVICE_NO_EXIST, packet)
	packet = self.data_packed('service_notify',
	                          ('service_id', service_id), \
				  ('level', sgdata[0]['level']), \
				  ('weight', sgdata[0]['weight']), \
				  ('status', sdata[0]['status'])) 
	return (SUCCESS, packet)			  

    def service_notify(self, sgid, service_id):
        """
	packet operation
	"""
	self.opendb()
	result = self._service_notify(sgid, service_id)
	self.close()
	return result[0] == SUCCESS and self.sendData(result[1]) or result[0]
