#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.test_adminclient -*-
# report bug to: riverfor@gmail.com
"""
This module includes the  common functions that the application operation will call
"""
from compass.common.framework import DataPacked

### the part of request about application
class ApplicationRequest(DataPacked):
    def add_application(self, application_id, desc):
        return self.sendData(self.data_packed('add_application',
	                               ('application_id', application_id),
				       ('desc', desc)))

    def on_gnsp_add_application_resp(self, messages):
        pass

    def del_application(self, application_id):
        return self.sendData(self.data_packed('del_application', ('application_id', application_id)))

    def on_gnsp_del_application_resp(self, message):
        pass

    def modify_application(self, application_id, desc):
        packet = self.data_packed('modify_application',
	                          ('application_id', application_id),
				  ('desc', desc)
				 )
	return self.sendData(packet)			 

    def on_gnsp_modify_application_resp(self, message):
        pass

    def get_application(self, application_id):
        return self.sendData(self.data_packed('get_application', ('application_id', application_id)))

    def on_gnsp_get_application_resp(self, message):
        pass

    #### group relevance
    def add_group2app(self, application_id, applicationgroup_id):
        packet = self.data_packed('add_group2app',
	                          ('application_id', application_id),
				  ('servicegroup_id', applicationgroup_id)
				 )
	return self.sendData(packet)

    def on_gnsp_add_group2app_resp(self, message):
        pass

    def del_group2app(self, application_id, applicationgroup_id):
        packet = self.data_packed('del_group2app',
	                          ('application_id', application_id),
				  ('servicegroup_id', applicationgroup_id)
				 )
	return self.sendData(packet)

    def on_gnsp_del_group2app_resp(self, message):
        pass

    def get_group2app(self, application_id):
        return self.sendData(self.data_packed('get_group2app', ('application_id', application_id)))

    def on_gnsp_get_group2app_resp(self, message):
        pass

    #### group of app
    def get_groupofapp(self, servicegroup_id):
        return self.sendData(self.data_packed('get_groupofapp',
				       ('servicegroup_id', servicegroup_id)
				      )) 

    def on_gnsp_get_groupofapp_resp(self, message):
        pass
