#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.test_scs -*-
# report bug to: riverfor@sina.com.cn
"""
This module includes the connect and disconnect between the server and client, auth by password
"""
from compass.common.framework import DataPacked
from compass.protocols.base import GNSProtocol, TimeDevice
from compass.protocols.base import makeAuthSource, checkAuthSource
from compass.common.error import SUCCESS, DISCONNECT
##

### ClientINterface included the command functions that client used
class ClientCommon(GNSProtocol):
    __implements__ = (DataPacked,)
    def __init__(self):
        self.config = {}
	self.loadConfig()
        GNSProtocol.__init__(self)
        self.timedevice = TimeDevice()
	self.packets = []

    def connect(self):
	"""undocumented
	"""
        time_stamp = self.timedevice.getTimeStamp()
	auth_source = makeAuthSource(self.config['service_id'],\
	    self.config['password'], time_stamp)
	return self.common_out('connect', 'service_id', 'version',
	    {'time_stamp': time_stamp, 'auth_source': auth_source})

    def on_gnsp_connect_resp(self, packet):
	"""undocumented

	reutrn : (packet['status'], next_cmd_status)
	"""
	bag = packet.body.fields
	return self.cmd_out(bag['status'])

    def disconnect(self):
        packet = self.data_packed('disconnect')
	self.sendData(packet)

    def on_gnsp_disconnect_resp(self, packet):
        # TODO
	self.transport.loseConnection()

### ServerInterface included the common functions that client used
class ServerCommon(GNSProtocol, DataPacked):
    def __init__(self):
        self.config = {}
	self.loadConfig()
        GNSProtocol.__init__(self)
	self.packets = []

    def on_gnsp_connect(self, packet):
	bag = packet.body.fields
	if checkAuthSource(bag['auth_source'], bag['service_id'], self.config['password'], bag['time_stamp']):
	    self.sendData(self.data_packed('connect_resp', ('status',SUCCESS), 'version'))
	else:
	    self.transport.loseConnection()

    def on_gnsp_disconnect(self, packet):
	packet = self.data_packed('disconnect_resp')
	self.sendData(packet)
