#!/usr/bin/env python
# -*- coding: utf-8 -*-
# report bugs to: riverfor@sina.com.cn

from compass.storage.sqliteio import Storage
from compass.test.framework import unittest, SimpleSQLDBApi

class StorageTestCase(unittest.TestCase):
    def setUp(self):
	self.storage = Storage()
	self.storage.db_conn = SimpleSQLDBApi()
	self.storage.cursor = self.storage.db_conn.cursor()

    def tearDown(self):
	self.storage.cursor = None
        self.storage.db_conn = None
        self.storage = None

    def testLookupAll(self):
	self.storage.cursor.expect('SELECT * FROM zone', 'special')
        result = self.storage.lookup('zone', {})
	self.assertEquals(result, ['special'])

    def testLookup1(self):
	self.storage.cursor.expect('SELECT * FROM zone WHERE key = \"value\"', 'special')
        result = self.storage.lookup('zone', {'key': 'value'})
	self.assertEquals(result, ['special'])

    def testLookup2(self):
        self.storage.cursor.expect('SELECT * FROM zone WHERE key2 = \"value2\" AND key = \"value1\"', "special2")
	result = self.storage.lookup('zone', {'key': 'value1', 'key2': 'value2'})
	self.assertEquals(result, ['special2'])

    def testLookup3(self):
        self.storage.cursor.expect('SELECT * FROM zone WHERE key3 = \"value3\" AND key2 = \"value2\" AND key1 = \"value1\"', "special3")
	result = self.storage.lookup('zone', {'key1': 'value1', 'key2': 'value2', 'key3': 'value3'})
	self.assertEquals(result, ['special3'])

    def testDeleteAll(self):
        self.storage.cursor.expect('DELETE FROM zone', 0)
	result = self.storage.delete('zone', {})
	self.assertEquals(result, 0)

    def testDelete1(self):
        self.storage.cursor.expect('DELETE FROM zone WHERE key = \"value\"', 0)
	result = self.storage.delete('zone', {'key': 'value'})
	self.assertEquals(result, 0)

    def testDelete2(self):
        self.storage.cursor.expect('DELETE FROM zone WHERE key2 = \"value2\" AND key = \"value\"', 0)
	result = self.storage.delete('zone', {'key': 'value', 'key2': 'value2'})
	self.assertEquals(result, 0)

    def testAddApp(self):
        self.storage.cursor.expect('INSERT INTO application VALUES(\"app001\", \"desc for app001\")', 0)
	result = self.storage.add('application', {'id': 'app001', 'desc': 'desc for app001'})
	self.assertEquals(result, 0)

    def testAddSg(self):
        self.storage.cursor.expect('INSERT INTO servicegroup VALUES(\"sg001\", \"desc for sg001\")', 0)
	result = self.storage.add('servicegroup', {'id': 'sg001', 'desc': 'desc for sg001'})
	self.assertEquals(result, 0)

    def testAddService(self):
        self.storage.cursor.expect('INSERT INTO service VALUES(\"service001\", \"desc for service001\", \"passwordfors001\", \"compass.sina.com\", \"8080\", \"\", \"\", \"16\", \"15\", \"R\")', 0)
	result = self.storage.add('service', {'id': 'service001', \
	                                      'desc': 'desc for service001', \
					      'password': 'passwordfors001', \
					      'host': 'compass.sina.com', \
					      'port': 8080, \
					      'domain': 16, \
					      'tactics': 15, \
					      'status': 'R'})
	self.assertEquals(result, 0)				      

    def testAddAppSg(self):
        self.storage.cursor.expect('INSERT INTO appsg VALUES(\"app001\", \"sg001\")', 0)
	result = self.storage.add('appsg', {'appid': 'app001', 'sgid': 'sg001'})
	self.assertEquals(result, 0)

    def testAddSgService(self):
        self.storage.cursor.expect('INSERT INTO sgservice VALUES(\"sg001\", \"service001\", \"8\", \"7\")', 0)
	result = self.storage.add('sgservice', {'sgid': 'sg001', 'serviceid': 'service001', 'level': 8, 'weight': 7})
	self.assertEquals(result, 0)

    def testUpdateApp(self):
        self.storage.cursor.expect('UPDATE application SET desc = \"desc changed\" WHERE id = \"app001\"',  0)
	result = self.storage.update('application', {'id': 'app001'}, {'desc': 'desc changed'})
	self.assertEquals(result, 0)

    def testUpdateSG(self):
        self.storage.cursor.expect('UPDATE servicegroup SET desc = \"desc changed\" WHERE id = \"sg001\"', 0)
	result = self.storage.update('servicegroup', {'id': 'sg001'}, {'desc': 'desc changed'})
	self.assertEquals(result, 0)

    def testUpdateServiceAll(self):
        self.storage.cursor.expect('UPDATE service SET status = "B", listen_host = "web.compass.sina.com", domain = "15", tactics = "3", listen_port = "8002", host = "center.compass.sina.com", password = "passwordc", port = "8081", desc = "desc changed" WHERE id = "service001"', 0)
	result = self.storage.update('service', {'id': 'service001'}, {'status': 'B', 'tactics': '3', 'domain': '15', 'listen_port': 8002, 'listen_host': 'web.compass.sina.com', 'port': 8081, 'host': 'center.compass.sina.com', 'password': 'passwordc', 'desc': 'desc changed'})
	self.assertEquals(result, 0)

    def testUpdateService1(self):
        self.storage.cursor.expect('UPDATE service SET desc = \"desc changed\" WHERE id = \"service001\"', 0)
	result = self.storage.update('service', {'id': 'service001'}, {'desc': 'desc changed'})
	self.assertEquals(result, 0)

    def testUpdateService2(self):
        self.storage.cursor.expect('UPDATE service SET password = \"passwordc\", desc = \"desc changed\" WHERE id = \"service001\"', 0)
	result = self.storage.update('service', {'id': 'service001'}, {'desc': 'desc changed', 'password': 'passwordc'})
	self.assertEquals(result, 0)

    def testUpdateSgserviceAll(self):
        self.storage.cursor.expect('UPDATE sgservice SET weight = \"8\", level = \"15\" WHERE sgid = \"sg001\" AND serviceid = \"service001\"', 0)
	result = self.storage.update('sgservice', {'sgid': 'sg001', 'serviceid': 'service001'}, {'level': 15, 'weight': 8})
	self.assertEquals(result, 0)

    def testUpdateSgservice1(self):
        self.storage.cursor.expect('UPDATE sgservice SET weight = \"8\" WHERE sgid = \"sg001\" AND serviceid = \"service001\"', 0)
	result = self.storage.update('sgservice', {'sgid': 'sg001', 'serviceid': 'service001'}, {'weight': 8})
	self.assertEquals(result, 0)
