#!/usr/bin/env python
# -*- coding: utf-8 -*-
# report bugs to: riverfor@sina.com.cn
"""
Test target module: compass.common.response.dispatchersgservice
"""

from compass.common.error import SUCCESS
from compass.test.dispatcherserver.base import DispatcherServerTestCase

class SgServiceForResponseTestCase(DispatcherServerTestCase):
    """
    this part is the response to the request of the service-group's operation
    """
    def testAddServiceGroupSuccess(self):
        self._dbInit({'servicegroup': [{'id': 'sg001', 'desc': 'desc for sg001'}]})
	packet = self.client.data_packed('add_servicegroup', \
	                                 ('servicegroup_id', 'sg003'), \
					 ('desc', 'desc for addsg') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'add_servicegroup')
	self.assertEquals(sbag.body['servicegroup_id'], 'sg003')
	self.assertEquals(sbag.body['desc'], 'desc for addsg')
	self.assertEquals(cbag.msgname, 'add_servicegroup_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['servicegroup']
	result = self.server.storage.result
	self.assertEquals(len(data), 2)
	self.assertEquals(data[0]['id'], 'sg001')
	self.assertEquals(data[0]['desc'], 'desc for sg001')
	self.assertEquals(data[1]['id'], 'sg003')
	self.assertEquals(data[1]['desc'], 'desc for addsg')
	self.assertEquals(result, SUCCESS)

    def testAddServiceGroupFail(self):
        self._dbInit({'servicegroup': [{'id': 'sg003', 'desc': 'desc for sg001'}]})
	packet = self.client.data_packed('add_servicegroup', \
	                                 ('servicegroup_id', 'sg003'), \
					 ('desc', 'desc for addsg') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'add_servicegroup')
	self.assertEquals(sbag.body['servicegroup_id'], 'sg003')
	self.assertEquals(sbag.body['desc'], 'desc for addsg')
	self.assertEquals(cbag.msgname, 'add_servicegroup_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['servicegroup']
	result = self.server.storage.result
	self.assertEquals(len(data), 1)
	self.assertEquals(data[0]['id'], 'sg003')
	self.assertEquals(data[0]['desc'], 'desc for sg001')
	self.assertNotEquals(result, SUCCESS)

    def testModifyServicegroup(self):
        self._dbInit({'servicegroup': [{'id': 'sg004', 'desc': 'desc source'}]})
	packet = self.client.data_packed('modify_servicegroup', \
	                                 ('servicegroup_id', 'sg004'), \
					 ('desc', 'desc for modify') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'modify_servicegroup')
	self.assertEquals(sbag.body['servicegroup_id'], 'sg004')
	self.assertEquals(sbag.body['desc'], 'desc for modify')
	self.assertEquals(cbag.msgname, 'modify_servicegroup_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['servicegroup'][0]
	result = self.server.storage.result
	self.assertEquals(data['id'], 'sg004')
	self.assertEquals(data['desc'], 'desc for modify')
	self.assertEquals(result, SUCCESS)

    def testDelServiceGroup(self):
        self._dbInit({'servicegroup': [{'id': 'sg001'}, \
	                               {'id': 'sg005'}], \
	              'sgservice': [{'sgid': 'sg005', 'serviceid': 'sv001'},  \
		                    {'sgid': 'sg001', 'serviceid': 'sv001'}] \
		     })
	self._socketDone(self.client.data_packed('del_servicegroup', ('servicegroup_id', 'sg005')))
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'del_servicegroup')
	self.assertEquals(sbag.body['servicegroup_id'], 'sg005')
	self.assertEquals(cbag.msgname, 'del_servicegroup_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	gdata = self.server.storage.data['servicegroup']
	sgdata = self.server.storage.data['sgservice']
	result = self.server.storage.result
	self.assertEquals(len(gdata), 1)
	self.assertEquals(gdata[0]['id'], 'sg001')
	self.assertEquals(len(sgdata), 1)
	self.assertEquals(sgdata[0]['sgid'], 'sg001')
	self.assertEquals(sgdata[0]['serviceid'], 'sv001')
	self.assertEquals(result, SUCCESS)

    def testGetServiceGroup(self):
        self._dbInit({'servicegroup': [{'id': 'sg00x3', 'desc': 'servicegroup003'}, \
	                               {'id': 'dxh', 'desc': 'flower'} \
		                   ]})
	self._socketDone(self.client.data_packed('get_servicegroup', ('servicegroup_id', 'sg00x3')))
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'get_servicegroup')
	self.assertEquals(sbag.body['servicegroup_id'], 'sg00x3')
	self.assertEquals(cbag.msgname, 'get_servicegroup_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	self.assertNotEquals(type(cbag.body['servicegroup_num']), str)
	result = cbag.getlist()
	self.assertEquals(len(result), 1)
	self.assertEquals(result[0]['servicegroup_id'], 'sg00x3')
	self.assertEquals(result[0]['desc'], 'servicegroup003')

    def testAddService2Group(self):
        self._dbInit({'servicegroup': [{'id': 'sg045'}, \
	                               {'id': 'sg056'} \
				      ], \
		     'service': [{'id': 'sv01'}, \
		                 {'id': 'sv02'} \
				], \
		     'sgservice': [] \
		    })
	packet = self.client.data_packed('add_service2group',
	                                 ('servicegroup_id', 'sg045'),
					 ('service_id', 'sv01'),
					 ('level', 0x02),
					 ('weight', 0x03)
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'add_service2group')
	self.assertEquals(sbag.body['servicegroup_id'], 'sg045')
	self.assertEquals(sbag.body['service_id'], 'sv01')
	self.assertEquals(sbag.body['level'], 0x2)
	self.assertEquals(sbag.body['weight'], 0x3)
	self.assertEquals(cbag.msgname, 'add_service2group_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	sdata = self.server.storage.data['service']
	gdata = self.server.storage.data['servicegroup']
	sgdata = self.server.storage.data['sgservice']
	self.assertEquals(sdata[0]['id'], 'sv01')
	self.assertEquals(sdata[1]['id'], 'sv02')
	self.assertEquals(gdata[0]['id'], 'sg045')
	self.assertEquals(gdata[1]['id'], 'sg056')
	self.assertEquals(len(sgdata), 1)
	self.assertEquals(sgdata[0]['sgid'], 'sg045')
	self.assertEquals(sgdata[0]['serviceid'], 'sv01')
	self.assertEquals(sgdata[0]['level'], 0x2)
	self.assertEquals(sgdata[0]['weight'], 0x3)

    def testDelService2Group(self):
        self._dbInit({'sgservice': [{'sgid': 'sg03', 'serviceid': 's03'}, \
	                            {'sgid': 'sg03', 'serviceid': 's30'}, \
				    {'sgid': 'sg04', 'serviceid': 's03'} \
				   ]})
	packet = self.client.data_packed('del_service2group', \
	                                 ('servicegroup_id', 'sg03'), \
					 ('service_id', 's03') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'del_service2group')
	self.assertEquals(sbag.body['servicegroup_id'], 'sg03')
	self.assertEquals(sbag.body['service_id'], 's03')
	self.assertEquals(cbag.msgname, 'del_service2group_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['sgservice']
	self.assertEquals(len(data), 2)
	self.assertEquals(data[0]['sgid'], 'sg03')
	self.assertEquals(data[0]['serviceid'], 's30')
	self.assertEquals(data[1]['sgid'], 'sg04')
	self.assertEquals(data[1]['serviceid'], 's03')

    def testGetService2Group(self):
        self._dbInit({'sgservice': [{'sgid': 'sg0607', \
	                             'serviceid': 'sv001', \
				     'level': 21, \
				     'weight': 23 \
				     }, \
				    {'sgid': 'sg0607', \
				     'serviceid': 'sv002', \
				     'level': 22, \
				     'weight': 24 \
				     }, \
				     {'sgid': 'sg0606', \
				      'serviceid': 'sv001', \
				      'level': 22, \
				      'weight': 34 \
				     }], \
		      'service': [{'id': 'sv001', \
		                   'host': 'river', \
				   'port': 80, \
				   'listen_host': 'faye', \
				   'listen_port': 81, \
				   'domain': 98, \
				   'tactics': 99, \
				   'status': 'A' \
				   }, \
				  {'id': 'sv002', \
				   'host': 'faye', \
				   'port': 89, \
				   'listen_host': 'faye1', \
				   'listen_port': 100, \
				   'domain': 90, \
				   'tactics': 91, \
				   'status': 'B' \
				   }]})
	self._socketDone(self.client.data_packed('get_service2group', ('servicegroup_id', 'sg0607')))
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'get_service2group')
	self.assertEquals(sbag.body['servicegroup_id'], 'sg0607')
	self.assertEquals(cbag.msgname, 'get_service2group_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	self.assertNotEquals(type(cbag.body['service_num']), str)
	## db's
	result = cbag.getlist()
	self.assertEquals(len(result), 2)
	self.assertEquals(result[0]['service_id'], 'sv001')
	self.assertEquals(result[0]['host'], 'river')
	self.assertEquals(result[0]['port'], 80)
	self.assertEquals(result[0]['listen_host'], 'faye')
	self.assertEquals(result[0]['listen_port'], 81)
	self.assertEquals(result[0]['level'], 21)
	self.assertEquals(result[0]['weight'], 23)
	self.assertEquals(result[0]['domain'], 98)
	self.assertEquals(result[0]['tactics'], 99)
	self.assertEquals(result[0]['status'], 'A')
	self.assertEquals(result[1]['service_id'], 'sv002')
	self.assertEquals(result[1]['host'], 'faye')
	self.assertEquals(result[1]['port'], 89)
	self.assertEquals(result[1]['listen_host'], 'faye1')
	self.assertEquals(result[1]['listen_port'], 100)
	self.assertEquals(result[1]['level'], 22)
	self.assertEquals(result[1]['weight'], 24)
	self.assertEquals(result[1]['domain'], 90)
	self.assertEquals(result[1]['tactics'], 91)
	self.assertEquals(result[1]['status'], 'B')

    def testGetServiceOfGroup(self):
        self._dbInit({'service': [{'id': 's001'}], \
	              'servicegroup': [{'id': 'sg001', 'desc': 'desc for sg001'}, \
		                       {'id': 'sg002', 'desc': 'desc for sg002'} \
				      ], \
		      'sgservice': [{'sgid': 'sg001', 'serviceid': 's001'}, \
		                    {'sgid': 'sg002', 'serviceid': 's001'} \
				   ]})
	self._socketDone(self.client.data_packed('get_serviceofgroup', ('service_id', 's001')))
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'get_serviceofgroup')
	self.assertEquals(sbag.body['service_id'], 's001')
	self.assertEquals(cbag.msgname, 'get_serviceofgroup_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	self.assertEquals(type(cbag.getlist()), list)
	## db's
	result = cbag.getlist()
	self.assertEquals(len(result), 2)
	self.assertEquals(result[0]['servicegroup_id'], 'sg001')
	self.assertEquals(result[0]['desc'], 'desc for sg001')
	self.assertEquals(result[1]['servicegroup_id'], 'sg002')
	self.assertEquals(result[1]['desc'], 'desc for sg002')
