#!/usr/bin/env python
# -*- coding: utf-8 -*-
# report bugs to: riverfor@sina.com.cn
"""
Test target module: compass.common.response.dispatcherappgroup
"""

from compass.common.error import SUCCESS
from compass.test.dispatcherserver.base import DispatcherServerTestCase

class AppGroupForResponseTestCase(DispatcherServerTestCase):
    """
    this part is response to the request of the application-group's operation
    """
    def testAddGroup2AppFail(self):
        self._dbInit({'application': [{'id': 'app005'}], \
	              'servicegroup': [{'id': 'svgr005'}], \
		      'appsg': [{'appid': 'app005', 'sgid': 'svgr005'}] \
		     })
        packet = self.client.data_packed('add_group2app', \
	                                 ('application_id', 'app005'), \
					 ('servicegroup_id', 'svgr005') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'add_group2app')
	self.assertEquals(sbag.body['application_id'], 'app005')
	self.assertEquals(sbag.body['servicegroup_id'], 'svgr005')
	self.assertEquals(cbag.msgname, 'add_group2app_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	adata = self.server.storage.data['application']
	sgdata = self.server.storage.data['servicegroup']
	asdata = self.server.storage.data['appsg']
	result = self.server.storage.result
	self.assertEquals(adata[0]['id'], 'app005')
	self.assertEquals(sgdata[0]['id'], 'svgr005')
	self.assertEquals(len(asdata), 1)
	self.assertEquals(asdata[0]['appid'], 'app005')
	self.assertEquals(asdata[0]['sgid'], 'svgr005')
	self.assertNotEquals(result, SUCCESS)

    def testAddGroup2AppSuccess(self):
        self._dbInit({'application': [{'id': 'app005'}], \
	              'servicegroup': [{'id': 'svgr004'}, {'id': 'svgr005'}], \
		      'appsg': [{'appid': 'app005', 'sgid': 'svgr004'}] \
		     })
        packet = self.client.data_packed('add_group2app', \
	                                 ('application_id', 'app005'), \
					 ('servicegroup_id', 'svgr005') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'add_group2app')
	self.assertEquals(sbag.body['application_id'], 'app005')
	self.assertEquals(sbag.body['servicegroup_id'], 'svgr005')
	self.assertEquals(cbag.msgname, 'add_group2app_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	adata = self.server.storage.data['application']
	sgdata = self.server.storage.data['servicegroup']
	asdata = self.server.storage.data['appsg']
	result = self.server.storage.result
	self.assertEquals(adata[0]['id'], 'app005')
	self.assertEquals(sgdata[0]['id'], 'svgr004')
	self.assertEquals(sgdata[1]['id'], 'svgr005')
	self.assertEquals(len(asdata), 2)
	self.assertEquals(asdata[0]['appid'], 'app005')
	self.assertEquals(asdata[0]['sgid'], 'svgr004')
	self.assertEquals(asdata[1]['appid'], 'app005')
	self.assertEquals(asdata[1]['sgid'], 'svgr005')
	self.assertEquals(result, SUCCESS)

    def testDelGroup2App(self):
        self._dbInit({'appsg': [{'appid': 'app003', 'sgid': 'sv003'}, \
	                        {'appid': 'app003', 'sgid': 'sv001'}, \
			        {'appid': 'app002', 'sgid': 'sv003'} \
			        ]})
        packet = self.client.data_packed('del_group2app', \
	                                 ('application_id', 'app003'), \
					 ('servicegroup_id', 'sv003') \
					)
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'del_group2app')
	self.assertEquals(sbag.body['application_id'], 'app003')
	self.assertEquals(sbag.body['servicegroup_id'], 'sv003')
	self.assertEquals(cbag.msgname, 'del_group2app_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	data = self.server.storage.data['appsg']
	self.assertEquals(len(data), 2)
	self.assertEquals(data[0]['appid'], 'app003')
	self.assertEquals(data[0]['sgid'], 'sv001')
	self.assertEquals(data[1]['appid'], 'app002')
	self.assertEquals(data[1]['sgid'], 'sv003')

    def testGetGroup2App(self):
        self._dbInit({'appsg': [{'appid': 'app005', 'sgid': 'sg001'}, \
	                        {'appid': 'app005', 'sgid': 'sg002'}, \
				{'appid': 'app004', 'sgid': 'sg003'} \
				], \
		      'servicegroup': [{'id': 'sg001', 'desc': 'desc for sg001'}, \
		                       {'id': 'sg002', 'desc': 'desc for sg002'}, \
				       {'id': 'sg003', 'desc': 'desc for sg003'} \
				       ]})
        packet = self.client.data_packed('get_group2app', ('application_id', 'app005'))
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'get_group2app')
	self.assertEquals(sbag.body['application_id'], 'app005')
	self.assertEquals(cbag.msgname, 'get_group2app_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	## db's
	result = cbag.getlist()
	self.assertEquals(len(result), 2)
	self.assertEquals(result[0]['servicegroup_id'], 'sg001')
	self.assertEquals(result[0]['desc'], 'desc for sg001')
	self.assertEquals(result[1]['servicegroup_id'], 'sg002')
	self.assertEquals(result[1]['desc'], 'desc for sg002')

    def testGetGroupOfApp(self):
        self._dbInit({'appsg': [{'appid': 'app005', 'sgid': 'svid003'}, \
	                        {'appid': 'app004', 'sgid': 'svid003'}, \
				{'appid': 'app003', 'sgid': 'sg003'} \
				], \
		      'application': [{'id': 'app005', 'desc': 'desc for app005'}, \
		                      {'id': 'app004', 'desc': 'desc for app004'}, \
				      {'id': 'app003', 'desc': 'desc for app003'} \
				      ]})
        packet = self.client.data_packed('get_groupofapp', ('servicegroup_id', 'svid003'))
	self._socketDone(packet)
	sbag, cbag = self.server.messages[0], self.client.messages[0]
	self.assertEquals(sbag.msgname, 'get_groupofapp')
	self.assertEquals(sbag.body['servicegroup_id'], 'svid003')
	self.assertEquals(cbag.msgname, 'get_groupofapp_resp')
	self.assertNotEquals(type(cbag.body['status']), str)
	self.assertEquals(type(cbag.getlist()), list)
	## db's
	result = cbag.getlist()
	self.assertEquals(len(result), 2)
	self.assertEquals(result[0]['application_id'], 'app005')
	self.assertEquals(result[0]['desc'], 'desc for app005')
	self.assertEquals(result[1]['application_id'], 'app004')
	self.assertEquals(result[1]['desc'], 'desc for app004')
	
