#!/usr/bin/env python
# -*- coding: utf-8 -*-
# report bugs to: riverfor@sina.com.cn
"""
Test target module: compass.common.request.dispatcherservice
"""

from compass.test.dispatcherclient.base import DispatcherClientTestCase

class ServiceForRespectTestCase(DispatcherClientTestCase):
    """
    this part is the request to the agent's or admin's server
    """
    def testServiceNotify(self):
        """
	send a notify message to the admin or agent
	"""
	self._dbInit({'service': [{'id': 'ntid001', 'status': 'A'}, \
	                          {'id': 'ntid002', 'status': 'D'}, \
			          {'id': 'ntid003', 'status': 'C'} \
				 ], \
		      'sgservice': [{'sgid': 'sg001', \
		                     'serviceid': 'ntid001', \
				     'level': 3, \
				     'weight': 5}, \
				    {'sgid': 'sg001', \
				     'serviceid': 'ntid002', \
				     'level': 4, \
				     'weight': 6}, \
				    {'sgid': 'sg002', \
				     'serviceid': 'ntid003', \
				     'level': 2, \
				     'weight': 7} \
		      		   ]})
	self._csocketDone(self.client.service_notify, 'sg001', 'ntid001')			  
	m = self.server.messages[0]
	bag = m.body.fields
	self.assertEquals(m.msgname, 'service_notify')
	self.assertEquals(bag['service_id'], 'ntid001')
	self.assertEquals(bag['level'], 3)
	self.assertEquals(bag['weight'], 5)
	self.assertEquals(bag['status'], 'A')
