#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: -*-
# report bug to: riverfor@gmail.com
#
# Copyright (c) 2004 The Woodpecker Foundation
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Header: /cvs/root/sinaIndex/compass/compass/protocols/gnsp.py,v 1.3 2004/12/16 10:06:29 hecun Exp $

"""
Stability: Gama
@author: Zoomq(mailto:zoomq@itcase.com)
@see: Open Unified Storage System Protocol norm
"""

## twisted's packages
from twisted.internet import reactor, protocol
## compass's packages
from compass.protocols import byteprotocol
from compass.messages import gnspmsg

### protocol
class GNSProtocol(byteprotocol.ByteMessageProtocol):
    def MessageReceived(self,packet):
        message = gnspmsg.GNSPMessage()
        message.loadMessage(packet)
        self.MessageProcess(message)

    def MessageProcess(self, message):
        method = getattr(self , "on_gnsp_%s" % message.msgname, None)
        return method(message)


