#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: -*-
# report bug to: riverfor@gmail.com
"""
Open Unified Storage System Protocol
Stability: None
@author: U{HD<mailto:hdcola@gmail.com>}
@see: Open Unified Storage System Protocol norm
This module include tha class that agent and dispatcher using
"""

## framework's packages
from time import time, gmtime, strftime
from math import floor
from sha import sha
import struct
## twisted's packages
from twisted.internet import protocol, defer, reactor
## compass's packages
from compass.messages import gnspmsg

### base class: ByteMessageProtocol
class ByteMessageProtocol(protocol.Protocol):
    def __init__(self):
        self.__buffer = ''

    def checkData(self):
        """undocumented
	"""
	while self.__buffer <> '':
	    return

    def dataReceived(self, data):
        self.__buffer = self.__buffer + data
        while len(self.__buffer) > 3:
            (length,) = struct.unpack('>I', self.__buffer[:4])
            if len(self.__buffer) < length:
                break
            message = self.__buffer[:length]
            self.__buffer = self.__buffer[length:]
            defer.succeed(self.MessageReceived(message))

    def sendData(self, data):
        self.transport.write(data)

    def MessageReceived(self,packet):
        pass
	
### base2 class GNSProtocol
class GNSProtocol(ByteMessageProtocol):
    def MessageReceived(self,packet):
        message = gnspmsg.GNSPMessage()
        message.loadMessage(packet)
        self.MessageProcess(message)

    def MessageProcess(self, message):
        method = getattr(self , "on_gnsp_%s" % message.msgname, None)
        return method(message)

### class about time stamp
class ITimeDevice(object):
    def getTimeStamp(self):
        pass

class TimeDevice(ITimeDevice):
    def getTimeStamp(self):
        now = time()
        microsecond = (now - floor(now))*100000000
        microsecond = "%.0f" % microsecond
        timestamp = strftime('%Y%m%d%H%M%S', gmtime(now)) + microsecond
        return timestamp

### functions abaut auth
def makeAuthSource(serviceid, password, timestamp):
    as_plaintext = ''.join([serviceid, password, timestamp])
    return sha(as_plaintext).hexdigest()

def checkAuthSource(authsource, serviceid, password, timestamp):
    return authsource == makeAuthSource(serviceid, password, timestamp)
