#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.dispatcherserver.test_sgservice -*-
# report bug to: riverfor@sina.com.cn
"""
This module includes the  common functions that the service and group operation will call
"""

from compass.common.framework import Storage
from compass.common.framework import DataPacked
from compass.common.error import SUCCESS, DB_IO, SG_EXIST, \
                          SG_NO_EXIST, SERVICE_NO_EXIST, SGSERVICE_NO_EXIST

### the part of response to the request about service
class SrGrResponse(DataPacked):
    def _add_servicegroup(self, message):
        """
.s operation for add_servicegroup
	"""
        msg = message.body.fields
	## check this id if had been used
	if self.lookup('servicegroup', {'id': msg['servicegroup_id']}) != None:
	    return SG_EXIST
	if self.add('servicegroup', {'id': msg['servicegroup_id'], 'desc': msg['desc']}) != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_add_servicegroup(self, message):
        """
	socket's operation for add_servicegroup
	"""
	self.opendb()
	result = self._add_servicegroup(message)
	self.close()
        return self.simple_out('add_servicegroup_resp', result)

    def _del_servicegroup(self, message):
        """
.s operation for del_servicegroup
	"""
        msg = message.body.fields
	## maybe lookup process wasn't needed
	if self.lookup('servicegroup', {'id': msg['servicegroup_id']}) == None:
	    return SG_NO_EXIST
	if self.delete('sgservice', {'sgid': msg['servicegroup_id']}) != SUCCESS:
	    return DB_IO
	if self.delete('servicegroup', {'id': msg['servicegroup_id']}) != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_del_servicegroup(self, message):
        """
	Response to the request of del_servicegroup
	"""
	self.opendb()
	result = self._del_servicegroup(message)
	self.close()
        return self.simple_out('del_servicegroup_resp', result)

    def _modify_servicegroup(self, message):
        """
.s operation for modify_servicegroup
	"""
        msg = message.body.fields
	if self.lookup('servicegroup', {'id': msg['servicegroup_id']}) == None:
	    return SG_NO_EXIST
	if self.update('servicegroup', {'id': msg['servicegroup_id']}, {'desc': msg['desc']}) != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_modify_servicegroup(self, message):
        """
	socket's operation for modify_servicegroup
	"""
	self.opendb()
	result = self._modify_servicegroup(message)
	self.close()
        return self.simple_out('modify_servicegroup_resp', result)

    def _get_servicegroup(self, message):
        """
.s operation for get_servicegroup
	"""
        msg = message.body.fields
	sl = []
	data = self.lookup('servicegroup', {'id': msg['servicegroup_id']})
	if data == None:
	    return  (SG_NO_EXIST, sl)
	for item in data:
	    sl.append({'servicegroup_id': item['id'], 'desc': item['desc']})
	return (SUCCESS, sl)    

    def on_gnsp_get_servicegroup(self, message):
        """
.s operation for get_servicegroup
	"""
	self.opendb()
	result = self._get_servicegroup(message)
	self.close()
	return self.out_with_list('get_servicegroup_resp', result[0], 'servicegroup_num', result[1])

    def _add_service2group(self, message):
        """
.s operation for add_service2group
	"""
        msg = message.body.fields
	if self.lookup('service', {'id': msg['service_id']}) == None:
	    return SERVICE_NO_EXIST
	if self.lookup('servicegroup', {'id': msg['servicegroup_id']}) == None:
	    return SG_NO_EXIST
	if self.lookup('sgservice', {'sgid': msg['servicegroup_id'], 'serviceid': msg['service_id']}) != None:
	    return SGSERVICE_EXIST
	add = self.add('sgservice', {'sgid': msg['servicegroup_id'], \
	                                     'serviceid': msg['service_id'], \
				             'level': msg['level'], \
				             'weight': msg['weight'] \
			                    })
	if add != SUCCESS:
	   return DB_IO
	return SUCCESS   

    def on_gnsp_add_service2group(self, message):
        """
	socket's operation for add_service2group
	"""
	self.opendb()
	result = self._add_service2group(message)
	self.close()
        return self.simple_out('add_service2group_resp', result)
	
    def _del_service2group(self, message):
        """
.s operation for del_service2group
	"""
        msg = message.body.fields
	self.lookup('sgservice', {'sgid': msg['servicegroup_id'], 'serviceid': msg['service_id']})
	if self.lookup('sgservice', {'sgid': msg['servicegroup_id'], 'serviceid': msg['service_id']}) == None:
	    return SGSERVICE_NO_EXIST
	if self.delete('sgservice', {'sgid': msg['servicegroup_id'], 'serviceid': msg['service_id']}) \
            != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_del_service2group(self, message):
        """
	socket's operation for del_service2group
	"""
	self.opendb()
	result = self._del_service2group(message)
	self.close()
        return self.simple_out('del_service2group_resp', result)

    def _get_service2group(self, message):
        """
.s operation for get_service2group
	"""
        msg = message.body.fields
	sl = []
	sgdata = self.lookup('sgservice', {'sgid': msg['servicegroup_id']})
	if sgdata == None:
	    return (SGSERVICE_NO_EXIST, sl)
	for item in sgdata:
	    data = self.lookup('service', {'id': item['serviceid']})[0]
	    sl.append({'service_id': data['id'], \
	               'host': data['host'], \
		       'port': data['port'], \
		       'listen_host': data['listen_host'], \
		       'listen_port': data['listen_port'], \
		       'domain': data['domain'], \
		       'tactics': data['tactics'], \
		       'status': data['status'], \
		       'level': item['level'], \
		       'weight': item['weight'] \
		       })
	return (SUCCESS, sl)	       

    def on_gnsp_get_service2group(self, message):
        """
	socket's operation for get_service2group
	"""
	self.opendb()
	result = self._get_service2group(message)
	self.close()
	return self.out_with_list('get_service2group_resp', result[0], 'service_num', result[1])

    def _get_serviceofgroup(self, message):
        """
.s operation for get_serviceofgroup
	"""
        msg = message.body.fields
	sl = []
	self.lookup('service', {'id': msg['service_id']})
	if self.lookup('service', {'id': msg['service_id']}) == None:
	    return (SERVICE_NO_EXIST, sl)
	data = self.lookup('sgservice', {'serviceid': msg['service_id']})
	if data == None:
	    return (SGSERVICE_NO_EXIST, sl)
	for item in data:
	    gdata = self.lookup('servicegroup', {'id': item['sgid']})[0]
	    sl.append({'servicegroup_id': gdata['id'], 'desc': gdata['desc']})
	return (SUCCESS, sl)    

    def on_gnsp_get_serviceofgroup(self, message):
        """
	socket's operation for get_serviceofgroup
	"""
	self.opendb()
	result = self._get_serviceofgroup(message)
	self.close()
	return self.out_with_list('get_serviceofgroup_resp', result[0], 'servicegroup_num', result[1])
