#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.dispatcherserver.test_service-*-
# report bug to: riverfor@sina.com.cn
"""
This module includes the  common functions that the service operation will call
compass.common.response.dispatcherservice.ServiceReseponse
"""

from compass.common.framework import Storage
from compass.common.framework import DataPacked
from compass.common.config import SR_STATUS_LOGOUT, SR_STATUS_INWARNING   
from compass.common.error import SUCCESS, DB_IO, SERVICE_EXIST, SERVICE_NO_EXIST
from compass.common.util import ito2

### the part of response to the request about service
class ServiceReseponse(DataPacked):
    """
    Response for the client's request about service's operation
    """
    def _add_service(self, message):
        """
.s operation for add_service
	"""
        msg = message.body.fields
	if self.lookup('service', {'id': msg['service_id']}) != None:
	    return SERVICE_EXIST
	add = self.add('service', {'id': msg['service_id'],\
	                                   'desc' : msg['desc'], \
				           'password': msg['password'], \
			                   'host':  msg['host'], \
				           'port': int(msg['port']), \
				           'domain': int(msg['domain']), \
				           'tactics': int(msg['tactics']), \
				           'status': msg['status'] \
		                          })
        if add != SUCCESS:
	    return DB_IO
	return SUCCESS    
        
    def on_gnsp_add_service(self, message):
        """
	socket's operation for add_service
	"""
	self.opendb()
	result = self._add_service(message)
	self.close()
        return self.simple_out('add_service_resp', result)
	
    def _del_service(self, message):
        """
.s operation for del_service 
	"""
        msg = message.body.fields
	if self.lookup('service', {'id': msg['service_id']}) == None:
	    return SERVICE_NO_EXIST
	if self.delete('sgservice', {'serviceid': msg['service_id']}) != SUCCESS:
	    return DB_IO
	if self.delete('service', {'id': msg['service_id']}) != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_del_service(self, message):
        """
	socket's operation for del_service
	"""
	self.opendb()
	result = self._del_service(message)
	self.close()
	return self.simple_out('del_service_resp', result)

    def _service_login(self, message):
        """
.s operation for service_login
	"""
        msg = message.body.fields
	if self.lookup('service', {'id': msg['service_id']}) == None:
	    return SERVICE_NO_EXIST
	update = self.update('service', {'id': msg['service_id']}, \
	                                        {'status': msg['status'], \
			               	         'listen_host': msg['listen_host'], \
				                 'listen_port': msg['listen_port'] \
				                 }) 
        if update != SUCCESS:
	    return DB_IO
	return SUCCESS    
	    
    def on_gnsp_service_login(self, message):	
        """
	socket's operation for service_login
	"""
	self.opendb()
	result = self._service_login(message)
	self.close()
	return self.simple_out('service_login_resp', result)

    def _service_logout(self, message):
        """
.s operation for service_logout
	"""
        msg = message.body.fields
	## check this id if exist
	if self.lookup('service', {'id': msg['service_id']}) == None:
	    return SERVICE_NO_EXIST
	if self.update('service', {'id': msg['service_id']}, {'status': SR_STATUS_LOGOUT}) != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_service_logout(self, message):
        """
	socket's operation for service_logout
	"""
	self.opendb()
	result = self._service_logout(message)
	self.close()
	return self.simple_out('service_logout_resp', result)

    def _service_warning(self, message):
        """
.s operation for service_warning
	"""
        msg = message.body.fields
	## check this id if exist
	if self.lookup('service', {'id': msg['service_id']}) == None:
	    ## report servie no exist
	    return SERVICE_NO_EXIST
	if self.lookup('service', {'id': msg['warning_id']}) == None:
	    ## warninged servie no exist
	    return SERVICE_NO_EXIST
	if self.update('service', {'id': msg['warning_id']}, {'status': SR_STATUS_INWARNING}) != SUCCESS:
	    return DB_IO
	return SUCCESS

    def on_gnsp_service_warning(self, message):
        """
	socket's operation for service_warning
	"""
	self.opendb()
	result = self._service_warning(message)
	self.close()
	return self.simple_out('service_warning_resp', result)

    def _get_service(self, message):
        """
.s operation for get_service
	"""
        msg = message.body.fields
	sl = []
	data = self.lookup('service', {'id': msg['service_id']})
	if data == None:
	    return (SERVICE_NO_EXIS, sl)
	for item in data:
	    sl.append({'service_id': item['id'], \
	               'desc': item['desc'], \
		       'host': item['host'], \
		       'port': item['port'], \
		       'listen_host': item['listen_host'], \
		       'listen_port': item['listen_port'], \
		       'domain': item['domain'], \
		       'tactics': item['tactics'], \
		       'status': item['status'] \
		       })
        return (SUCCESS, sl)

    def on_gnsp_get_service(self, message):
        """
	socket's operation for get_service
	"""
	self.opendb()
	result = self._get_service(message)
	self.close()
	return self.out_with_list('get_service_resp', result[0], 'service_num', result[1])

    def _select_service(self, message):
        """
.s operation for select_service
	"""
        msg = message.body.fields
	sl = []
	sdata = self.lookup('service', {'id': msg['service_id']})
	if sdata == None:
	    return (SERVICE_NO_EXIST, sl)
	sgdata = self.lookup('sgservice', {'serviceid': msg['service_id']})
	if sgdata == None:
	    return (SGSERVICE_NO_EXIST, sl)
	for item in sgdata:
	    sl.append({'service_id': msg['service_id'], \
		       'servicegroup_id': item['sgid'], \
		       'host': sdata[0]['host'], \
		       'port': sdata[0]['port'], \
		       'level': item['level'], \
		       'weight': item['weight'] \
		       })
	return (SUCCESS, sl)	       

    def on_gnsp_select_service(self, message):
        """
	socket's operation for select_service
	"""
	self.opendb()
	result = self._select_service(message)
	self.close()
	return self.out_with_list('select_service_resp', result[0], 'service_num', result[1])

    def _modify_service(self, message):
        """
.s operation for modify_service
	"""
        msg = message.body.fields
	## dict for the mask to select the fields to be modified.
	up_dict, up_data = ('desc', 'password', 'host', 'port', 'domain', 'tactics', 'status'), {}
	up_key = ito2(msg['mask'])
	for item in range(1, len(up_key) + 1):
	    ## check if the mask bite is 1
	    if up_key[item - 1] == 1:
	        var = up_dict[item - 1]
	        up_data[var] =  msg[var]
	if self.update('service', {'id': msg['service_id']}, up_data) != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_modify_service(self, message):
        """
	socket's operation for modify_service
	"""
	self.opendb()
	result = self._modify_service(message)
	self.close()
        return self.simple_out('modify_service_resp', result)
