#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.dispatcherserver.test_depend -*-
# report bugs to: riverfor@sina.com.cn
"""
this module includes the operations on depended that the applicationserver will call
"""

from compass.common.framework import Storage
from compass.common.framework import DataPacked
from compass.common.error import SUCCESS, DB_IO, SG_NO_EXIST, \
                          DEPEND_EXIST, DEPEND_NO_EXIST, DEPEND_EACH

class DependResponse(DataPacked):
    def _add_depend(self, message):
        """
.s operation for add_depend
	"""
	msg = message.body.fields
	if self.lookup('servicegroup', {'id': msg['from_id']}) == None:
	    return SG_NO_EXIST
	if self.lookup('servicegroup', {'id': msg['to_id']}) == None:
	    return SG_NO_EXIST
	if self.lookup('depended', {'sgid': msg['from_id'], 'dependedid': msg['to_id']}) != None:
	    return DEPEND_EXIST
	if self.lookup('depended', {'sgid': msg['to_id'], 'dependedid': msg['from_id']}) != None:
	    return DEPEND_EACH
	if self.add('depended', {'sgid': msg['from_id'], 'dependedid': msg['to_id']}) != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_add_depend(self, message):
        """
	socket's operation for add_depend
	"""
	self.opendb()
	result = self._add_depend(message)
	self.close()
        return self.simple_out('add_depend_resp', result)

    def _del_depend(self, message):
        """
.s operation for del_depend
	"""
	msg = message.body.fields
	if self.lookup('depended', {'sgid': msg['from_id'], 'dependedid': msg['to_id']}) == None:
	    return DEPEND_NO_EXIST
	if self.delete('depended', {'sgid': msg['from_id'], 'dependedid': msg['to_id']}) != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_del_depend(self, message):
        """
	socket's operation for del_depend
	"""
	self.opendb()
	result = self._del_depend(message)
	self.close()
        return self.simple_out('del_depend_resp', result)

    def _get_depend(self, message):
        """
.s operation for get_depend
	"""
	msg = message.body.fields
	sl = []
	fdata = self.lookup('depended', {'sgid': msg['from_id']})
	if fdata != None:
	    for item in fdata:
	        sl.append({'from_id': item['sgid'], 'to_id': item['dependedid']})
	tdata = self.lookup('depended', {'dependedid': msg['to_id']})
	if tdata != None:
	    for item in tdata:
	        ## check if the item had been in
	        tmp = {'from_id': item['sgid'], 'to_id': item['dependedid']}
		if sl.count(tmp) == 0:
		    sl.append(tmp)
	return (SUCCESS, sl)	

    def on_gnsp_get_depend(self, message):
        """
	socket's operation for get_depend
	"""
	self.opendb()
	result = self._get_depend(message)
	self.close()
	return self.out_with_list('get_depend_resp', result[0], 'depended_num', result[1])
