#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.dispatcherserver.test_appgroup-*-
# report bug to: riverfor@sina.com.cn
"""
this module includes the operations on applicationgroup that the dispatcherserver will call
"""

from compass.common.framework import Storage
from compass.common.framework import DataPacked
from compass.common.error import SUCCESS, DB_IO, SG_EXIST, \
                          SG_NO_EXIST, APP_NO_EXIST, APP_NO_EXIST, APPSG_NO_EXIST, APPSG_EXIST

### the part of request about appgroup
class AppGroupResponse(DataPacked):
    def _add_group2app(self, message):
        """
.s operation for add_group2app
	"""
        msg = message.body.fields
	if self.lookup('application', {'id': msg['application_id']}) == None:
	    return APP_NO_EXIST
	if self.lookup('servicegroup', {'id': msg['servicegroup_id']}) == None:
	    return SG_NO_EXIST
	if self.lookup('appsg', {'appid': msg['application_id'], 'sgid': msg['servicegroup_id']}) != None:
	    return APPSG_EXIST
	if self.add('appsg', {'appid': msg['application_id'], 'sgid': msg['servicegroup_id']}) != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_add_group2app(self, message):
        """
	socket's operation for add_group2app
	"""
	self.opendb()
	result = self._add_group2app(message)
	self.close()
        return self.simple_out('add_group2app_resp', result)

    def _del_group2app(self, message):
        """
.s operation for del_group2app
	"""
        msg = message.body.fields
	if self.lookup('appsg', {'appid': msg['application_id'], 'sgid': msg['servicegroup_id']}) == None:
	    return APPSG_NO_EXIST
	if self.delete('appsg', {'appid': msg['application_id'], 'sgid': msg['servicegroup_id']}) != SUCCESS:
	    return DB_IO
	return SUCCESS    
	
    def on_gnsp_del_group2app(self, message):
        """
	socket's operation for del_group2app
	"""
	self.opendb()
	result = self._del_group2app(message)
	self.close()
        return self.simple_out('del_group2app_resp', result)

    def _get_group2app(self, message):
        """
.s operation for get_group2app
	"""
	msg = message.body.fields
	sl = []
	data = self.lookup('appsg', {'appid': msg['application_id']})
	if data == None:
	    return (APP_NO_EXIST, sl)
	for item in data:
	    gdata = self.lookup('servicegroup', {'id': item['sgid']})
	    if gdata == None:
	        return (SG_NO_EXIST, sl)
	    sl.append({'servicegroup_id': gdata[0]['id'], 'desc': gdata[0]['desc']})
	return (SUCCESS, sl)    

    def on_gnsp_get_group2app(self, message):
        """
	socket's operation for get_group2app
	""" 
	self.opendb()
	result = self._get_group2app(message)
	self.close()
	return self.out_with_list('get_group2app_resp', result[0], 'servicegroup_num', result[1])

    def _get_groupofapp(self, message):
        """
.s operation for get_groupofapp
	"""
	msg = message.body.fields
	sl = []
	data = self.lookup('appsg', {'sgid': msg['servicegroup_id']})
	if data == None:
	    return (SG_NO_EXIST, sl)
	for item in data:
	    adata = self.lookup('application', {'id': item['appid']})
	    if adata == None:
	        return (APP_NO_EXIST, sl)
            sl.append({'application_id': adata[0]['id'], 'desc': adata[0]['desc']})
	return (SUCCESS, sl)    

    def on_gnsp_get_groupofapp(self, message):
        """
	Response to the request of get_groupofapp
	"""
	self.opendb()
	result = self._get_groupofapp(message)
	self.close()
	return self.out_with_list('get_groupofapp_resp', result[0], 'application_num', result[1])
