#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.dispatcherserver.test_app -*-
# report bug to: riverfor@sina.com.cn
"""
This module includes the operations on application that the dispatcherserver will call
"""

## compass's packages
from compass.common.framework import Storage
from compass.common.framework import DataPacked
from compass.common.error import SUCCESS, DB_IO, APP_EXIST, APP_NO_EXIST

### the part of request about application
class ApplicationResponse(DataPacked, Storage):
    def _add_application(self, message):
        """
.s operation for add_application
	"""
        msg = message.body.fields
	## check whether this id was used
	if self.lookup('application', {'id': msg['application_id']}) != None:
	    return APP_EXIST
	if self.add('application', {'id': msg['application_id'], 'desc': msg['desc']}) != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_add_application(self, message):
        """
	socket's operation for add_application
	"""
	self.opendb()
	result = self._add_application(message)
	self.close()
        return self.simple_out('add_application_resp', result)
	
    def _del_application(self, message):
        """
.s operation for del_application
	"""
        msg = message.body.fields
	if self.lookup('application', {'id': msg['application_id']}) == None:
	    return APP_NO_EXIST
	if self.delete('appsg', {'appid': msg['application_id']}) != SUCCESS:
	    return DB_IO
	if self.delete('application', {'id': msg['application_id']}) != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_del_application(self, message):
        """
	Response to the request of del_application
	"""
	self.opendb()
	result = self._del_application(message)
	self.close()
        return self.simple_out('del_application_resp', result)

    def _modify_application(self, message):
        """
.s operation for modify_application
	"""
        msg = message.body.fields
	if self.lookup('application', {'id': msg['application_id']}) == None:
	    return APP_NO_EXIST
        if self.update('application', {'id': msg['application_id']}, {'desc': msg['desc']}) != SUCCESS:
	    return DB_IO
	return SUCCESS    

    def on_gnsp_modify_application(self, message):
        """
	socket's operation for modify_application
	"""
	self.opendb()
	result = self._modify_application(message)
	self.close()
        return self.simple_out('modify_application_resp', result)

    def _get_application(self, message):
        """
.s operation for get_application
	"""
        msg = message.body.fields
	sl = []
	data = self.lookup('application', {'id': msg['application_id']})
	if data == None:
	    return (APP_NO_EXIST, sl)
	for item in data:
	    sl.append({'application_id': item['id'], 'desc': item['desc']})
	return (SUCCESS, sl)    

    def on_gnsp_get_application(self, message):
        """
	socket's operation for get_application
	"""
	self.opendb()
	result = self._get_application(message)
	self.close()
	return self.out_with_list('get_application_resp', result[0], 'applcation_num', result[1])
