#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.adminclient/agentclient.test_sgservice -*-
# report bug to: riverfor@sina.com.cn
"""
This module includes the  common functions that the service and group operation will call
"""
from compass.common.framework import DataPacked

### the part of request about service
class SrGrRequest(DataPacked):
    def add_servicegroup(self, servicegroup_id, desc):
        return self.sendData(self.data_packed('add_servicegroup', \
	                               ('servicegroup_id', servicegroup_id), \
				       ('desc', desc)))

    def on_gnsp_add_servicegroup_resp(self, messages):
        pass

    def modify_servicegroup(self, servicegroup_id, desc):
        return self.sendData(self.data_packed('modify_servicegroup',
	                               ('servicegroup_id', servicegroup_id),
				       ('desc', desc)
				      ))
				      
    def on_gnsp_modify_servicegroup_resp(self, mesage):
        pass

    def del_servicegroup(self, servicegroup_id):
        return self.sendData(self.data_packed('del_servicegroup',
	                             ('servicegroup_id', servicegroup_id)
				    )) 

    def on_gnsp_del_servicegroup_resp(self, message):
        pass

    def get_servicegroup(self, servicegroup_id):
        return self.sendData(self.data_packed('get_servicegroup',
	                               ('servicegroup_id', servicegroup_id)
				      ))

    def on_gnsp_get_servicegroup_resp(self, message):
        pass

    #### service 2 group
    def add_service2group(self, servicegroup_id, service_id, level, weight):
        packet = self.data_packed('add_service2group',
	                          ('servicegroup_id', servicegroup_id),
				  ('service_id', service_id),
				  ('level', level),
				  ('weight', weight)
				 )
	return self.sendData(packet)			 

    def on_gnsp_add_service2group_resp(self, message):
        pass

    def del_service2group(self, servicegroup_id, service_id):
        packet = self.data_packed('del_service2group',
	                          ('servicegroup_id', servicegroup_id),
				  ('service_id', service_id)
				 )
	return self.sendData(packet)			 

    def on_gnsp_del_service2group_resp(self, message):
        pass

    def get_service2group(self, servicegroup_id):
        return self.sendData(self.data_packed('get_service2group', ('servicegroup_id', servicegroup_id)))

    def on_gnsp_get_service2group_resp(self, message):
        pass

    def get_serviceofgroup(self, service_id):
        return self.sendData(self.data_packed('get_serviceofgroup', ('service_id', service_id)))

    def on_gnsp_get_serviceofgroup_resp(self, message):
        pass
